<?php

session_start();

header('Content-Type: application/json');

include('../../../php/conn.php');

require('../libs/phpqrcode/qrlib.php');

// Actualizando zona horaria del servidor
  $q_timezone = "SET TIME_ZONE = 'America/Lima'";

  if ($res = mysqli_query($enlace, $q_timezone)) {
  }

  if ($res = mysqli_query($enlace_host, $q_timezone)) {
  }

// Permite obtener el nombde de casa mes
  function nombre_meses($num_mes){
    if ($num_mes == 1){
      return "ENERO";
    }
    if ($num_mes == 2){
      return "FEBRERO";
    }
    if ($num_mes == 3){
      return "MARZO";
    }
    if ($num_mes == 4){
      return "ABRIL";
    }
    if ($num_mes == 5){
      return "MAYO";
    }
    if ($num_mes == 6){
      return "JUNIO";
    }
    if ($num_mes == 7){
      return "JULIO";
    }
    if ($num_mes == 8){
      return "AGOSTO";
    }
    if ($num_mes == 9){
      return "SEPTIEMBRE";
    }
    if ($num_mes == 10){
      return "OCTUBRE";
    }
    if ($num_mes == 11){
      return "NOVIEMBRE";
    }
    if ($num_mes == 12){
      return "DICIEMBRE";
    }
  }

// Generador de claves Random
  function f_RandomKey($len) {
    $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';

    $r_name = substr(str_shuffle($permitted_chars), 0, $len);

    return $r_name;
  }

// Para PHPMailer
  require ('../phpmailer/PHPMailerAutoload.php');

  switch ($_POST["accion"]) {

    case 'cargaLista_Categorias':
      $r = array();
      $estado = 0;

      $compania = $_POST["compania"];
      $tienda = $_POST["tienda"];

      $q_categorias = "EXEC sp_Obtener_Categorias ".$compania.", ".$tienda;

      if ($res_categorias = sqlsrv_query($enlacehost, $q_categorias)) {
        while($row_categorias = sqlsrv_fetch_array($res_categorias, SQLSRV_FETCH_ASSOC)) {
          $estado = 1;

          array_push($r, $row_categorias);
        }
        
        echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'cargaLista_Productos':
      $r = array();
      $estado = 0;

      $tipo = $_POST["tipo"];
      $compania = $_POST["compania"];
      $tienda = $_POST["tienda"];
      $terminal = $_POST["terminal"];
      $tipo_categoria = $_POST["tipo_categoria"];
      $id_categoria = $_POST["id_categoria"];
      $id_cliente = (($_POST["id_cliente"] == 0) ? '999999' : $_POST["id_cliente"]);
      $descripcion = 'X';

      // Verificado el tipo de lista que va a cargar (Productos Individuales o Combos)
        if ($tipo == 'i'){
          $q_productos = "SELECT  iIdProduct,
                                  cProductName,
                                  dSalesPrice
                            FROM  Product
                           WHERE  iIdCompany = ".$compania."
                             AND  id_Tienda = ".$tienda."
                             AND  bEsPack = 0
                          ORDER BY cProductName";

          if ($tipo_categoria == 'F'){
            $q_productos .= " AND bEsFavorito = 1";
          }
        }
        else{
          $q_productos = "SELECT  Id_Producto,
                                  Elemento_Analisis,
                                  Precio_Combo,
                                  IdProductos_Combo,
                                  CodProductos_Combo
                            FROM  _max_labperu_ClientesCombos
                           WHERE  Estado_Combo = 'A'
                             AND  Id_Cliente = ".$id_cliente."
                          ORDER BY Elemento_Analisis";
        }

      // sqlsrv_configure("WarningsReturnAsErrors", 0);

      if ($res_productos = sqlsrv_query($enlacehost, $q_productos)) {
          while($row_productos = sqlsrv_fetch_array($res_productos)) {
            $estado = 1;

            array_push($r, $row_productos);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }
      else{
        if( ($errors = sqlsrv_errors() ) != null) {
          foreach( $errors as $error ) {
            echo "SQLSTATE: ".$error[ 'SQLSTATE']."\n";
            echo "code: ".$error[ 'code']."\n";
            echo "message: ".$error[ 'message']."\n";
          }
        }
      }

      break;

    case 'cargaLista_Productos_AddElementos':
      $r = array();
      $estado = 0;

      $compania = $_POST["compania"];
      $tienda = $_POST["tienda"];

      $id_elementos = $_POST["id_elementos"];

      $q_productos = "SELECT  iIdProduct,
                              cProductName,
                              dSalesPrice
                        FROM  Product
                       WHERE  iIdCompany = ".$compania."
                         AND  id_Tienda = ".$tienda."
                         AND  bEsPack = 0
                         AND  iIdProduct NOT IN (".$id_elementos.")
                      ORDER BY cProductName";

      // sqlsrv_configure("WarningsReturnAsErrors", 0);

      if ($res_productos = sqlsrv_query($enlacehost, $q_productos)) {
          while($row_productos = sqlsrv_fetch_array($res_productos)) {
            $estado = 1;

            array_push($r, $row_productos);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }
      else{
        if( ($errors = sqlsrv_errors() ) != null) {
          foreach( $errors as $error ) {
            echo "SQLSTATE: ".$error[ 'SQLSTATE']."\n";
            echo "code: ".$error[ 'code']."\n";
            echo "message: ".$error[ 'message']."\n";
          }
        }
      }

      break;

    case 'get_CodigoInterno':
      $r = array();
      $estado = 1;

      $compania = $_POST["compania"];
      $tienda = $_POST["tienda"];
      $terminal = $_POST["terminal"];
      $user = $_POST["user"];
      $anho = $_POST["anho"];
      $mes = $_POST["mes"];

      $id_pedido = '';

      // Verificar el estado del último registro
        $q_IdPedido = "SELECT TOP 1 iId_Cabecera_Pedido AS ID_PEDIDO,
                               cEstadoPermanencia
                         FROM  Cabecera_Pedido
                        WHERE  iIdCompany = ".$compania."
                          AND  iIdTienda = ".$tienda."
                          AND  iId_Terminal = ".$terminal."
                          AND  iIdUser = ".$user."
                       ORDER BY dFechaGuardadoPedido DESC";

        if ($res_IdPedido = sqlsrv_query($enlacehost, $q_IdPedido)) {
          if (sqlsrv_has_rows($res_IdPedido) == 1) {
            while($row_IdPedido = sqlsrv_fetch_array($res_IdPedido)) {
              $estado_pedido = $row_IdPedido["cEstadoPermanencia"];
              $id_pedido = $row_IdPedido["ID_PEDIDO"];

              array_push($r, $row_IdPedido);

              if ($estado_pedido <> 'T'){
                // Generar Nuevo Pedido
                  $q_newpedido = "EXEC sp_get_ultimo_pedido_company_terminal_v5 ".$compania.", ".$tienda.", ".$terminal.", ".$user.", 0,
                                  '', '', 0, '', 0,
                                  '', '', 0, 0, 0,
                                  0, 0, 0, 0, 0,
                                  '', '', '', '', 0,
                                  '', 0, '', 0, '',
                                  '', 0";

                  if ($res_newpedido = sqlsrv_query($enlacehost, $q_newpedido)) {
                    $r = array();

                    $q_NewIdPedido = "SELECT TOP 1 iId_Cabecera_Pedido AS ID_PEDIDO,
                                             cEstadoPermanencia, '' AS X
                                        FROM  Cabecera_Pedido
                                       WHERE  iIdCompany = ".$compania."
                                         AND  iIdTienda = ".$tienda."
                                         AND  iId_Terminal = ".$terminal."
                                         AND  iIdUser = ".$user."
                                         AND  cEstadoPermanencia = 'T'
                                      ORDER BY dFechaGuardadoPedido DESC";

                    if ($res_NewIdPedido = sqlsrv_query($enlacehost, $q_NewIdPedido)) {
                      if (sqlsrv_has_rows($res_NewIdPedido) == 1) {
                        while($row_NewIdPedido = sqlsrv_fetch_array($res_NewIdPedido)) {
                          $id_pedido = $row_NewIdPedido["ID_PEDIDO"];

                          array_push($r, $row_NewIdPedido);
                        }
                      }
                    }
                  }

                // Guardar nuevo Código Interno solo para cuando el estado del pedido es diferente a "T"
                  // $q_CI = "SELECT  FORMAT(COALESCE(MAX(correlativo), 0) + 1, '0000') AS CORRELATIVO, '' AS cEstadoPermanencia
                  //            FROM  _max_labperu_CorrelativoVenta
                  //           WHERE  anho = ".$anho."
                  //             AND  mes = ".$mes;

                  $q_CI = "SELECT '".substr(nombre_meses($mes), 0, 3).substr($anho, 0, -2)."-' + CONVERT(VARCHAR, FORMAT(COALESCE(MAX(correlativo), 0) + 1, '0000')) AS CORRELATIVO, 
                                  '' AS cEstadoPermanencia,
                                  FORMAT(COALESCE(MAX(correlativo), 0) + 1, '0000') AS X
                             FROM _max_labperu_CorrelativoVenta
                            WHERE anho = ".$anho."
                              AND mes = ".$mes;

                  if ($res_CI = sqlsrv_query($enlacehost, $q_CI)) {
                    while($row_CI = sqlsrv_fetch_array($res_CI)) {
                      $estado = 1;

                      array_push($r, $row_CI);

                      // Graba nuevo correlativo
                        $q_insert = "INSERT INTO _max_labperu_CorrelativoVenta (anho, mes, correlativo, id_pedido)
                                      VALUES(".$anho.", 
                                             ".$mes.",
                                             ".$row_CI["X"].",
                                             ".$id_pedido.")";

                        if ($res_insert = sqlsrv_query($enlacehost, $q_insert)) {
                        }
                    }
                  }
              }
              else{
                // Si viene como "T" solo se consulta el último correlativo para recuperarlo
                  $q_CI = "SELECT  anho, mes,
                                   FORMAT(COALESCE(MAX(correlativo), 0), '0000') AS CORRELATIVO,
                                   '' AS cEstadoPermanencia
                             FROM  _max_labperu_CorrelativoVenta
                            WHERE  id_pedido = ".$id_pedido."
                           GROUP BY anho, mes";

                  if ($res_CI = sqlsrv_query($enlacehost, $q_CI)) {
                    while($row_CI = sqlsrv_fetch_array($res_CI)) {
                      $anho_x = $row_CI["anho"];
                      $mes_x = $row_CI["mes"];
                      $correlativo_x = $row_CI["CORRELATIVO"];

                      $q_CI_x = "SELECT '".substr(nombre_meses($mes_x), 0, 3).substr($anho_x, 0, -2)."-' + CONVERT(VARCHAR, '".$correlativo_x."') AS CORRELATIVO, '' AS cEstadoPermanencia";

                      if ($res_CI_x = sqlsrv_query($enlacehost, $q_CI_x)) {
                        while($row_CI_x = sqlsrv_fetch_array($res_CI_x)) {
                          $estado = 1;

                          array_push($r, $row_CI_x);
                        }
                      }
                    }
                  }
              }
            }
          }
          else{
            // Generar Nuevo Pedido
              $q_newpedido = "EXEC sp_get_ultimo_pedido_company_terminal_v5 ".$compania.", ".$tienda.", ".$terminal.", ".$user.", 0,
                              '', '', 0, '', 0,
                              '', '', 0, 0, 0,
                              0, 0, 0, 0, 0,
                              '', '', '', '', 0,
                              '', 0, '', 0, '',
                              '', 0";

              if ($res_newpedido = sqlsrv_query($enlacehost, $q_newpedido)) {
              }

            // Recuperar datos del nuevo pedido generado
              $q_IdPedido = "SELECT TOP 1 iId_Cabecera_Pedido AS ID_PEDIDO,
                                     cEstadoPermanencia
                               FROM  Cabecera_Pedido
                              WHERE  iIdCompany = ".$compania."
                                AND  iIdTienda = ".$tienda."
                                AND  iId_Terminal = ".$terminal."
                                AND  iIdUser = ".$user."
                                AND  cEstadoPermanencia = 'T'
                             ORDER BY dFechaGuardadoPedido DESC";

              if ($res_IdPedido = sqlsrv_query($enlacehost, $q_IdPedido)) {
                if (sqlsrv_has_rows($res_IdPedido) ==  1) {
                  while($row_IdPedido = sqlsrv_fetch_array($res_IdPedido)) {
                    $estado_pedido = $row_IdPedido["cEstadoPermanencia"];
                    $id_pedido = $row_IdPedido["ID_PEDIDO"];

                    array_push($r, $row_IdPedido);
                  }
                }
              }

            // Guardar nuevo Código Interno solo para cuando el estado del pedido es diferente a "T"
              // $q_CI = "SELECT  FORMAT(COALESCE(MAX(correlativo), 0) + 1, '000') AS CORRELATIVO, '' AS cEstadoPermanencia
              //            FROM  _max_labperu_CorrelativoVenta
              //           WHERE  anho = ".$anho."
              //             AND  mes = ".$mes;

              $q_CI = "SELECT '".substr(nombre_meses($mes), 0, 3).substr($anho, 0, -2)."-' + CONVERT(VARCHAR, FORMAT(COALESCE(MAX(correlativo), 0) + 1, '0000')) AS CORRELATIVO, 
                              '' AS cEstadoPermanencia,
                              FORMAT(COALESCE(MAX(correlativo), 0) + 1, '0000') AS X
                         FROM _max_labperu_CorrelativoVenta
                        WHERE anho = ".$anho."
                          AND mes = ".$mes;

              if ($res_CI = sqlsrv_query($enlacehost, $q_CI)) {
                while($row_CI = sqlsrv_fetch_array($res_CI)) {
                  $estado = 1;

                  array_push($r, $row_CI);

                  // Graba nuevo correlativo
                    $q_insert = "INSERT INTO _max_labperu_CorrelativoVenta (anho, mes, correlativo, id_pedido)
                                  VALUES(".$anho.", 
                                         ".$mes.",
                                         ".$row_CI["X"].",
                                         ".$id_pedido.")";

                    if ($res_insert = sqlsrv_query($enlacehost, $q_insert)) {
                    }
                }
              }
          }

          echo json_encode(array('estado' => $estado, 'registros' => $r));
        }

      break;

    case 'get_IdItemDetalle':
      $r = array();
      $estado = 0;

      $IdPedido = $_POST["IdPedido"];

      $q_IdItemPedido = "SELECT FORMAT(COUNT(iId_Detalle_Pedido) + 1, '000') AS _COUNT
                           FROM Detalle_Pedido
                          WHERE iId_Cabecera_Pedido = ".$IdPedido;

      if ($res_IdItemPedido = sqlsrv_query($enlacehost, $q_IdItemPedido)) {
          while($row_IdItemPedido = sqlsrv_fetch_array($res_IdItemPedido)) {
            $estado = 1;

            array_push($r, $row_IdItemPedido);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Get_Clientes':
      $r = array();
      $estado = 0;

      $idCompany = $_POST["idCompany"];

      $tipo_filtro = $_POST["tipo_filtro"];
      $filtro = $_POST["filtro"];
      $admin_clientes = $_POST["admin_clientes"];

      $q_Clientes = "SELECT maestroCliente.iIdCliente,
                            maestroCliente.cNumeroRuc,
                            maestroCliente.cRazonSocial,
                            maestroCliente.id_Tipo_Documento,
                            TipodeDocumento.id_doc_sunat,
                            maestroCliente.cEmail,
                            maestroCliente.cNumeroTelefono,
                            maestroCliente.cSegundoNumeroTelefono,
                            TipoCliente.cDescripcionTipoCliente AS TIPO_CLIENTE,
                            TipodeDocumento.cDescripcionCorta AS TIPO_DOCUMENTO,
                            cEstado_Eliminado,
                            iTipoCliente,
                            Id_Tipo_Documento,
                            maestroCliente.cDireccion
                       FROM maestroCliente
                            INNER JOIN TipoCliente ON maestroCliente.iTipoCliente = TipoCliente.idTipoCliente
                            INNER JOIN TipodeDocumento ON maestroCliente.Id_Tipo_Documento = TipodeDocumento.iIdTipoDocumento
                      WHERE iIdCompany = ".$idCompany;

      if ($admin_clientes == 0){
        $q_Clientes .= " AND cEstado_Eliminado <> 'I'";
      }

      if ($tipo_filtro == 1 || $tipo_filtro == 3){
        $q_Clientes .= " AND cNumeroRuc LIKE '%".$filtro."%'";
        $q_Clientes .= " ORDER BY cNumeroRuc";
      }
      else{
        $q_Clientes .= " AND cRazonSocial LIKE '%".$filtro."%'";
        $q_Clientes .= " ORDER BY cRazonSocial";
      }

      if ($res_Clientes = sqlsrv_query($enlacehost, $q_Clientes)) {
          while($row_Clientes = sqlsrv_fetch_array($res_Clientes)) {
            $estado = 1;

            array_push($r, $row_Clientes);
          }
      }

      echo json_encode(array('estado' => $estado, 'registros' => $r));

      break;

    case 'Get_CabeceraPedido':
      $r = array();
      $estado = 0;

      $Id_Pedido = $_POST["Id_Pedido"];

      $q_Cabecera = "SELECT CP.Cod_Interno,
                            CP.Documento_Cliente,
                            CP.Nombre_Cliente,
                            CONVERT(VARCHAR, CP.FechaHora_Recepcion, 120) AS FechaHora_Recepcion,
                            CONVERT(VARCHAR, CP.FechaHora_Entrega, 23) AS Fecha_Entrega,
                            CONVERT(VARCHAR, CP.FechaHora_Entrega, 108) AS Hora_Entrega,
                            CP.Mostrar_Precio,
                            CP.Incluir_IGV,
                            CP.Sucursal,
                            CP.Observacion,
                            CP.iIdCliente,
                            CP.id_DocCliente,
                            CP.id_TipoDocSunat,
                            PV.Id AS PagoVenta,
                            CP.reporte_fisico,
                            CP.reporte_wsp,
                            CP.reporte_mail,
                            MC.cNumeroTelefono,
                            MC.cSegundoNumeroTelefono,
                            MC.cEmail,
                            CP.Mostrar_Contacto,
                            MC.cDireccion
                      FROM  _max_labperu_CabeceraPedido CP
                            LEFT JOIN _max_labperu_PagoVenta PV ON CP.Id_Pedido = PV.Id_Pedido
                            LEFT JOIN maestroCliente MC ON MC.iIdCliente = CP.iIdCliente
                     WHERE  CP.Id_Pedido = ".$Id_Pedido;

      if ($res_Cabecera = sqlsrv_query($enlacehost, $q_Cabecera)) {
          while($row_Cabecera = sqlsrv_fetch_array($res_Cabecera)) {
            $estado = 1;

            array_push($r, $row_Cabecera);
          }
      }

      echo json_encode(array('estado' => $estado, 'registros' => $r));

      break;

    case 'Get_DetallePedido':
      $r = array();
      $estado = 0;

      $Id_Pedido = $_POST["Id_Pedido"];

      $q_Detalle = "SELECT  D.Id,
                            D.Id_Item,
                            DP.iIdProducto,
                            D.Cod_Interno,
                            D.Elemento_Analisis,
                            D.Nom_Muestra,
                            D.Precio_Analisis,
                            D.bDescuento,
                            D.Descuento_Analisis,
                            D.Precio_Final,
                            D.Estado_Muestra,
                            E.Nombre_EstadoMuestra,
                            D.Peso_Muestra,
                            D.Detalle_Envase,
                            DE.Nombre_DetalleEnvase,
                            D.Tipo_Muestra,
                            T.Nombre_TipoMuestra,
                            D.Precio_Exceso,
                            D.Observacion,
                            D.IdProductos_Combo,
                            D.CodProductos_Combo,
                            D.Tipo_Analisis,
                            TA.Des_TipoAnalisis
                      FROM  _max_labperu_DetallePedido D
                            INNER JOIN _max_labperu_EstadosMuestra E ON D.Estado_Muestra = E.Id
                            INNER JOIN _max_labperu_DetalleEnvase DE ON D.Detalle_Envase = DE.Id
                            INNER JOIN _max_labperu_TiposMuestra T ON D.Tipo_Muestra = T.Id
                            INNER JOIN _max_labperu_TipoAnalisis TA ON D.Tipo_Analisis = TA.Id
                            INNER JOIN Detalle_Pedido DP ON D.Id_Item = DP.iId_Detalle_Pedido
                     WHERE  Id_Pedido = ".$Id_Pedido."
                    ORDER BY D.Cod_Interno";

      if ($res_Cabecera = sqlsrv_query($enlacehost, $q_Detalle)) {
          while($row_Cabecera = sqlsrv_fetch_array($res_Cabecera)) {
            $estado = 1;

            array_push($r, $row_Cabecera);
          }
      }

      echo json_encode(array('estado' => $estado, 'registros' => $r));

      break;

    case 'Get_TotalesPedido':
      $r = array();
      $estado = 0;

      $Id_Pedido = $_POST["Id_Pedido"];

      $q_Total = "SELECT  ISNULL(SUM(Precio_Final), 0) AS TOTAL,
                          ISNULL(SUM(Precio_Exceso), 0) AS EXCESO
                    FROM  _max_labperu_DetallePedido D
                   WHERE  Id_Pedido = ".$Id_Pedido;

      if ($res_Total = sqlsrv_query($enlacehost, $q_Total)) {
          while($row_Total = sqlsrv_fetch_array($res_Total)) {
            $estado = 1;

            array_push($r, $row_Total);
          }
      }

      echo json_encode(array('estado' => $estado, 'registros' => $r));

      break;

    case 'get_ValidaRegistroDetalle':
      $r = array();
      $estado = 0;

      $IdPedido = $_POST["IdPedido"];

      $q_detalle = "SELECT COUNT(Id) AS _COUNT
                           FROM _max_labperu_DetallePedido
                          WHERE Id_Pedido = ".$IdPedido;

      if ($res_detalle = sqlsrv_query($enlacehost, $q_detalle)) {
          while($row_detalle = sqlsrv_fetch_array($res_detalle)) {
            $estado = 1;

            array_push($r, $row_detalle);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Grabar_CabeceraPedido':
      // Recupera parámetros
        $idCabeceraPedido = $_POST["idCabeceraPedido"];
        $idCliente = ((strlen($_POST["idCliente"]) == 0) ? 0 : $_POST["idCliente"]);
        $NombreCliente = $_POST["NombreCliente"];
        $idVendedor = $_POST["idVendedor"];
        $NombreVendedor = $_POST["NombreVendedor"];
        $idTerminal = $_POST["idTerminal"];
        $idTienda = $_POST["idTienda"];
        $idCompany = $_POST["idCompany"];
        $idUser = $_POST["idUser"];
        $fecha = $_POST["fecha"];
        $respuesta = $_POST["respuesta"];
        $id_TipoDocSunat = ((strlen($_POST["id_TipoDocSunat"]) == 0) ? 0 : $_POST["id_TipoDocSunat"]);
        $cNumDocCliente = ((strlen($_POST["cNumDocCliente"]) == 0) ? 0 : $_POST["cNumDocCliente"]);
        $cDireccionCliente = $_POST["cDireccionCliente"];
        $idTipoDoc = ((strlen($_POST["idTipoDoc"]) == 0) ? 0 : $_POST["idTipoDoc"]);

      // Guarda Cabecera
        $query = "EXEC sp_guardar_cabecera_pedido ";
        $query .= $idCabeceraPedido.", ";
        $query .= $idCliente.", ";
        $query .= "'".$NombreCliente."', ";
        $query .= $idVendedor.", ";
        $query .= "'".$NombreVendedor."', ";
        $query .= $idTerminal.", ";
        $query .= $idTienda.", ";
        $query .= $idCompany.", ";
        $query .= $idUser.", ";
        $query .= $fecha.", ";
        $query .= $respuesta.", ";
        $query .= $id_TipoDocSunat.", ";
        $query .= $cNumDocCliente.", ";
        $query .= "'".$cDireccionCliente."', ";
        $query .= $idTipoDoc;

        $estado = 0;

        if ($res = sqlsrv_query($enlacehost, $query)) {
          $estado = 1;
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Grabar_CabeceraPedido_Adicional':
      // Recupera parámetros
        $modo_grabar = $_POST["modo_grabar"];
        $idCabeceraPedido = $_POST["idCabeceraPedido"];
        $cNumDocCliente = $_POST["cNumDocCliente"];
        $NombreCliente = $_POST["NombreCliente"];

        $adicional_CI = $_POST["adicional_CI"];

        date_default_timezone_set("America/Lima"); 
        $date = date('Y-m-d');
        $time = date('H:i:s');

        // $adicional_fechahorarecepcion = $_POST["adicional_fechahorarecepcion"];
        $adicional_fechahorarecepcion = ($date.' ' .$time);
        $adicional_fechahoraentrega = $_POST["adicional_fechahoraentrega"];
        $adicional_precio = $_POST["adicional_precio"];
        $adicional_igv = $_POST["adicional_igv"];
        $adicional_contacto = $_POST["adicional_contacto"];
        $adicional_sucursal = $_POST["adicional_sucursal"];
        $adicional_observacion = $_POST["adicional_observacion"];
        $adicional_idCliente = ((strlen($_POST["adicional_idCliente"]) == 0) ? 0 : $_POST["adicional_idCliente"]);
        $adicional_idTipoDoc = ((strlen($_POST["adicional_idTipoDoc"]) == 0) ? 0 : $_POST["adicional_idTipoDoc"]);
        $adicional_id_TipoDocSunat = ((strlen($_POST["adicional_id_TipoDocSunat"]) == 0) ? 0 : $_POST["adicional_id_TipoDocSunat"]);
        $usu_usuario = $_POST["usu_usuario"];
        $adicional_fisico = $_POST["adicional_fisico"];
        $adicional_wsp = $_POST["adicional_wsp"];
        $adicional_mail = $_POST["adicional_mail"];

      // Guardar Cabecera Adicional
        $exists = 0;

        $q_exists = "SELECT  COUNT(Id) AS _EXISTS
                       FROM  _max_labperu_CabeceraPedido
                      WHERE  Id_Pedido = ".$idCabeceraPedido;

        if ($res = sqlsrv_query($enlacehost, $q_exists)) {
          while($row = sqlsrv_fetch_array($res)) {
            $exists = $row["_EXISTS"];
          }
        }

        if ($exists == 0){
          $q_adicional = "INSERT INTO _max_labperu_CabeceraPedido (Id_Pedido, Cod_Interno, Documento_Cliente,
                                                                   Nombre_Cliente, FechaHora_Recepcion, FechaHora_Entrega,
                                                                   Mostrar_Precio, Incluir_IGV, Sucursal, Observacion,
                                                                   iIdCliente, id_DocCliente, id_TipoDocSunat, usu_usuario,
                                                                   reporte_fisico, reporte_wsp, reporte_mail, Mostrar_Contacto) VALUES(";
          $q_adicional .= $idCabeceraPedido.", ";
          $q_adicional .= "'".$adicional_CI."', ";
          $q_adicional .= "'".$cNumDocCliente."', ";
          $q_adicional .= "'".$NombreCliente."', ";
          // $q_adicional .= "(CASE WHEN FechaHora_Recepcion IS NULL THEN '".$adicional_fechahorarecepcion."' ELSE FechaHora_Recepcion END), ";
          $q_adicional .= "'".$adicional_fechahorarecepcion."', ";
          $q_adicional .= "'".$adicional_fechahoraentrega."', ";
          $q_adicional .= $adicional_precio.", ";
          $q_adicional .= $adicional_igv.", ";
          $q_adicional .= $adicional_sucursal.", ";
          $q_adicional .= "'".$adicional_observacion."', ";
          $q_adicional .= $adicional_idCliente.", ";
          $q_adicional .= $adicional_idTipoDoc.", ";
          $q_adicional .= $adicional_id_TipoDocSunat.", ";
          $q_adicional .= "'".$usu_usuario."', ";
          $q_adicional .= $adicional_fisico.", ";
          $q_adicional .= $adicional_wsp.", ";
          $q_adicional .= $adicional_mail.", ";
          $q_adicional .= $adicional_contacto.")";
        }
        else{
          $q_adicional = "UPDATE _max_labperu_CabeceraPedido SET ";
          $q_adicional .= "Documento_Cliente = '".$cNumDocCliente."', ";
          $q_adicional .= "Nombre_Cliente = '".$NombreCliente."', ";
          // $q_adicional .= "FechaHora_Recepcion = ".(($modo_grabar == 'N') ? "'".$adicional_fechahorarecepcion."'" : 'FechaHora_Recepcion').", ";
          $q_adicional .= "FechaHora_Entrega = '".$adicional_fechahoraentrega."', ";
          $q_adicional .= "Mostrar_Precio = ".$adicional_precio.", ";
          $q_adicional .= "Incluir_IGV = ".$adicional_igv.", ";
          $q_adicional .= "Mostrar_Contacto = ".$adicional_contacto.", ";
          $q_adicional .= "Sucursal = ".$adicional_sucursal.", ";
          $q_adicional .= "Observacion = '".$adicional_observacion."', ";
          $q_adicional .= "iIdCliente = ".$adicional_idCliente.", ";
          $q_adicional .= "id_DocCliente = ".$adicional_idTipoDoc.", ";
          $q_adicional .= "id_TipoDocSunat = ".$adicional_id_TipoDocSunat.", ";
          $q_adicional .= "reporte_fisico = ".$adicional_fisico.", ";
          $q_adicional .= "reporte_wsp = ".$adicional_wsp.", ";
          $q_adicional .= "reporte_mail = ".$adicional_mail." ";
          $q_adicional .= "WHERE Id_Pedido = ".$idCabeceraPedido;
        }

        if ($res_adicional = sqlsrv_query($enlacehost, $q_adicional)) {
          $estado = 1;
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Grabar_ItemProducto':
      // Recupera variables para tabla de pedido en BD Omar
        $idCabeceraPedido = $_POST["idCabeceraPedido"];
        $id_detalle = $_POST["Id_detalle"];
        $idProducto = $_POST["idProducto"];
        $cantidad = $_POST["cantidad"];
        $idCompany = $_POST["idCompany"];
        $idTerminal = $_POST["idTerminal"];
        $idUsuario = $_POST["idUsuario"];
        $metodoGuardar = $_POST["metodoGuardar"];  
        $idTienda = $_POST["idTienda"];
        $idPventaAdicional = $_POST["idPventaAdicional"];
        $id_IdDetalle = $_POST["id_IdDetalle"];

      // Recupera variables para tabla adicional en BD Omar
        $modo_grabar = $_POST["modo_grabar"];
        $add_correlativoCI = $_POST["add_correlativoCI"];
        $add_codinterno = $_POST["add_codinterno"];
        $add_nommuestra = $_POST["add_nommuestra"];
        $add_analisis = $_POST["add_analisis"];
        $add_precioanalisis = str_replace('S/ ', '', $_POST["add_precioanalisis"]);
        $add_estadomuestra = $_POST["add_estadomuestra"];
        $add_pesomuestra = $_POST["add_pesomuestra"];
        $add_detalleenvase = $_POST["add_detalleenvase"];
        $add_tipomuestra = $_POST["add_tipomuestra"];
        $add_tipoanalisis = $_POST["add_tipoanalisis"];
        $add_exceso = $_POST["add_exceso"];
        $add_observacion = $_POST["add_observacion"];
        $idproductos_combo = $_POST["idproductos_combo"];
        $codproductos_combo = $_POST["codproductos_combo"];

      $q_NewUpdate = "EXEC sp_insertar_producto_normal_detalle_pedido_v3 ";
      $q_NewUpdate .= $idCabeceraPedido.", ".(($modo_grabar == 'N') ? 0 : $id_IdDetalle).", ";
      $q_NewUpdate .= $idProducto.", '".$add_nommuestra."', ".$add_precioanalisis.", ".$add_precioanalisis.", 1, 0, ";
      $q_NewUpdate .= $idCompany.", ";
      $q_NewUpdate .= $idTerminal.", ";
      $q_NewUpdate .= $idUsuario.", '".(($modo_grabar == 'N') ? 'N' : 'M')."', ";
      $q_NewUpdate .= $idTienda.", 0, 0, 0, 0";

      if ($res = sqlsrv_query($enlacehost, $q_NewUpdate)) {
      }

      if ($modo_grabar != 'N'){
        $query = "UPDATE  _max_labperu_DetallePedido SET
                          Nom_Muestra = '".$add_nommuestra."',
                          Elemento_Analisis = '".$add_analisis."',
                          Precio_Analisis = ".$add_precioanalisis.",
                          bDescuento = 0,
                          Descuento_Analisis = 0,
                          Precio_Final = ".$add_precioanalisis.",
                          Estado_Muestra = ".$add_estadomuestra.",
                          Peso_Muestra = ".$add_pesomuestra.",
                          Detalle_Envase = ".$add_detalleenvase.",
                          Tipo_Muestra = ".$add_tipomuestra.",
                          Tipo_Analisis = ".$add_tipoanalisis.",
                          Precio_Exceso = ".$add_exceso.",
                          Observacion = '".$add_observacion."',
                          IdProductos_Combo = '".$idproductos_combo."',
                          CodProductos_Combo = '".$codproductos_combo."'
                   WHERE Id = ".$id_detalle;
      }

      $estado = 0;

      // Grabando datos
        if ($res = sqlsrv_query($enlacehost, $query)) {
          $estado = 1;

          if ($modo_grabar == 'N'){
            // Buscando Id del Item insertado
              $q_IdItem = "SELECT  iId_Detalle_Pedido
                             FROM  Detalle_Pedido
                            WHERE  iId_Cabecera_Pedido = ".$idCabeceraPedido."
                              AND  iNumItem = ".$add_correlativoCI;

              if ($res_IdItem = sqlsrv_query($enlacehost, $q_IdItem)) {
                while($row_IdItem = sqlsrv_fetch_array($res_IdItem)) {
                  $Id_Item = $row_IdItem["iId_Detalle_Pedido"];
                }
              }

            // Grabando en la tabla adicional
              $q_adicional = "INSERT INTO _max_labperu_DetallePedido (Id_Pedido, Id_Item, Cod_Interno, Nom_Muestra,
                                                                      Elemento_Analisis, Precio_Analisis, bDescuento, Descuento_Analisis,
                                                                      Precio_Final, Estado_Muestra, Peso_Muestra, Detalle_Envase,
                                                                      Tipo_Muestra, Tipo_Analisis, Precio_Exceso, Observacion, Orden_Item,
                                                                      IdProductos_Combo, CodProductos_Combo) VALUES(";
              $q_adicional .= $idCabeceraPedido.", ";
              $q_adicional .= $Id_Item.", ";
              $q_adicional .= "'".$add_codinterno."', ";
              $q_adicional .= "'".$add_nommuestra."', ";
              $q_adicional .= "'".$add_analisis."', ";
              $q_adicional .= $add_precioanalisis.", ";
              $q_adicional .= "0, 0, ";
              $q_adicional .= $add_precioanalisis.", ";
              $q_adicional .= $add_estadomuestra.", ";
              $q_adicional .= $add_pesomuestra.", ";
              $q_adicional .= $add_detalleenvase.", ";
              $q_adicional .= $add_tipomuestra.", ";
              $q_adicional .= $add_tipoanalisis.", ";
              $q_adicional .= $add_exceso.", ";
              $q_adicional .= "'".$add_observacion."', ";
              $q_adicional .= $add_correlativoCI.", ";
              $q_adicional .= "'".$idproductos_combo."', ";
              $q_adicional .= "'".$codproductos_combo."')";

              if ($res_adicional = sqlsrv_query($enlacehost, $q_adicional)) {
                // Obtiene el último Id generado
                  $get_id = "SELECT TOP 1 Id
                               FROM _max_labperu_DetallePedido
                              WHERE Id_Pedido = ".$idCabeceraPedido."
                             ORDER BY Id DESC";

                  if ($res_id = sqlsrv_query($enlacehost, $get_id)) {
                    while($row_id = sqlsrv_fetch_array($res_id)) {
                      $id_detalle = $row_id["Id"];
                    }
                  }

                // Genera el Código de Informe de Ensayo
                  $correlativo = 'x';

                  // Verifica si tiene asignado un correlativo de I.E.
                    $q_codigoinforme = "SELECT  Correlativo
                                          FROM  _max_labperu_CorrelativoInformeEnsayos
                                         WHERE  Id_Pedido =".$idCabeceraPedido."
                                           AND  Id_Detalle_Pedido = ".$id_detalle;

                    if ($res_codigoinforme = sqlsrv_query($enlacehost, $q_codigoinforme)) {
                      while($row_codigoinforme = sqlsrv_fetch_array($res_codigoinforme)) {
                        $correlativo = $row_codigoinforme["Correlativo"];
                      }
                    }

                  // Si no tiene correlativo de I.E. lo crea
                    if ($correlativo == 'x'){
                      $q_newcorrelativo = "SELECT  ISNULL(MAX(Correlativo), 11999) + 1 AS CORRELATIVO
                                             FROM  _max_labperu_CorrelativoInformeEnsayos";

                      if ($res_newcorrelativo = sqlsrv_query($enlacehost, $q_newcorrelativo)) {
                        while($row_newcorrelativo = sqlsrv_fetch_array($res_newcorrelativo)) {
                          $correlativo = $row_newcorrelativo["CORRELATIVO"];
                        }
                      }

                      // Guarda el correlativo obtenido
                        date_default_timezone_set("America/Lima");

                        $date = date('Y-m-d');
                        $time = date('H:i:s');

                        $q_insert = "INSERT INTO _max_labperu_CorrelativoInformeEnsayos (Id_Pedido, Id_Detalle_Pedido, Correlativo, Fecha_Creacion) VALUES(";
                        $q_insert .= $idCabeceraPedido.", ";
                        $q_insert .= $id_detalle.", ";
                        $q_insert .= $correlativo.", ";
                        $q_insert .= "'".($date.' ' .$time)."')";

                        if ($res = sqlsrv_query($enlacehost, $q_insert)) {
                        }
                    }
              }
          }
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Grabar_Cliente':
      $r = array();

      // Recupera variables para tabla de pedido en BD Omar
        $modo_grabar = $_POST["modo_grabar"];
        $id_cliente = $_POST["id_cliente"];
        $idCompany = $_POST["idCompany"];
        $tipo_cliente = $_POST["tipo_cliente"];
        $tipo_documento = $_POST["tipo_documento"];
        $razon_social = $_POST["razon_social"];
        $dni_ruc = $_POST["dni_ruc"];
        $eMail = $_POST["eMail"];
        $num_telefono1 = $_POST["num_telefono1"];
        $num_telefono2 = $_POST["num_telefono2"];
        $direccion = $_POST["direccion"];

      // Valida que el DNI / RUC ingresado no haya sido ingresado antes
        $q_exists = "SELECT  COUNT(iIdCliente) AS _EXISTS
                       FROM  maestroCliente
                      WHERE  iIdCompany = ".$idCompany."
                        AND  cNumeroRuc = '".$dni_ruc."'";

      if ($modo_grabar == 'N'){
        // Valida que el DNI / RUC ingresado no haya sido ingresado antes
          if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
            while($row_exists = sqlsrv_fetch_array($res_exists)) {
              if ($row_exists["_EXISTS"] > 0){
                $estado = 2;

                echo json_encode(array('estado' => $estado));
                return;
              }
            }
          }

        // Guardando datos
          $query = "INSERT INTO maestroCliente (iTipoCliente, id_Tipo_Documento, cRazonSocial, cNumeroRuc,
                                                cPrimerNombre, cSegundoNombre, cApellidoPaterno, cApellidoMaterno,
                                                cEmail, cNumeroTelefono, cSegundoNumeroTelefono, cDireccion,
                                                iIdCompany, cEstado_Eliminado, cControl1, cControl2,
                                                idTipoCliente, iIdTipoDocumento) VALUES (";
          $query .= $tipo_cliente.", ".$tipo_documento.", '".$razon_social."', '".$dni_ruc."', ";
          $query .= "'', '', '', '', ";
          $query .= "'".$eMail."', '".$num_telefono1."', '".$num_telefono2."', '".$direccion."', ";
          $query .= $idCompany.", '', '', '', ";
          $query .= "2, 1012)";
      }
      else{
        // Valida que el DNI / RUC ingresado no haya sido ingresado antes
          $q_exists .= "   AND iIdCliente <> ".$id_cliente;

          if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
            while($row_exists = sqlsrv_fetch_array($res_exists)) {
              if ($row_exists["_EXISTS"] > 0){
                $estado = 2;

                echo json_encode(array('estado' => $estado));
                return;
              }
            }
          }

        // Guardando datos
          $query = " UPDATE maestroCliente";
          $query .= "   SET iTipoCliente = ".$tipo_cliente.", ";
          $query .= "       id_Tipo_Documento = ".$tipo_documento.", ";
          $query .= "       cRazonSocial = '".$razon_social."', ";
          $query .= "       cNumeroRuc = '".$dni_ruc."', ";
          $query .= "       cEmail = '".$eMail."', ";;
          $query .= "       cNumeroTelefono = '".$num_telefono1."', ";
          $query .= "       cSegundoNumeroTelefono = '".$num_telefono2."', ";
          $query .= "       cDireccion = '".$direccion."'";
          $query .= " WHERE iIdCliente = ".$id_cliente;
      }

      $estado = 0;

      // Grabando datos
        if ($res = sqlsrv_query($enlacehost, $query)) {
          $estado = 1;

          // Recuperando datos de nuevo cliente
            $q_Clientes = "SELECT maestroCliente.iIdCliente,
                                  maestroCliente.cNumeroRuc,
                                  maestroCliente.cRazonSocial,
                                  maestroCliente.id_Tipo_Documento,
                                  TipodeDocumento.id_doc_sunat,
                                  maestroCliente.cDireccion
                             FROM maestroCliente
                                  INNER JOIN TipodeDocumento ON maestroCliente.Id_Tipo_Documento = TipodeDocumento.iIdTipoDocumento
                            WHERE iIdCompany = ".$idCompany."
                              AND cNumeroRuc = '".$dni_ruc."'";

            if ($res_Clientes = sqlsrv_query($enlacehost, $q_Clientes)) {
              while($row_Clientes = sqlsrv_fetch_array($res_Clientes)) {
                $estado = 1;

                array_push($r, $row_Clientes);
              }
            }
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado, 'registros' => $r));

      break;

    case 'Grabar_DsctoProducto':
      // Recupera variables
        $cantidad = $_POST["cantidad"];
        $idCabeceraPedido = $_POST["idCabeceraPedido"];
        $Id_Detalle = $_POST["Id_Detalle"];
        $idDetallePedido = $_POST["idDetallePedido"];
        $idCompany = $_POST["idCompany"];
        $idTienda = $_POST["idTienda"];
        $idProducto = $_POST["idProducto"];
        $stockFisico = $_POST["stockFisico"];
        $stockComprometido = $_POST["stockComprometido"];
        $cantidadOriginal = $_POST["cantidadOriginal"];
        $Agregado = $_POST["Agregado"];
        $montoDescuento = $_POST["montoDescuento"];
        $observacionProducto = $_POST["observacionProducto"];
        $usaDescuento = $_POST["usaDescuento"];
        $precioUnitario = $_POST["precioUnitario"];
        $dscto_precioventa = $_POST["dscto_precioventa"];
        $Id_Cliente = $_POST["Id_Cliente"];
        $IdProductos_Combo = $_POST["IdProductos_Combo"];
        $CodProductos_Combo = $_POST["CodProductos_Combo"];

      // Graba datos
        $query = "UPDATE  _max_labperu_DetallePedido SET
                          Precio_Analisis = ".$precioUnitario.",
                          bDescuento = ".(($montoDescuento == 0) ? 0 : 1).",
                          Descuento_Analisis = ".$montoDescuento.",
                          Precio_Final = ".$dscto_precioventa."
                   WHERE  Id = ".$Id_Detalle;

      $estado = 0;

      if ($res = sqlsrv_query($enlacehost, $query)) {
        $estado = 1;

        // Graba en la BD Omar
          $q_update = "EXEC sp_EditarCantidadProductoDetalleVenta_v2 ";
          $q_update .= "1, ";
          $q_update .= $idCabeceraPedido.", ";
          $q_update .= $idDetallePedido.", ";
          $q_update .= $idCompany.", ";
          $q_update .= $idTienda.", ";
          $q_update .= $idProducto.", ";
          $q_update .= $stockFisico.", ";
          $q_update .= $stockComprometido.", ";
          $q_update .= $cantidadOriginal.", ";
          $q_update .= $Agregado.", ";
          $q_update .= $montoDescuento.", ";
          $q_update .= "'".$observacionProducto."', ";
          $q_update .= (($montoDescuento == 0) ? 0 : 1).", ";
          $q_update .= $precioUnitario;

          if ($res = sqlsrv_query($enlacehost, $q_update)) {
          }

        // Si es un combo actualiza el precio
          $q_preciocombo = "UPDATE _max_labperu_ClientesCombos
                               SET Precio_Combo = ".$dscto_precioventa."
                             WHERE Id_Cliente = ".$Id_Cliente."
                               AND Id_Producto = ".$idProducto."
                               AND IdProductos_Combo = '".$IdProductos_Combo."'";

          if ($res = sqlsrv_query($enlacehost, $q_preciocombo)) {
          }
      }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Grabar_Venta':
      // Recupera parámetros
        $modo_grabar = $_POST["modo_grabar"];
        $idCabeceraPedido = $_POST["idCabeceraPedido"];
        $identificadorPedido = $_POST["identificadorPedido"];
        $idCompany = $_POST["idCompany"];
        $idTerminal = $_POST["idTerminal"];
        $idUsuario = $_POST["idUsuario"];
        $idTienda = $_POST["idTienda"];
        $cObservarcion = $_POST["cObservarcion"];
        $fechaGuardadoNumerico = $_POST["fechaGuardadoNumerico"];
        $estadoPermanencia = $_POST["estadoPermanencia"];
        $identificador2 = $_POST["identificador2"];
        $fFechaEntrega = $_POST["fFechaEntrega"];

      // Recupera parámetros para pagos
        $observacion_recibo = $_POST["observacion_recibo"];
        $medio_pago = $_POST["medio_pago"];
        $total_venta = $_POST["total_venta"];
        $efectivo_ingresado = $_POST["efectivo_ingresado"];
        $total_billete200 = $_POST["total_billete200"];
        $total_billete100 = $_POST["total_billete100"];
        $total_billete50 = $_POST["total_billete50"];
        $total_billete20 = $_POST["total_billete20"];
        $total_billete10 = $_POST["total_billete10"];
        $total_billete5 = $_POST["total_billete5"];
        $total_billete2 = $_POST["total_billete2"];
        $total_billete1 = $_POST["total_billete1"];
        $total_billete50cen = $_POST["total_billete50cen"];
        $total_billete20cen = $_POST["total_billete20cen"];
        $total_billete10cen = $_POST["total_billete10cen"];
        $cod_sucursal = $_POST["cod_sucursal"];

      // Obtiene fecha y hora actual
        date_default_timezone_set("America/Lima");

        $date = date('Y-m-d');
        $time = date('H:i:s');
        $fecha = ($date.' ' .$time);

      if ($modo_grabar == 'N'){
        // Guarda Cabecera
          $query = "EXEC sp_guardar_pedido_reserva_v6 ";
          $query .= $idCabeceraPedido.", ";
          $query .= "'".$identificadorPedido."', ";
          $query .= $idCompany.", ";
          $query .= $idTerminal.", ";
          $query .= $idUsuario.", ";
          $query .= $idTienda.", ";
          $query .= "'".$cObservarcion."', ";
          $query .= $fechaGuardadoNumerico.", ";
          $query .= $estadoPermanencia.", ";
          $query .= "'".$identificador2."', ";
          $query .= "'".$fFechaEntrega."'";

          $estado = 0;

          if ($res = sqlsrv_query($enlacehost, $query)) {
            $estado = 1;

            // Grabar datos de pago
              $q_pago = "INSERT INTO _max_labperu_PagoVenta (Id_Pedido, Observacion_Recibo, Id_MedioPago, Total_Venta,
                                                             Efectivo_Ingresado, billete200, billete100, billete50,
                                                             billete20, billete10, billete5, billete2,
                                                             billete1, billete50cen, billete20cen, billete10cen,
                                                             recibo_correlativo_sucursal,
                                                             recibo_correlativo_codigo,
                                                             es_pagado,
                                                             fecha_pagado)
                            VALUES ( ".$idCabeceraPedido.",
                                    '".$observacion_recibo."',
                                     ".$medio_pago.",
                                     ".$total_venta.",
                                     ".$efectivo_ingresado.",
                                     ".$total_billete200.",
                                     ".$total_billete100.",
                                     ".$total_billete50.",
                                     ".$total_billete20.",
                                     ".$total_billete10.",
                                     ".$total_billete5.",
                                     ".$total_billete2.",
                                     ".$total_billete1.",
                                     ".$total_billete50cen.",
                                     ".$total_billete20cen.",
                                     ".$total_billete10cen.",
                                    '".$cod_sucursal."',
                                     (SELECT correlativo + 1 FROM _max_labperu_CorrelativoRecibo WHERE cod_sucursal = '".$cod_sucursal."'),
                                     ".(($medio_pago == 3) ? 1 : 0).",
                                     ".(($medio_pago == 3) ? "'".$fecha."'": 'NULL').")";

              if ($res = sqlsrv_query($enlacehost, $q_pago)) {
              }
          }
          else{
            $estado = 0;
          }
      }
      else{
        $q_update = "UPDATE _max_labperu_PagoVenta
                        SET Observacion_Recibo = '".$observacion_recibo."',
                            Id_MedioPago = ".$medio_pago.",
                            Total_Venta = ".$total_venta.",
                            Efectivo_Ingresado = ".$efectivo_ingresado.",
                            billete200 = ".$total_billete200.",
                            billete100 = ".$total_billete100.",
                            billete50 = ".$total_billete50.",
                            billete20 = ".$total_billete20.",
                            billete10 = ".$total_billete10.",
                            billete5 = ".$total_billete5.",
                            billete2 = ".$total_billete2.",
                            billete1 = ".$total_billete1.",
                            billete50cen = ".$total_billete50cen.",
                            billete20cen = ".$total_billete20cen.",
                            billete10cen =".$total_billete10cen.",
                            es_pagado = ".(($medio_pago == 3) ? 1 : 0).",
                            fecha_pagado = ".(($medio_pago == 3) ? "'".$fecha."'": 'NULL')."
                      WHERE Id_Pedido = ".$idCabeceraPedido;

        if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
          $estado = 1;
        }
        else{
          $estado = 0;
        }
      }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Anular_Venta':
      // Recupera parámetros
        $idCompany = $_POST["idCompany"];
        $idTienda = $_POST["idTienda"];
        $idUsuario = $_POST["idUsuario"];
        $idTerminal = $_POST["idTerminal"];

        $IdPedido = $_POST["IdPedido"];
        $codeRespuesta = $_POST["codeRespuesta"];
        $mensajeRespuesta = $_POST["mensajeRespuesta"];
        $usuario = $_POST["usu_usuario"];

      // Guarda Cabecera
        $query = "EXEC sp_anular_pedido ";
        $query .= $idCompany.", ";
        $query .= $idTienda.", ";
        $query .= $idUsuario.", ";
        $query .= $idTerminal.", ";
        $query .= $IdPedido.", ";
        $query .= $codeRespuesta.", ";
        $query .= "'".$mensajeRespuesta."' ";

        $estado = 0;

        if ($res = sqlsrv_query($enlacehost, $query)) {
          $estado = 1;

          // Actualizando en tabla adicional de cabecera
            date_default_timezone_set("America/Lima"); 

            $date = date('Y-m-d');
            $time = date('H:i:s');

            $q_anular = "UPDATE _max_labperu_CabeceraPedido
                            SET es_anulada = 1,
                                usuario_anulacion = '".$usuario."',
                                fecha_anulacion = '".($date.' ' .$time)."'
                          WHERE Id_Pedido = ".$IdPedido;

            if ($res = sqlsrv_query($enlacehost, $q_anular)) {
            }
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Eliminar_Producto':
      // Recupera variables
        $idCabeceraPedido = $_POST["idCabeceraPedido"];
        $idDetallePedido = $_POST["idDetallePedido"];
        $Id_Detalle = $_POST["Id_Detalle"];

      // Graba datos
        $query = "DELETE FROM _max_labperu_DetallePedido
                   WHERE Id_Pedido =  ".$idCabeceraPedido."
                     AND Id = ".$Id_Detalle;

      $estado = 0;

      if ($res = sqlsrv_query($enlacehost, $query)) {
        $estado = 1;

        // Elimina en la BD Omar
          $q_delete = "DELETE FROM Detalle_Pedido
                        WHERE iId_Detalle_Pedido = ".$idDetallePedido."
                          AND iId_Cabecera_Pedido = ".$idCabeceraPedido;

          if ($res = sqlsrv_query($enlacehost, $q_delete)) {
          }
      }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Grabar_ComboCliente':
      // Recupera variables
        $Id_Cliente = $_POST["Id_Cliente"];
        $Id_Producto = $_POST["Id_Producto"];
        $Elemento_Analisis = $_POST["Elemento_Analisis"];
        $Precio_Combo = $_POST["Precio_Combo"];
        $Precio_Combo = trim(str_replace('S/', '', $Precio_Combo));
        $IdProductos_Combo = $_POST["IdProductos_Combo"];
        $CodProductos_Combo = $_POST["CodProductos_Combo"];

      // Verifica si el combo ya existe
        $q_exists = "SELECT COUNT(Id) AS _EXISTS
                       FROM  _max_labperu_ClientesCombos
                      WHERE  Estado_Combo = 'A'
                        AND  Id_Cliente = ".$Id_Cliente."
                        AND  Id_Producto = ".$Id_Producto."
                        AND  Elemento_Analisis = '".$Elemento_Analisis."'
                        AND  IdProductos_Combo = '".$IdProductos_Combo."'";

        if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
          while($row_exists = sqlsrv_fetch_array($res_exists)) {
            if ($row_exists["_EXISTS"] == 0){
              // Si no existe lo agrega
                $estado = 0;

                $q_insert = "INSERT INTO _max_labperu_ClientesCombos(Id_Cliente, Id_Producto, Elemento_Analisis,
                                                                     Precio_Combo, IdProductos_Combo, CodProductos_Combo) VALUES(";
                $q_insert .= $Id_Cliente.", ";
                $q_insert .= $Id_Producto.", ";
                $q_insert .= "'".$Elemento_Analisis."', ";
                $q_insert .= $Precio_Combo.", ";
                $q_insert .= "'".$IdProductos_Combo."', ";
                $q_insert .= "'".$CodProductos_Combo."')";

                if ($res = sqlsrv_query($enlacehost, $q_insert)) {
                  $estado = 1;
                }

                echo json_encode(array('estado' => $estado));
            }
          }
        }

      break;

    case 'Get_AnalisisResultados':
      $r = array();
      $estado = 0;

      $fecha_inicio = $_POST["fecha_inicio"];
      $fecha_fin = $_POST["fecha_fin"];
      $id_rack = $_POST["id_rack"];
      $id_fundidor = $_POST["id_fundidor"];
      $id_cliente = $_POST["cliente"];
      $agrupados = $_POST["agrupados"];

      $q_resultados = "SELECT CP.Id_Pedido,
                              DP.Id AS Id_Detalle,
                              DP.Elemento_Analisis,
                              DP.Nom_Muestra,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 20) AS FechaHora_Recepcion,
                              CONVERT(VARCHAR, CP.FechaHora_Entrega, 20) AS FechaHora_Entrega,
                              DP.Cod_Interno,
                              DP.Observacion,
                              DAR.Ley_Au_gt,
                              DAR.Ley_Au_ot,
                              DAR.Ley_Ag_gt,
                              DAR.Ley_Ag_ot,
                              DAR.Porc_CU,
                              DAR.Porc_PB,
                              DAR.Porc_ZN,
                              DAR.Porc_AS,
                              DAR.Porc_SB,
                              DAR.Porc_S,
                              DAR.Porc_FE,
                              DAR.Porc_H2O,
                              COALESCE(DAR.Cod_EstadoResultadosCliente, 0) AS Cod_EstadoResultadosCliente,
                              DAR.Fecha_PreCierre,
                              DAR.Fecha_CierreFinal,
                              DAR.Fecha_Registro,
                              DAR.Observacion_Reporte,
                              MC.cRazonSocial,
                              TM.Nombre_TipoMuestra,
                              DP.Peso_Muestra,
                              DE.Nombre_DetalleEnvase,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 103) AS FechaHora_Recepcion2,
                              CONVERT(VARCHAR, DAR.Fecha_Registro, 103) AS FechaHora_Entrega2,
                              CONVERT(VARCHAR, CIE.Fecha_Creacion, 103) AS Fecha_Informe,
                              CP.Sucursal,
                              S.des_sucursal,
                              CP.Documento_Cliente,
                              MC.cNumeroTelefono + CASE WHEN LEN(cSegundoNumeroTelefono) > 0 THEN ' - ' + cSegundoNumeroTelefono ELSE '' END AS TELEFONO_CLIENTE,
                              MC.cEmail,
                              _CP.cNombreCliente AS NOMBRE_EMPRESA,
                              DP.Tipo_Muestra,
                              TA.Des_TipoAnalisis,
                              CONVERT(VARCHAR, DAR.Fecha_PreCierre, 103) AS Fecha_CierreInforme,
                              CP.Observacion AS Referencia_Cliente,
                              CONVERT(VARCHAR, COALESCE(DAR.Fecha_InicioEnsayo, CP.FechaHora_Recepcion), 20) AS Fecha_InicioEnsayo,
                              CONVERT(VARCHAR, COALESCE(DAR.Fecha_InicioEnsayo, CP.FechaHora_Recepcion), 103) AS Fecha_InicioEnsayo2,
                              CP.Mostrar_Contacto
                        FROM  _max_labperu_CabeceraPedido CP
                              LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                              LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
                                AND DP.Id = DAR.Id_Detalle_Pedido
                              INNER JOIN _max_labperu_PagoVenta PV ON CP.Id_Pedido = PV.Id_Pedido
                              INNER JOIN maestroCliente MC ON CP.iIdCliente = MC.iIdCliente
                              INNER JOIN _max_labperu_TiposMuestra TM ON DP.Tipo_Muestra = TM.Id
                              INNER JOIN _max_labperu_DetalleEnvase DE ON DP.Detalle_Envase = DE.Id
                              LEFT JOIN _max_labperu_CorrelativoInformeEnsayos CIE ON DAR.Id_Pedido = CIE.Id_Pedido
                                AND DAR.Id_Detalle_Pedido = CIE.Id_Detalle_Pedido
                              INNER JOIN _max_labperu_Sucursales S ON CP.Sucursal = S.Id
                              INNER JOIN Cabecera_Pedido _CP ON CP.Id_Pedido = _CP.iId_Cabecera_Pedido
                              INNER JOIN _max_labperu_TipoAnalisis TA ON DP.Tipo_Analisis = TA.Id
                       WHERE  CP.es_anulada = 0
                         AND  DP.Elemento_Analisis NOT LIKE '%NEWMONT%'
                         AND  DP.Elemento_Analisis NOT LIKE '%CARBON%'
                         AND  DP.Elemento_Analisis NOT LIKE '%METALURGICA%'
                         AND  CONVERT(VARCHAR, CP.FechaHora_Recepcion, 23) BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."'";

      if (strlen($id_cliente) > 0){
        $q_resultados .= " AND CP.Documento_Cliente = '".$id_cliente."'";
        $q_resultados .= " AND DAR.Cod_EstadoResultadosCliente != 0";
      }

      if ($agrupados == 1){
        $q_resultados .= " AND DAR.Cod_EstadoResultadosCliente = 2";
      }

      $q_resultados .= " ORDER BY CP.FechaHora_Recepcion DESC, DP.Id DESC";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
          while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
            $estado = 1;

            // Comprobando si los análisis existen en la tabla de Resultados de Análisis
              $id_pedido = $row_resultados["Id_Pedido"];
              $id_detalle = $row_resultados["Id_Detalle"];

              $q_exists = "SELECT COUNT(Id) AS _EXISTS
                             FROM _max_labperu_DetalleAnalisisResultados
                            WHERE Id_Pedido = ".$id_pedido."
                              AND Id_Detalle_Pedido = ".$id_detalle;

              if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
                while($row_exists = sqlsrv_fetch_array($res_exists)) {
                  $q_exists = $row_exists["_EXISTS"];
                }
              }

              // Si no tiene registros se deben insertar
                if ($q_exists == 0){
                  $q_insert = "INSERT INTO _max_labperu_DetalleAnalisisResultados (Id_Pedido, Id_Detalle_Pedido, bPeso_MuestraFundicion,
                                                                                   bPeso_RegulosFundicion, bPeso_DoreMicro, bPeso_OroMicro,
                                                                                   nPeso_MuestraFundicion, nPeso_RegulosFundicion, nPeso_DoreMicro,
                                                                                   nPeso_OroMicro) VALUES(";

                  $q_insert .= $row_resultados["Id_Pedido"].", ".$row_resultados["Id_Detalle"].", 1,
                               1, 1, 1,
                               0.00, 0.00, 0.00,
                               0.00)";

                  if ($res = sqlsrv_query($enlacehost, $q_insert)) {
                  }
                }

            array_push($r, $row_resultados);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Grabar_AnalisisResultados':
      $estado = 0;

      // Recupera variables para tabla de pedido en BD Omar
        $id_pedido = $_POST["Id_Pedido"];
        $id_detallepedido = $_POST["Id_DetallePedido"];
        $resultado = (strlen(trim($_POST["Resultado"])) == 0 ? 'NULL' : $_POST["Resultado"]);
        $campo = $_POST["Campo"];

        if ($resultado != 'NULL'){
          if (trim($resultado) != '-'){
            if ($campo != 'Observacion_Reporte'){
              if (!is_numeric($resultado)){
                echo json_encode(array('estado' => 2));

                return;
              }
            }
          }
        }

      // // Verifica que si se trata de un número con el símbolo "<" ó ">"
      //   $is_simbol = 0;
      //   $simbolo = substr(trim($resultado), 0, 1);

      //   if ($simbolo == '<' || $simbolo == '>'){
      //     $is_simbol = 1;
      //   }

      //   if ($is_simbol == 1){
      //     // Determinando si se trata de un número válido
      //       $res = trim(substr($resultado, 1));

      //       if (!is_numeric($res)){
      //         echo json_encode(array('estado' => 2));

      //         return;
      //       }

      //     // Identificando si es entero o decimal
      //       if (strrpos($res, '.') === false){
      //         $is_entero = 1;
      //       }
      //       else{
      //         $is_entero = 0;
      //       }

      //     // Identificando el número de 9 según el símbolo: "<" ó ">"
      //       if ($simbolo == '<'){
      //         if ($is_entero == 1){
      //           $num_nueves = '9999999'; // 7 Nueves
      //         }
      //         else{
      //           $num_nueves = '99999999'; // 8 Nueves
      //         }
      //       }

      //       if ($simbolo == '>'){
      //         if ($is_entero == 1){
      //           $num_nueves = '999999999'; // 9 Nueves
      //         }
      //         else{
      //           $num_nueves = '9999999999'; // 10 Nueves
      //         }
      //       }

      //     // Obtiene la parte decimal
      //       $decimal = substr($res, strpos($res, '.') + 1);

      //     // Obteniene el número entero de los decimales
      //       $num_entero = intval($decimal) - 1;

      //       if ($num_entero == -1){
      //         $is_entero = 1;
      //       }

      //     // Armando el resultado
      //       if ($is_entero == 1){
      //         $resultado = ($res - 1).'.'.$num_nueves;
      //       }
      //       else{
      //         // Obtiene la parte antes del "." decimal
      //           $num_left = substr($res, 0, strpos($res, '.'));

      //         // Obteniendo la cantidad de CEROS de la parte decimal
      //           $c = 0;
      //           $num_ceros = '';

      //           while ($c < strlen($decimal)){
      //             if (substr($decimal, $c, 1) == 0){
      //               $num_ceros .= '0';
      //             }

      //             $c += 1;
      //           }

      //         // 3. Armando el resultado final
      //           $resultado = $num_left.'.'.$num_ceros.$num_entero.$num_nueves;
      //       }
      //   }

      // Grabando datos
        $q_update = "UPDATE _max_labperu_DetalleAnalisisResultados SET ".
                            $campo." = ".(($resultado == 'NULL') ? 'NULL' : (($resultado == '-') ? 99999.99999 : "'".$resultado."'"))
                            ."
                      WHERE Id_Pedido = ".$id_pedido."
                        AND Id_Detalle_Pedido = ".$id_detallepedido;

        if ($res = sqlsrv_query($enlacehost, $q_update)) {
          $estado = 1;

          // Actualiza campos de Onzas para Au y Ag
            if (strpos($campo, 'au') >= 0 || strpos($campo, 'ag') >= 0){
              $q_onzas = "UPDATE _max_labperu_DetalleAnalisisResultados SET
                                 Ley_Au_ot = Ley_Au_gt / 34.285,
                                 Ley_Ag_ot = Ley_Ag_gt / 34.285
                           WHERE Id_Pedido = ".$id_pedido."
                             AND Id_Detalle_Pedido = ".$id_detallepedido;

              if ($res = sqlsrv_query($enlacehost, $q_onzas)) {
              }
            }

          // Actualiza Fecha de Registro si está en NULL
            if ($resultado != 'NULL'){
              date_default_timezone_set("America/Lima");

              $date = date('Y-m-d');
              $time = date('H:i:s');

              $q_updatefecha = "UPDATE _max_labperu_DetalleAnalisisResultados SET
                                       Fecha_Registro = '".($date.' '.$time)."'
                                 WHERE Id_Pedido = ".$id_pedido."
                                   AND Id_Detalle_Pedido = ".$id_detallepedido."
                                   AND Fecha_Registro IS NULL";

              if ($res = sqlsrv_query($enlacehost, $q_updatefecha)) {
              }
            }
        }
        else{
          $estado = 0;

        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Grabar_AnalisisResultados_Old':
      $estado = 0;

      // Recupera variables para tabla de pedido en BD Omar
        $id_pedido = $_POST["Id_Pedido"];
        $id_detallepedido = $_POST["Id_DetallePedido"];
        $resultado = $_POST["Resultado"];
        $campo = $_POST["Campo"];

      // Verifica que si se trata de un número con el símbolo "<" ó ">"
        $is_simbol = 0;
        $simbolo = substr(trim($resultado), 0, 1);

        if ($simbolo == '<' || $simbolo == '>'){
          $is_simbol = 1;
        }

        if ($is_simbol == 1){
          // Determinando si se trata de un número válido
            $res = trim(substr($resultado, 1));

            if (!is_numeric($res)){
              echo json_encode(array('estado' => 2));

              return;
            }

          // Identificando si es entero o decimal
            if (strrpos($res, '.') === false){
              $is_entero = 1;
            }
            else{
              $is_entero = 0;
            }

          // Identificando el número de 9 según el símbolo: "<" ó ">"
            if ($simbolo == '<'){
              if ($is_entero == 1){
                $num_nueves = '9999999'; // 7 Nueves
              }
              else{
                $num_nueves = '99999999'; // 8 Nueves
              }
            }

            if ($simbolo == '>'){
              if ($is_entero == 1){
                $num_nueves = '999999999'; // 9 Nueves
              }
              else{
                $num_nueves = '9999999999'; // 10 Nueves
              }
            }

          // Obtiene la parte decimal
            $decimal = substr($res, strpos($res, '.') + 1);

          // Obteniene el número entero de los decimales
            $num_entero = intval($decimal) - 1;

            if ($num_entero == -1){
              $is_entero = 1;
            }

          // Armando el resultado
            if ($is_entero == 1){
              $resultado = ($res - 1).'.'.$num_nueves;
            }
            else{
              // Obtiene la parte antes del "." decimal
                $num_left = substr($res, 0, strpos($res, '.'));

              // Obteniendo la cantidad de CEROS de la parte decimal
                $c = 0;
                $num_ceros = '';

                while ($c < strlen($decimal)){
                  if (substr($decimal, $c, 1) == 0){
                    $num_ceros .= '0';
                  }

                  $c += 1;
                }

              // 3. Armando el resultado final
                $resultado = $num_left.'.'.$num_ceros.$num_entero.$num_nueves;
            }
        }

      // Grabando datos
        $q_update = "UPDATE _max_labperu_DetalleAnalisisResultados SET ".
                            $campo." = ".(($resultado == 'NULL') ? 'NULL' : (($resultado == '-') ? 99999.99999 : "'".$resultado."'"))
                            ."
                      WHERE Id_Pedido = ".$id_pedido."
                        AND Id_Detalle_Pedido = ".$id_detallepedido;

        if ($res = sqlsrv_query($enlacehost, $q_update)) {
          $estado = 1;

          // Actualiza campos de Onzas para Au y Ag
            if (strpos($campo, 'au') >= 0 || strpos($campo, 'ag') >= 0){
              $q_onzas = "UPDATE _max_labperu_DetalleAnalisisResultados SET
                                 Ley_Au_ot = Ley_Au_gt / 34.285,
                                 Ley_Ag_ot = Ley_Ag_gt / 34.285
                           WHERE Id_Pedido = ".$id_pedido."
                             AND Id_Detalle_Pedido = ".$id_detallepedido;

              if ($res = sqlsrv_query($enlacehost, $q_onzas)) {
              }
            }

          // Actualiza Fecha de Registro si está en NULL
            if ($resultado != 'NULL'){
              date_default_timezone_set("America/Lima");

              $date = date('Y-m-d');
              $time = date('H:i:s');

              $q_updatefecha = "UPDATE _max_labperu_DetalleAnalisisResultados SET
                                       Fecha_Registro = '".($date.' '.$time)."'
                                 WHERE Id_Pedido = ".$id_pedido."
                                   AND Id_Detalle_Pedido = ".$id_detallepedido."
                                   AND Fecha_Registro IS NULL";

              if ($res = sqlsrv_query($enlacehost, $q_updatefecha)) {
              }
            }
        }
        else{
          $estado = 0;

        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Grabar_CierreClientes':
      $estado = 0;

      date_default_timezone_set("America/Lima"); 

      $date = date('Y-m-d');
      $time = date('H:i:s');

      // Recupera variables para tabla de pedido en BD Omar
        $id_pedido = $_POST["Id_Pedido"];
        $id_detallepedido = $_POST["Id_DetallePedido"];
        $estado_cierre = $_POST["Estado_Cierre"];

      // Grabando datos
        $q_update = "UPDATE _max_labperu_DetalleAnalisisResultados SET
                            Cod_EstadoResultadosCliente = ".$estado_cierre.",
                            Fecha_PreCierre = '".($date.' ' .$time)."'
                      WHERE Id_Pedido = ".$id_pedido."
                        AND Id_Detalle_Pedido = ".$id_detallepedido;

        if ($res = sqlsrv_query($enlacehost, $q_update)) {
          $estado = 1;

          // Si es un cierre final se debe asignar el código de Informe de Ensayos si es que no lo tiene
          if ($estado_cierre == 2){
            $correlativo = 'x';

            // // Verifica si tiene asignado un correlativo de I.E.
            //   $q_codigoinforme = "SELECT  Correlativo
            //                         FROM  _max_labperu_CorrelativoInformeEnsayos
            //                        WHERE  Id_Pedido =".$id_pedido."
            //                          AND  Id_Detalle_Pedido = ".$id_detallepedido;

            //   if ($res_codigoinforme = sqlsrv_query($enlacehost, $q_codigoinforme)) {
            //     while($row_codigoinforme = sqlsrv_fetch_array($res_codigoinforme)) {
            //       $correlativo = $row_codigoinforme["Correlativo"];
            //     }
            //   }

            // // Si no tiene correlativo de I.E. lo crea
            //   if ($correlativo == 'x'){
            //     $q_newcorrelativo = "SELECT  ISNULL(MAX(Correlativo), 11999) + 1 AS CORRELATIVO
            //                            FROM  _max_labperu_CorrelativoInformeEnsayos";

            //     if ($res_newcorrelativo = sqlsrv_query($enlacehost, $q_newcorrelativo)) {
            //       while($row_newcorrelativo = sqlsrv_fetch_array($res_newcorrelativo)) {
            //         $correlativo = $row_newcorrelativo["CORRELATIVO"];
            //       }
            //     }

            //     // Guarda el correlativo obtenido
            //       date_default_timezone_set("America/Lima"); 

            //       $date = date('Y-m-d');
            //       $time = date('H:i:s');

            //       $q_insert = "INSERT INTO _max_labperu_CorrelativoInformeEnsayos (Id_Pedido, Id_Detalle_Pedido, Correlativo, Fecha_Creacion) VALUES(";
            //       $q_insert .= $id_pedido.", ";
            //       $q_insert .= $id_detallepedido.", ";
            //       $q_insert .= $correlativo.", ";
            //       $q_insert .= "'".($date.' ' .$time)."')";

            //       if ($res = sqlsrv_query($enlacehost, $q_insert)) {
            //       }
            //   }
          }            
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Valida_IngresoResultados':
      $r = array();
      $estado = 0;

      $id_pedido = $_POST["Id_Pedido"];
      $id_detallepedido = $_POST["Id_DetallePedido"];

      $q_resultados = "SELECT COALESCE(ISNULL(DAR.Ley_Au_gt, 0) + 
                              ISNULL(DAR.Ley_Au_ot, 0) + 
                              ISNULL(DAR.Ley_Ag_gt, 0) + 
                              ISNULL(DAR.Ley_Ag_ot, 0) + 
                              ISNULL(DAR.Porc_CU, 0) + 
                              ISNULL(DAR.Porc_PB, 0) + 
                              ISNULL(DAR.Porc_ZN, 0) + 
                              ISNULL(DAR.Porc_AS, 0) + 
                              ISNULL(DAR.Porc_SB, 0) + 
                              ISNULL(DAR.Porc_S, 0) + 
                              ISNULL(DAR.Porc_FE, 0) + 
                              ISNULL(DAR.Porc_H2O, 0), 0) AS TOTAL
                         FROM  _max_labperu_CabeceraPedido CP
                              LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                              LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
                                AND DP.Id = DAR.Id_Detalle_Pedido
                              INNER JOIN _max_labperu_PagoVenta PV ON CP.Id_Pedido = PV.Id_Pedido
                        WHERE  CP.Id_Pedido = ".$id_pedido."
                          AND  DP.Id = ".$id_detallepedido."
                       ORDER BY FechaHora_Recepcion DESC";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
          while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
            $estado = 1;

            array_push($r, $row_resultados);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'LogIn_Cliente':
      $estado = 0;

      // Recupera parámetros enviados
        $id_usuario = trim($_POST["Usuario"]);
        $clave = trim($_POST["Clave"]);

      // Grabando datos
        $q_login = "SELECT COUNT(Id) AS _COUNT
                      FROM tb_usuario_clientes
                     WHERE Numero_RUC = '".$id_usuario."'
                       AND Clave = '".md5($clave)."'";

        if ($res = mysqli_query($enlace, $q_login)){
          while($row = mysqli_fetch_array($res)){
            $estado = (($row["_COUNT"] == 0) ? 0 : 1);

            $_SESSION["id"] = $id_usuario;
            $_SESSION["sesion_cliente"] = 1;
          }
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Generate_QR':
      // Recupera variables para tabla de pedido en BD Omar
        $url = $_POST["url"];
        $id_pedido = $_POST["Id_Pedido"];
        $id_detallepedido = $_POST["Id_DetallePedido"];

        $dir = '../tmp_files/';
        $file_name = $dir.'tmp_qr_'.$id_pedido.$id_detallepedido.'.png';

        if (!file_exists($dir)){
          mkdir($dir);
        }

      // Genera QR
        QRcode::png($url, $file_name, 'H', 3, 3);

      echo json_encode(array('estado' => 1));

      break;

    case 'Get_AtencionPedidos':
      $r = array();
      $estado = 0;

      $fecha_inicio = $_POST["fecha_inicio"];
      $fecha_fin = $_POST["fecha_fin"];
      $dni_cliente = $_POST["dni_cliente"];
      $nom_cliente = $_POST["nom_cliente"];
      $medio_pago = $_POST["medio_pago"];
      $num_recibo = $_POST["num_recibo"];

      $q_resultados = "SELECT CP.Id_Pedido,
                              CP.Sucursal,
                              S.des_sucursal,
                              UPPER(ISNULL(TDP.cDescripcion, 'RECIBO')) AS COMPROBANTE,

                              /*
                              CASE WHEN TDP.cDescripcion IS NULL
                                THEN PV.recibo_correlativo_sucursal + '-' + RIGHT('00000000' + CONVERT(VARCHAR, PV.recibo_correlativo_codigo), 8)
                              ELSE CV.Serie_Comprobante + ' - ' + RIGHT('00000000' + CONVERT(VARCHAR, CV.Correlativo_Comprobante), 8) END AS NUM_COMPROBANTE,
                              */


                              PV.recibo_correlativo_sucursal + '-' + RIGHT('00000000' + CONVERT(VARCHAR, PV.recibo_correlativo_codigo), 8) AS COMPROBANTE_1,
                              CASE WHEN CV.Serie_Comprobante IS NULL THEN '' ELSE CV.Serie_Comprobante + ' - ' + RIGHT('00000000' + CONVERT(VARCHAR, CV.Correlativo_Comprobante), 8) END AS COMPROBANTE_2,

                              CP.Nombre_Cliente,
                              CP.Documento_Cliente,
                              _CP.cNombreCliente AS CLIENTE_COMPROBANTE,
                              _CP.cNumDocCliente AS CLIENTE_DOCUMENTO,
                              PV.Id_MedioPago,
                              MP.des_mediopago,
                              MP.con_color,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 103) + ' ' + SUBSTRING(CONVERT(VARCHAR, CP.FechaHora_Recepcion, 108), 1, 5) AS FechaHora_Recepcion,
                              PV.Total_Venta,
                              CASE WHEN CP.Incluir_IGV = 1 THEN 'SI' ELSE 'NO' END AS INC_IGV,
                              PV.es_pagado,
                              CASE WHEN PV.es_pagado = 1 THEN 'PAGADO' ELSE 'PENDIENTE' END AS ESTADO_PAGADO,
                              ISNULL(CONVERT(VARCHAR, PV.fecha_pagado, 103), '') AS Fecha_Pagado,
                              CP.usu_usuario,
                              ISNULL(CP.usuario_anulacion, '') AS USUARIO_ANULACION,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 112) AS FECHA_RECEPCION,
                              S.cod_sucursal,
                              _CP.iIdCompany,
                              _CP.iId_Terminal,
                              _CP.iIdTienda,
                              _CP.iIdUser,
                              CV.Id_Comprobante,
                              CP.Cod_Interno,
                              CP.es_anulada
                         FROM _max_labperu_CabeceraPedido CP
                              LEFT JOIN _max_labperu_ComprobantesVenta CV ON CP.Id_Pedido = CV.Id_Pedido
                              LEFT JOIN Tipo_Documento_Pago TDP ON CV.Id_Comprobante = TDP.iIdTipoDocumento
                              INNER JOIN _max_labperu_PagoVenta PV ON CP.Id_Pedido = PV.Id_Pedido
                              INNER JOIN _max_labperu_Sucursales S ON CP.Sucursal = S.Id
                              INNER JOIN _max_labperu_MedioPago MP ON PV.Id_MedioPago = MP.Id
                              INNER JOIN Cabecera_Pedido _CP ON CP.Id_Pedido = _CP.iId_Cabecera_Pedido
                        WHERE  CONVERT(VARCHAR, CP.FechaHora_Recepcion, 23) BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."'";

      if (strlen($dni_cliente) > 0){
        $q_resultados .= " AND CP.Documento_Cliente LIKE '%".trim($dni_cliente)."%'";
      }

      if (strlen($nom_cliente) > 0){
        $q_resultados .= " AND CP.Nombre_Cliente LIKE '%".trim($nom_cliente)."%'";
      }

      if (strlen($medio_pago) > 0){
        $q_resultados .= " AND PV.Id_MedioPago = '".$medio_pago."'";
      }

      if (strlen($num_recibo) > 0){
        $q_resultados .= " AND RIGHT('00000000' + CONVERT(VARCHAR, PV.recibo_correlativo_codigo), 8) LIKE '%".trim($num_recibo)."%'";
      }

      $q_resultados .= " ORDER BY CP.FechaHora_Recepcion DESC, PV.recibo_correlativo_codigo DESC";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
        while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
          $estado = 1;

          array_push($r, $row_resultados);
        }
        
        echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Get_CorrelativoComprobante':
      $r = array();
      $estado = 0;

      $TipoComprobante = $_POST["Tipo_Comprobante"];
      $NumSerie = $_POST["NumSerie"];

      $q_Correlativo = "SELECT  MAX(Correlativo_Comprobante) + 1 AS NUM_COMPROBANTE
                          FROM  _max_labperu_ComprobantesVenta
                         WHERE  Id_Comprobante = ".$TipoComprobante."
                           AND  Serie_Comprobante = '".(($TipoComprobante == 1001) ? 'F' : 'B').$NumSerie."'";

      if ($res_Correlativo = sqlsrv_query($enlacehost, $q_Correlativo)) {
          while($row_Correlativo = sqlsrv_fetch_array($res_Correlativo)) {
            $estado = 1;

            array_push($r, $row_Correlativo);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Get_ResumenVenta':
      $r = array();
      $estado = 0;

      $id_pedido = $_POST["Id_Pedido"];

      $q_total = "SELECT ISNULL(SUM(Precio_Final), 0) AS SUB_TOTAL,
                         ISNULL(SUM(Precio_Exceso), 0) AS EXCESO,
                         ROUND(ISNULL(SUM(Precio_Final), 0) + ISNULL(SUM(Precio_Exceso), 0), 2) AS TOTAL
                    FROM _max_labperu_DetallePedido D
                   WHERE Id_Pedido = ".$id_pedido;

      if ($res_total = sqlsrv_query($enlacehost, $q_total)) {
          while($row_total = sqlsrv_fetch_array($res_total)) {
            $estado = 1;

            array_push($r, $row_total);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Get_DetalleVenta':
      $r = array();
      $estado = 0;

      $id_pedido = $_POST["Id_Pedido"];

      $q_detalle = "SELECT D.Nom_Muestra,
                           D.Elemento_Analisis,
                           D.Precio_Final
                      FROM _max_labperu_DetallePedido D
                     WHERE D.Id_Pedido = ".$id_pedido;

      if ($res_detalle = sqlsrv_query($enlacehost, $q_detalle)) {
        while($row_detalle = sqlsrv_fetch_array($res_detalle)) {
          $estado = 1;

          array_push($r, $row_detalle);
        }
        
        echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Procesar_Comprobante':
      $estado = 0;

      // Recupera variables
        $id_pedido = $_POST["id_pedido"];
        $idCompany = $_POST["idCompany"];
        $idTerminal = $_POST["idTerminal"];
        $idTienda = $_POST["idTienda"];
        $iIdUser = $_POST["iIdUser"];
        $dateKey = $_POST["dateKey"];
        $iIdCliente = $_POST["iIdCliente"];
        $cNombreCliente = $_POST["cNombreCliente"];
        $IdDocCliente = $_POST["IdDocCliente"];
        $IdTipoDocSunat = $_POST["IdTipoDocSunat"];
        $cNumDocCliente = $_POST["cNumDocCliente"];
        $idTipoDocPago = $_POST["idTipoDocPago"];
        $serie_comprobante = (($idTipoDocPago == 1001) ? 'F' : 'B').$_POST["serie_comprobante"];
        $num_comprobante = $_POST["num_comprobante"];
        $inc_igv = $_POST["inc_igv"];

      // Verifica si este número fue generado anteriormente
        $q_exists = "SELECT  COUNT(Id) AS _Exists
                       FROM  _max_labperu_ComprobantesVenta
                      WHERE  Id_Comprobante = ".$idTipoDocPago."
                        AND  Serie_Comprobante = '".$serie_comprobante."'
                        AND  Correlativo_Comprobante = ".$num_comprobante;

        if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
          while ($row_exists = sqlsrv_fetch_array($res_exists)) {
            if ($row_exists["_Exists"] > 0){
              $estado = 99;

              echo json_encode(array('estado' => $estado));

              return;
            }
          }
        }

      // 1. Verifica si cambió el usuario para actualizarlo en la cabecera
        if (strlen($iIdCliente) > 0){
          $q_updatecliente = "UPDATE Cabecera_Pedido
                                 SET iIdCliente = ".$iIdCliente.",
                                     cNombreCliente = ".$cNombreCliente.",
                                     id_DocCliente = ".$IdDocCliente.",
                                     id_TipoDocSunat = ".$IdTipoDocSunat.",
                                     cNumDocCliente = ".$cNumDocCliente.",
                                     cDireccionCliente = (SELECT MC.cDireccion FROM maestroCliente MC WHERE MC.iIdCliente = ".$iIdCliente.")
                               WHERE iId_Cabecera_Pedido = ".$id_pedido;

          if ($res_updatecliente = sqlsrv_query($enlacehost, $q_updatecliente)) {
          }
          else{
            echo "Error en el proceso N° 1. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 1) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

            $estado = '1';
            echo json_encode(array('estado' => $estado));

            return;
          }
        }
        else{
          // 1a. Actualiza la dirección del cliente en la tabla Cebecera_Pedido
            $q_updatecliente = "UPDATE Cabecera_Pedido
                                   SET cDireccionCliente = SUBSTRING((SELECT MC.cDireccion FROM maestroCliente MC WHERE MC.iIdCliente = Cabecera_Pedido.iIdCliente), 0, 100)
                                 WHERE iId_Cabecera_Pedido = ".$id_pedido;

            if ($res_updatecliente = sqlsrv_query($enlacehost, $q_updatecliente)) {
            }
            else{
              echo "Error en el proceso N° 1a. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 1a) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.\nQuery: ".$q_updatecliente;

              $estado = '1a';
              echo json_encode(array('estado' => $estado));

              return;
            }
        }

      // 1b. Actualiza el documento de cliente
        if ($idTipoDocPago == 1001){
          $q_update = "UPDATE Cabecera_Pedido
                          SET id_TipoDocSunat = 6
                        WHERE iId_Cabecera_Pedido = ".$id_pedido;

          if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
          }
          else{
            echo "Error en el proceso N° 1b. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 1a) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.\nQuery: ".$q_update;

            $estado = '1b';
            echo json_encode(array('estado' => $estado));

            return;
          }
        }

      // 2. Si tiene el Item Exceso lo debe agregar
        $exceso = 0;

        $q_exceso = "SELECT ISNULL(SUM(Precio_Exceso), 0) AS EXCESO
                       FROM _max_labperu_DetallePedido D
                      WHERE Id_Pedido = ".$id_pedido;

        if ($res_exceso = sqlsrv_query($enlacehost, $q_exceso)) {
          while($row_exceso = sqlsrv_fetch_array($res_exceso)) {
            $exceso = $row_exceso["EXCESO"];
          }
        }

        if ($exceso > 0){
          $q_insertexceso = "INSERT INTO Detalle_Pedido (iId_Cabecera_Pedido, iNumItem, iIdProducto, id_producto_padre,
                                                         bCabeceraPack, bDetallePack, bEs_Variante, bEs_Modificado,
                                                         cDescripcion_Combo, cProductName, cDescripcion_Modificador, cDescripcion_Variante,
                                                         cObservacionProducto, cDescripcion_Unidad, cDescripcion_Unidad_Sunat, iCantidad,
                                                         bAtendido, dCantidad_Atendida, dPrecioUnidad, dPrecioVentaFinal,
                                                         bUsaDescuento, dMontoDescuento, id_Company, id_Terminal,
                                                         id_Tienda, id_Usuario, b_Visible_Pantalla, bPrecioVariable,
                                                         bUsaTiempo, dHoraInicio, dHoraFinal, cEstadoEliminado,
                                                         cEstadoGuardado, iCantidadEliminada) VALUES(";

          $q_insertexceso .= $id_pedido.", (SELECT  MAX(iNumItem) + 1 AS NUM_ITEM
                                              FROM  Detalle_Pedido
                                             WHERE  iId_Cabecera_Pedido = ".$id_pedido."), 99999, 0, ";
          $q_insertexceso .= "0, 0, 0, 0, ";
          $q_insertexceso .= "'', 'Exceso', '', '', ";
          $q_insertexceso .= "'', 'Unidad(p)', 'NIU', 1, ";
          $q_insertexceso .= "0, 0.00000, ".$exceso.", ".$exceso.", ";
          $q_insertexceso .= "0, 0.00, ".$idCompany.", ".$idTerminal.", ";
          $q_insertexceso .= $idTienda.", ".$iIdUser.", 0, 0, ";
          $q_insertexceso .= "0, NULL, NULL, '', ";
          $q_insertexceso .= "'G', 0.000)";

          if ($res_insertexceso = sqlsrv_query($enlacehost, $q_insertexceso)) {
          }
          else{
            echo "Error en el proceso N° 2. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 2) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

            $estado = '2';
            echo json_encode(array('estado' => $estado));

            return;
          }
        }

      // 3. Cambia el estado de la Cabecera Pedido a "T"
        $q_updateestado = "UPDATE Cabecera_Pedido
                              SET cEstadoPermanencia = 'T'
                            WHERE iId_Cabecera_Pedido = ".$id_pedido;

        if ($res_updateestado = sqlsrv_query($enlacehost, $q_updateestado)) {
        }
        else{
          echo "Error en el proceso N° 3. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 3) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

            $estado = '3';
            echo '$q_updateestado: '.$q_updateestado;
            echo json_encode(array('estado' => $estado));

          return;
        }

      // 4. Actualiza los precios de la tabla de Detalle_Pedido aumentando el IGV
        if ($inc_igv == 'SI'){
          $q_updateIGV = "UPDATE Detalle_Pedido
                             SET dPrecioUnidad = ROUND(dPrecioUnidad * 1.18, 2),
                                 dPrecioVentaFinal = ROUND(dPrecioUnidad * 1.18, 2)
                           WHERE iId_Cabecera_Pedido = ".$id_pedido;

          if ($res_updateIGV = sqlsrv_query($enlacehost, $q_updateIGV)) {
          }
          else{
            echo "Error en el proceso N° 4. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 4) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

            $estado = '4';
            echo '$q_updateIGV: '.$q_updateIGV;
            echo json_encode(array('estado' => $estado));

            return;
          }
        }

      // 5. Actualiza todos los precios con 1 por seguridad (hay un proceso que cambia las cantidades)
        $q_updateCANT = "UPDATE Detalle_Pedido
                            SET iCantidad = 1,
                                dPrecioVentaFinal = dPrecioUnidad
                          WHERE iId_Cabecera_Pedido = ".$id_pedido;

          if ($res_updateCANT = sqlsrv_query($enlacehost, $q_updateCANT)) {
          }
          else{
            echo "Error en el proceso N° 5. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 5) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

            $estado = '5';
            echo '$q_updateCANT: '.$q_updateCANT;
            echo json_encode(array('estado' => $estado));

            return;
          }

      // 6. Actualizando el nombre de las muestras con los elementos a analizar
        $q_updateNames = "UPDATE Detalle_Pedido
                             SET cProductName = SUBSTRING(cProductName + ': (' + (SELECT REPLACE(DP.Elemento_Analisis, ' ', '')
                                                                          FROM _max_labperu_DetallePedido DP
                                                                         WHERE DP.Id_Pedido = ".$id_pedido."
                                                                           AND DP.Id_Item = Detalle_Pedido.iId_Detalle_Pedido) + ')', 0, 50)
                           WHERE iId_Cabecera_Pedido = ".$id_pedido."
                             AND cProductName <> 'Exceso'";

          if ($res_updateNames = sqlsrv_query($enlacehost, $q_updateNames)) {
          }
          else{
            echo "Error en el proceso N° 6. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 6) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.\n";

            $estado = '6';

            // Restaurando registros
              // 1. Exceso
                if ($exceso > 0){
                  $q_delete = "DELETE FROM Detalle_Pedido
                                WHERE iId_Cabecera_Pedido = ".$id_pedido."
                                  AND iIdProducto = 99999";

                  if ($res_delete = sqlsrv_query($enlacehost, $q_delete)) {
                  }
                }

              // 2. Si es IGV
                if ($inc_igv == 'SI'){
                  $q_update = "UPDATE Detalle_Pedido
                                  SET dPrecioUnidad = (dPrecioUnidad / 1.18),
                                      dPrecioVentaFinal = (dPrecioVentaFinal / 1.18)
                                WHERE iId_Cabecera_Pedido = ".$id_pedido;

                  if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
                  }
                }

              // 3. Devolver el estado a la tabla "Cabecera_Pedido"
                $q_updateestado = "UPDATE Cabecera_Pedido
                                      SET cEstadoPermanencia = 'R'
                                    WHERE iId_Cabecera_Pedido = ".$id_pedido;

                if ($res_updateestado = sqlsrv_query($enlacehost, $q_updateestado)) {
                }

              echo '$q_updateNames: '.$q_updateNames;
              echo json_encode(array('estado' => $estado));

            return;
          }

      // 7. Procesa el Comprobante
        $exce_sp = "EXEC sp_Generar_Venta_v17_MaxLabPeru ";
        $exce_sp .= $idCompany.", ";
        $exce_sp .= $idTerminal.", ";
        $exce_sp .= $idTienda.", ";
        $exce_sp .= $id_pedido.", ";
        $exce_sp .= $iIdUser.", ";
        $exce_sp .= "0, ";
        $exce_sp .= $dateKey.", ";
        $exce_sp .= "0, ";
        $exce_sp .= $idTipoDocPago.", ";
        $exce_sp .= "0, ";
        $exce_sp .= "'', ";
        $exce_sp .= "'".$serie_comprobante."', ";
        $exce_sp .= "'".str_pad($num_comprobante, 8, "0", STR_PAD_LEFT)."', ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "'', ";
        $exce_sp .= "'', ";
        $exce_sp .= "'', ";
        $exce_sp .= "'', ";
        $exce_sp .= "'', ";
        $exce_sp .= "'', ";
        $exce_sp .= "0, ";
        $exce_sp .= "'', ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "'', ";
        $exce_sp .= "0, ";
        $exce_sp .= "'', ";
        $exce_sp .= "'', ";
        $exce_sp .= "0, ";
        $exce_sp .= "'', ";
        $exce_sp .= "0, ";
        $exce_sp .= "0, ";
        $exce_sp .= "'', ";
        $exce_sp .= "'', ";
        $exce_sp .= "''";

        if ($res = sqlsrv_query($enlacehost, $exce_sp)) {
          date_default_timezone_set("America/Lima");

          $date = date('Y-m-d');
          $time = date('H:i:s');
          $fecha = ($date.' ' .$time);

          // Comprobando que la tabla de Venta haya sido cargada satisfactoriamente
            // 1. Cabecera
              $q_exists = "SELECT COUNT(iId_Cabecera_Venta) AS _COUNT
                             FROM Cabecera_Venta
                            WHERE iId_Cabecera_Pedido = ".$id_pedido;

              if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
                while($row_exists = sqlsrv_fetch_array($res_exists)) {
                  $exists = $row_exists["_COUNT"];

                  if ($exists == 0){
                    echo "Error en el proceso N° 7a. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 7a) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

                    $estado = '7a';
                    echo json_encode(array('estado' => $estado));

                    // Restaurando registros
                      // 1. Exceso
                        if ($exceso > 0){
                          $q_delete = "DELETE FROM Detalle_Pedido
                                        WHERE iId_Cabecera_Pedido = ".$id_pedido."
                                          AND iIdProducto = 99999";

                          if ($res_delete = sqlsrv_query($enlacehost, $q_delete)) {
                          }
                        }

                      // 2. Si es IGV
                        if ($inc_igv == 'SI'){
                          $q_update = "UPDATE Detalle_Pedido
                                          SET dPrecioUnidad = (dPrecioUnidad / 1.18),
                                              dPrecioVentaFinal = (dPrecioVentaFinal / 1.18)
                                        WHERE iId_Cabecera_Pedido = ".$id_pedido;

                          if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
                          }
                        }

                      // 3. Recupera los nombres de productos
                        $q_update = "UPDATE Detalle_Pedido
                               SET cProductName = (CASE WHEN CHARINDEX(':', cProductName) > 0 THEN SUBSTRING(cProductName, 1, CHARINDEX(':', cProductName) - 1) ELSE cProductName END)
                             WHERE iId_Cabecera_Pedido = ".$id_pedido;

                        if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
                        }

                      // 4. Devolver el estado a la tabla "Cabecera_Pedido"
                        $q_updateestado = "UPDATE Cabecera_Pedido
                                              SET cEstadoPermanencia = 'R'
                                            WHERE iId_Cabecera_Pedido = ".$id_pedido;

                        if ($res_updateestado = sqlsrv_query($enlacehost, $q_updateestado)) {
                        }

                    return;
                  }
                }
              }

            // 2. Detalle
              $q_exists = "SELECT COUNT(idDetalle_Venta) AS _COUNT
                             FROM Detalle_Venta DV
                                  INNER JOIN Cabecera_Venta CV ON DV.iIdCabecera_Venta= CV.iId_Cabecera_Venta 
                            WHERE CV.iId_Cabecera_Pedido = ".$id_pedido;

              if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
                while($row_exists = sqlsrv_fetch_array($res_exists)) {
                  $exists = $row_exists["_COUNT"];

                  if ($exists == 0){
                    echo "Error en el proceso N° 7b. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 7b) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

                    $estado = '7b';
                    echo json_encode(array('estado' => $estado));

                    // Restaurando registros
                      // 1. Exceso
                        if ($exceso > 0){
                          $q_delete = "DELETE FROM Detalle_Pedido
                                        WHERE iId_Cabecera_Pedido = ".$id_pedido."
                                          AND iIdProducto = 99999";

                          if ($res_delete = sqlsrv_query($enlacehost, $q_delete)) {
                          }
                        }

                      // 2. Si es IGV
                        if ($inc_igv == 'SI'){
                          $q_update = "UPDATE Detalle_Pedido
                                          SET dPrecioUnidad = (dPrecioUnidad / 1.18),
                                              dPrecioVentaFinal = (dPrecioVentaFinal / 1.18)
                                        WHERE iId_Cabecera_Pedido = ".$id_pedido;

                          if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
                          }
                        }

                      // 3. Recupera los nombres de productos
                        $q_update = "UPDATE Detalle_Pedido
                               SET cProductName = (CASE WHEN CHARINDEX(':', cProductName) > 0 THEN SUBSTRING(cProductName, 1, CHARINDEX(':', cProductName) - 1) ELSE cProductName END)
                             WHERE iId_Cabecera_Pedido = ".$id_pedido;

                        if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
                        }

                      // 4. Devolver el estado a la tabla "Cabecera_Pedido"
                        $q_updateestado = "UPDATE Cabecera_Pedido
                                              SET cEstadoPermanencia = 'R'
                                            WHERE iId_Cabecera_Pedido = ".$id_pedido;

                        if ($res_updateestado = sqlsrv_query($enlacehost, $q_updateestado)) {
                        }

                    return;
                  }
                }
              }

          // 8. Insertando el Comprobante registrado
            $q_comprobante = "INSERT INTO _max_labperu_ComprobantesVenta (Id_Pedido, Id_Comprobante, Serie_Comprobante,
                                                                          Correlativo_Comprobante, Fecha_Generacion) VALUES(";

            $q_comprobante .= $id_pedido.", ";
            $q_comprobante .= $idTipoDocPago.", ";
            $q_comprobante .= "'".$serie_comprobante."', ";
            $q_comprobante .= "'".str_pad($num_comprobante, 8, "0", STR_PAD_LEFT)."', ";
            $q_comprobante .= "'".$fecha."')";

            if ($res_comprobante = sqlsrv_query($enlacehost, $q_comprobante)) {
            }
            else{
              echo "Error en el proceso N° 8. Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° 8) se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.";

              $estado = '8';
              echo json_encode(array('estado' => $estado));
            }
        }
        else{
          $estado = 9;

          // Restaurando registros
            // 1. Exceso
              if ($exceso > 0){
                $q_delete = "DELETE FROM Detalle_Pedido
                              WHERE iId_Cabecera_Pedido = ".$id_pedido."
                                AND iIdProducto = 99999";

                if ($res_delete = sqlsrv_query($enlacehost, $q_delete)) {
                }
              }

            // 2. Si es IGV
              if ($inc_igv == 'SI'){
                $q_update = "UPDATE Detalle_Pedido
                                SET dPrecioUnidad = (dPrecioUnidad / 1.18),
                                    dPrecioVentaFinal = (dPrecioVentaFinal / 1.18)
                              WHERE iId_Cabecera_Pedido = ".$id_pedido;

                if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
                }
              }

            // 3. Recupera los nombres de productos
              $q_update = "UPDATE Detalle_Pedido
                     SET cProductName = (CASE WHEN CHARINDEX(':', cProductName) > 0 THEN SUBSTRING(cProductName, 1, CHARINDEX(':', cProductName) - 1) ELSE cProductName END)
                   WHERE iId_Cabecera_Pedido = ".$id_pedido;

              if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
              }

            // 4. Devolver el estado a la tabla "Cabecera_Pedido"
              $q_updateestado = "UPDATE Cabecera_Pedido
                                    SET cEstadoPermanencia = 'R'
                                  WHERE iId_Cabecera_Pedido = ".$id_pedido;

              if ($res_updateestado = sqlsrv_query($enlacehost, $q_updateestado)) {
              }
        }

        echo json_encode(array('estado' => $estado));

      break;

    case 'Valida_IngresoResultados_All':
      $r = array();
      $estado = 0;

      $id_pedido = $_POST["Id_Pedido"];
      $id_detallepedido = $_POST["Id_DetallePedido"];
      $campos = substr($_POST["campos"], 0, -2);

      $q_resultados = "SELECT ".$campos." AS TOTAL
                         FROM  _max_labperu_CabeceraPedido CP
                              LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                              LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
                                AND DP.Id = DAR.Id_Detalle_Pedido
                              INNER JOIN _max_labperu_PagoVenta PV ON CP.Id_Pedido = PV.Id_Pedido
                        WHERE  CP.Id_Pedido = ".$id_pedido."
                          AND  DP.Id = ".$id_detallepedido."
                       ORDER BY FechaHora_Recepcion DESC";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
          while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
            $estado = 1;

            array_push($r, $row_resultados);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Valida_UsuarioExistente':
      $r = array();

      // Cambiando el idioma del servidor
      $query = "SET NAMES 'utf8'";

      if ($res = mysqli_query($enlace, $query)) {
      }

      // Valida la existencia del cliente en la tabla de Clientes
        $existe = 0;

        $q_clientes = "SELECT iIdCliente,
                              cNumeroRuc,
                              cRazonSocial
                         FROM maestroCliente
                        WHERE cNumeroRuc = '".$_POST["cod_usuario"]."'";

        if ($res_clientes = sqlsrv_query($enlacehost, $q_clientes)) {
            while($row_clientes = sqlsrv_fetch_array($res_clientes)) {
              $existe = 1;

              $iIdCliente = $row_clientes["iIdCliente"];
              $cNumeroRuc = $row_clientes["cNumeroRuc"];
              $cRazonSocial = $row_clientes["cRazonSocial"];
            }

            if ($existe == 0){
              echo json_encode(array('estado' => 0));
            }
            else{
              // Comprueba que exista en la tabla de Usuarios de Clientes
                $q_exists = "SELECT COUNT(Id) AS _EXISTS
                               FROM tb_usuario_clientes
                              WHERE Numero_RUC = '".$_POST["cod_usuario"]."'";

                if ($res_exists = mysqli_query($enlace, $q_exists)) {
                  if (mysqli_num_rows($res_exists) > 0) {
                    while($row_exists = mysqli_fetch_assoc($res_exists)) {
                      $exists = $row_exists["_EXISTS"];

                      // Si el Cliente no existe se le crea su usuario
                        if ($exists == 0){
                          $q_insert = "INSERT INTO tb_usuario_clientes (iIdCliente, Numero_RUC, Razon_Social, Clave) VALUES(";
                          $q_insert .= $iIdCliente.", ";
                          $q_insert .= "'".$cNumeroRuc."', ";
                          $q_insert .= "'".$cRazonSocial."', ";
                          $q_insert .= "md5('".$cNumeroRuc."'))";

                          if ($res_insert = mysqli_query($enlace, $q_insert)) {
                          }
                        }
                    }
                  }
                }

              echo json_encode(array('estado' => 1));
            }
        }

      break;

    case 'ValidarClaveOld':
      $r = array();

      // Cambiando el idioma del servidor
      $query = "SET NAMES 'utf8'";

      if ($res = mysqli_query($enlace, $query)) {
      }

      $query = "SELECT md5('".$_POST["clave_old"]."') = Clave AS _OK FROM tb_usuario_clientes WHERE Numero_RUC = '".$_POST["cod_usuario"]."'";

      if ($res = mysqli_query($enlace, $query)) {
        if (mysqli_num_rows($res) > 0) {
          while($row = mysqli_fetch_assoc($res)) {
            array_push($r, $row);
          }

          echo json_encode(array('estado' => 1, 'registros' => $r));
        }
        else{
          echo json_encode(array('estado' => 0));
        }
      }

      break;

    case 'GrabarCambioClave':
      // Cambiando el idioma del servidor
        $query = "SET NAMES 'utf8'";

        if ($res = mysqli_query($enlace, $query)) {
        }

        $query = "UPDATE tb_usuario_clientes SET Clave = '".md5($_POST["clave_new"])."' WHERE Numero_RUC = '".$_POST["cod_usuario"]."'";

        $estado = 0;

        // Grabando datos
        if ($res = mysqli_query($enlace, $query)) {
          $estado = 1;
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Get_ReporteVentas':
      $r = array();
      $estado = 0;

      $fecha_inicio = $_POST["fecha_inicio"];
      $fecha_fin = $_POST["fecha_fin"];
      $dni_cliente = $_POST["dni_cliente"];
      $nom_cliente = $_POST["nom_cliente"];
      $sucursal = $_POST["Sucursal"];
      $nom_muestra = $_POST["nom_muestra"];

      $q_resultados = "SELECT CP.Id_Pedido,
                              DP.Id AS Id_Detalle,
                              CP.Sucursal,
                              S.des_sucursal,
                              PV.recibo_correlativo_sucursal + '-' + RIGHT('00000000' + CONVERT(VARCHAR, PV.recibo_correlativo_codigo), 8) AS NUM_RECIBO,
                              CP.Nombre_Cliente,
                              CP.Documento_Cliente,
                              C.cNumeroTelefono + CASE WHEN LEN(cSegundoNumeroTelefono) > 0 THEN ' - ' + cSegundoNumeroTelefono ELSE '' END AS TELEFONO_CLIENTE,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 103) + ' ' + SUBSTRING(CONVERT(VARCHAR, CP.FechaHora_Recepcion, 108), 1, 5) AS FechaHora_Recepcion,
                              CONVERT(VARCHAR, CP.FechaHora_Entrega, 103) + ' ' + SUBSTRING(CONVERT(VARCHAR, CP.FechaHora_Entrega, 108), 1, 5) AS FechaHora_Entrega,

                              (SELECT COUNT(_DP.Id)
                                 FROM _max_labperu_DetallePedido _DP
                                WHERE _DP.Id_Pedido = DP.Id_Pedido) AS TOTAL_MUESTRAS,
                              
                              DP.Cod_Interno,
                              DP.Nom_Muestra,
                              DP.Elemento_Analisis,
                              DP.Peso_Muestra,
                              EM.Nombre_EstadoMuestra,
                              DE.Nombre_DetalleEnvase,
                              TM.Nombre_TipoMuestra,
                              TA.Des_TipoAnalisis,
                              DP.Precio_Exceso,
                              DP.Precio_Final AS Total_Venta,
                              CASE WHEN CP.Incluir_IGV = 1 THEN 'SI' ELSE 'NO' END AS INC_IGV,
                              CP.usu_usuario,

                              COALESCE(DAR.Cod_EstadoResultadosCliente, 0) AS Cod_EstadoResultadosCliente,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 103) AS FechaHora_Recepcion2,
                              CONVERT(VARCHAR, DAR.Fecha_Registro, 103) AS FechaHora_Entrega2,
                              DAR.Ley_Au_gt,
                              DAR.Ley_Au_ot,
                              DAR.Ley_Ag_gt,
                              DAR.Ley_Ag_ot,
                              DAR.Porc_CU,
                              DAR.Porc_PB,
                              DAR.Porc_ZN,
                              DAR.Porc_AS,
                              DAR.Porc_SB,
                              DAR.Porc_S,
                              DAR.Porc_FE,
                              DAR.Porc_H2O,
                              CONVERT(VARCHAR, CIE.Fecha_Creacion, 103) AS Fecha_Informe,
                              DAR.Observacion_Reporte,
                              C.cEmail,
                              _CP.cNombreCliente AS NOMBRE_EMPRESA,
                              DP.Tipo_Muestra,
                              CONVERT(VARCHAR, DAR.Fecha_PreCierre, 103) AS Fecha_CierreInforme,
                              CP.Observacion AS Referencia_Cliente,
                              CONVERT(VARCHAR, COALESCE(DAR.Fecha_InicioEnsayo, CP.FechaHora_Recepcion), 20) AS Fecha_InicioEnsayo,
                              CONVERT(VARCHAR, COALESCE(DAR.Fecha_InicioEnsayo, CP.FechaHora_Recepcion), 103) AS Fecha_InicioEnsayo2,
                              CP.Mostrar_Contacto,
                              MP.des_mediopago
                         FROM _max_labperu_CabeceraPedido CP
                              INNER JOIN _max_labperu_PagoVenta PV ON CP.Id_Pedido = PV.Id_Pedido
                              INNER JOIN _max_labperu_Sucursales S ON CP.Sucursal = S.Id
                              INNER JOIN maestroCliente C ON CP.iIdCliente = C.iIdCliente
                              INNER JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                              LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
                                AND DP.Id = DAR.Id_Detalle_Pedido
                              LEFT JOIN _max_labperu_CorrelativoInformeEnsayos CIE ON DAR.Id_Pedido = CIE.Id_Pedido
                                AND DP.Id = CIE.Id_Detalle_Pedido
                              INNER JOIN _max_labperu_EstadosMuestra EM ON DP.Estado_Muestra = EM.Id
                              INNER JOIN _max_labperu_DetalleEnvase DE ON DP.Detalle_Envase = DE.Id
                              INNER JOIN _max_labperu_TiposMuestra TM ON DP.Tipo_Muestra = TM.Id
                              INNER JOIN _max_labperu_TipoAnalisis TA ON DP.Tipo_Analisis = TA.Id
                              INNER JOIN Cabecera_Pedido _CP ON CP.Id_Pedido = _CP.iId_Cabecera_Pedido
                              INNER JOIN _max_labperu_MedioPago MP ON PV.Id_MedioPago = MP.Id
                        WHERE CONVERT(VARCHAR, CP.FechaHora_Recepcion, 23) BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."'";

      if (strlen($dni_cliente) > 0){
        $q_resultados .= " AND CP.Documento_Cliente LIKE '%".trim($dni_cliente)."%'";
      }

      if (strlen($nom_cliente) > 0){
        $q_resultados .= " AND CP.Nombre_Cliente LIKE '%".trim($nom_cliente)."%'";
      }

      if (strlen($sucursal) > 0){
        $q_resultados .= " AND CP.Sucursal = ".$sucursal;
      }

      if (strlen($nom_muestra) > 0){
        $q_resultados .= " AND DP.Nom_Muestra LIKE '%".trim($nom_muestra)."%'";
      }

      $q_resultados .= " ORDER BY CP.FechaHora_Recepcion DESC, DP.Id DESC";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
        while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
          $estado = 1;

          array_push($r, $row_resultados);
        }
        
        echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Confirmar_Pago':
      // Recupera variables
        $id_pedido = $_POST["id_pedido"];
        $medio_pago = $_POST["medio_pago"];
        $observacion_pago = $_POST["observacion_pago"];

      // Obteniendo fecha
        date_default_timezone_set("America/Lima");

        $date = date('Y-m-d');
        $time = date('H:i:s');
        $fecha = ($date.' ' .$time);

        $q_updatefechapagado = "UPDATE _max_labperu_PagoVenta
                                   SET es_pagado = 1,
                                       fecha_pagado = '".$fecha."',
                                       Id_MedioPago_pagado = ".$medio_pago.",
                                       observacion_pagado = '".$observacion_pago."'
                                 WHERE Id_Pedido = ".$id_pedido;

        if ($res_updatefechapagado = sqlsrv_query($enlacehost, $q_updatefechapagado)) {
          $estado = 1;
        }
        else{
          $estado = 0;
        }

        echo json_encode(array('estado' => $estado));

      break;

    case 'Update_Cliente':
      // Recupera variables
        $id_cliente = $_POST["id_cliente"];
        $telefono_cliente = explode('/', $_POST["telefono_cliente"]);
        $mail_cliente = $_POST["mail_cliente"];

      // Graba datos
        $query = "UPDATE  maestroCliente SET
                          cNumeroTelefono = '".trim($telefono_cliente[0])."',
                          cSegundoNumeroTelefono = '".trim($telefono_cliente[1])."',
                          cEmail = '".$mail_cliente."'
                   WHERE  iIdCliente = ".$id_cliente;

      $estado = 0;

      if ($res = sqlsrv_query($enlacehost, $query)) {
        $estado = 1;
      }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Get_InformesAgrupados':
      $r = array();
      $estado = 0;

      $ci_in = $_POST["lista_CI"];
      $ci_in = str_replace(']-[', "','", $ci_in);
      $ci_in = str_replace('[', "'", $ci_in);
      $ci_in = str_replace(']', "'", $ci_in);

      $q_resultados = "SELECT 1 AS TIPO,
                              *,
                              COUNT(Id_Pedido) AS TOTAL_MUESTRAS,
                              '' AS COD_INTERNO,
                              '' AS Ley_Au_gt,
                              '' AS Ley_Au_ot,
                              '' AS Ley_Ag_gt,
                              '' AS Ley_Ag_ot,
                              '' AS Porc_CU,
                              '' AS Porc_PB,
                              '' AS Porc_ZN,
                              '' AS Porc_AS,
                              '' AS Porc_SB,
                              '' AS Porc_S,
                              '' AS Porc_FE,
                              '' AS Porc_H2O,
                              '' AS Observacion_Reporte
                         FROM (SELECT CP.Id_Pedido,
                                      CP.Sucursal,
                                      '' AS Cod_Interno,
                                      (SELECT TOP 1 Correlativo
                                         FROM _max_labperu_CorrelativoInformeEnsayos
                                        WHERE Id_Pedido = CP.Id_Pedido
                                        AND Id_Detalle_Pedido IN (SELECT Id
                                                      FROM _max_labperu_DetallePedido X
                                                       WHERE X.Id_Pedido = CP.Id_Pedido
                                                       AND X.Cod_Interno IN (".$ci_in."))
                                       ORDER BY Fecha_Creacion) AS CORRELATIVO,
                                      CONVERT(VARCHAR, CP.FechaHora_Recepcion, 103) + ' ' + SUBSTRING(CONVERT(VARCHAR, CP.FechaHora_Recepcion, 108), 1, 5) AS FechaHora_Recepcion,
                                      CONVERT(VARCHAR, CP.FechaHora_Entrega, 103) + ' ' + SUBSTRING(CONVERT(VARCHAR, CP.FechaHora_Entrega, 108), 1, 5) AS FechaHora_Entrega
                                 FROM _max_labperu_CabeceraPedido CP
                                      LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                                WHERE  CP.es_anulada = 0
                                  AND  DP.Elemento_Analisis NOT LIKE '%NEWMONT%'
                                  AND DP.Cod_Interno IN (".$ci_in.")) AS DATOS
                       GROUP BY Id_Pedido, Sucursal, Cod_Interno, CORRELATIVO, FechaHora_Recepcion, FechaHora_Entrega
                       ORDER BY FechaHora_Recepcion";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
          while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
            array_push($r, $row_resultados);

            $Id_Pedido = $row_resultados["Id_Pedido"];
            $sucursal = $row_resultados["Sucursal"];
            $cod_interno = $row_resultados["Cod_Interno"];
            $correlativo = $row_resultados["CORRELATIVO"];
            $FechaHora_Recepcion = $row_resultados["FechaHora_Recepcion"];
            $FechaHora_Entrega = $row_resultados["FechaHora_Entrega"];
            $total_muestras = $row_resultados["TOTAL_MUESTRAS"];

            // Obteniendo detalles
              $q_detalle = "SELECT  2 AS TIPO,

                                    '".$Id_Pedido."' AS Id_Pedido,
                                    '".$sucursal."' AS Sucursal,
                                    DP.Cod_Interno,
                                    '".$correlativo."' AS CORRELATIVO,
                                    '".$FechaHora_Recepcion."' AS FechaHora_Recepcion,
                                    '".$FechaHora_Entrega."' AS FechaHora_Entrega,
                                    '".$total_muestras."' AS TOTAL_MUESTRAS,

                                    DAR.Ley_Au_gt,
                                    DAR.Ley_Au_ot,
                                    DAR.Ley_Ag_gt,
                                    DAR.Ley_Ag_ot,
                                    DAR.Porc_CU,
                                    DAR.Porc_PB,
                                    DAR.Porc_ZN,
                                    DAR.Porc_AS,
                                    DAR.Porc_SB,
                                    DAR.Porc_S,
                                    DAR.Porc_FE,
                                    DAR.Porc_H2O,

                                    DAR.Observacion_Reporte
                              FROM  _max_labperu_CabeceraPedido CP
                                    LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                                    LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
                                    AND DP.Id = DAR.Id_Detalle_Pedido
                              WHERE  CP.es_anulada = 0
                                AND  DP.Elemento_Analisis NOT LIKE '%NEWMONT%'
                                AND  CP.Id_Pedido = ".$Id_Pedido."
                                AND  DP.Cod_Interno IN (".$ci_in.")";

              // $q_detalle = "SELECT  2 AS TIPO,

              //                       '".$Id_Pedido."' AS Id_Pedido,
              //                       '".$sucursal."' AS Sucursal,
              //                       DP.Cod_Interno,
              //                       '".$correlativo."' AS CORRELATIVO,
              //                       '".$FechaHora_Recepcion."' AS FechaHora_Recepcion,
              //                       '".$FechaHora_Entrega."' AS FechaHora_Entrega,
              //                       '".$total_muestras."' AS TOTAL_MUESTRAS,

              //                       CASE WHEN DAR.Ley_Au_gt = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Ley_Au_gt) END AS Ley_Au_gt,
              //                       DAR.Ley_Au_ot,
              //                       CASE WHEN DAR.Ley_Ag_gt = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Ley_Ag_gt) END AS Ley_Ag_gt,
              //                       DAR.Ley_Ag_ot,
              //                       CASE WHEN DAR.Porc_CU = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_CU) END AS Porc_CU,
              //                       CASE WHEN DAR.Porc_PB = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_PB) END AS Porc_PB,
              //                       CASE WHEN DAR.Porc_ZN = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_ZN) END AS Porc_ZN,
              //                       CASE WHEN DAR.Porc_AS = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_AS) END AS Porc_AS,
              //                       CASE WHEN DAR.Porc_SB = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_SB) END AS Porc_SB,
              //                       CASE WHEN DAR.Porc_S = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_S) END AS Porc_S,
              //                       CASE WHEN DAR.Porc_FE = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_FE) END AS Porc_FE,
              //                       CASE WHEN DAR.Porc_H2O = 99999.99999 THEN '-' ELSE CONVERT(VARCHAR, DAR.Porc_H2O) END AS Porc_H2O,
              //                       DAR.Observacion_Reporte
              //                 FROM  _max_labperu_CabeceraPedido CP
              //                       LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
              //                       LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
              //                       AND DP.Id = DAR.Id_Detalle_Pedido
              //                 WHERE  CP.es_anulada = 0
              //                   AND  DP.Elemento_Analisis NOT LIKE '%NEWMONT%'
              //                   AND  CP.Id_Pedido = ".$Id_Pedido."
              //                   AND  DP.Cod_Interno IN (".$ci_in.")";

              if ($res_detalle = sqlsrv_query($enlacehost, $q_detalle)) {
                while($row_detalle = sqlsrv_fetch_array($res_detalle)) {
                  array_push($r, $row_detalle);
                }
              }

            $estado = 1;
          }

          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Generate_QR_Agrupado':
      $r = array();
      $estado = 0;

      // Recupera variables para tabla de pedido en BD Omar
        $url = $_POST["url"];
        $id_pedido = $_POST["Id_Pedido"];

        $ci_in = $_POST["CI"];
        $ci_in = str_replace(']-[', "','", $ci_in);
        $ci_in = str_replace('[', "'", $ci_in);
        $ci_in = str_replace(']', "'", $ci_in);

        $num_informe = $_POST["Num_Informe"];

      // Recuperando el listado de muestras agrupadas
        $q_muestras = " SELECT  DP.Cod_Interno
                          FROM  _max_labperu_CabeceraPedido CP
                                LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                         WHERE  CP.es_anulada = 0
                           AND  CP.Id_Pedido = ".$id_pedido."
                           AND  DP.Cod_Interno IN (".$ci_in.")
                        ORDER BY FechaHora_Recepcion";

        if ($res_muestras = sqlsrv_query($enlacehost, $q_muestras)) {
          while($row_muestras = sqlsrv_fetch_array($res_muestras)) {
            $estado = 1;

            array_push($r, $row_muestras);
          }
        }

      // Generando Código QR
        $dir = '../tmp_files/';
        $file_name = $dir.'tmp_qr_'.str_replace(' ', '', $num_informe).'.png';

        if (!file_exists($dir)){
          mkdir($dir);
        }

        QRcode::png($url, $file_name, 'H', 3, 3);

      echo json_encode(array('estado' => $estado, 'registros' => $r));

      break;

    case 'CambiarEstado_Cliente':
      $id_cliente = $_POST["id_cliente"];
      $estado = $_POST["estado"];

      $query = "UPDATE  maestroCliente SET
                        cEstado_Eliminado = '".$estado."'
                 WHERE  iIdCliente = ".$id_cliente;

      $estado = 0;

      if ($res = sqlsrv_query($enlacehost, $query)) {
        $estado = 1;
      }

      echo json_encode(array('estado' => $estado));

      break;

    case 'Eliminar_Cliente':
      $id_cliente = $_POST["id_cliente"];

      $query = "DELETE  maestroCliente
                 WHERE  iIdCliente = ".$id_cliente;

      $estado = 0;

      if ($res = sqlsrv_query($enlacehost, $query)) {
        $estado = 1;
      }

      echo json_encode(array('estado' => $estado));

      break;

    case 'UpdateClave_Cliente':
      $id_cliente = $_POST["id_cliente"];
      $password = f_RandomKey(6);

      $estado = 0;
      $exists = 0;

      // Verificar el usuario, si no existe lo crea y si existe actualiza la clave
        $q_exists = "SELECT COUNT(Id) AS _EXISTS
                       FROM tb_usuario_clientes
                      WHERE iIdCliente = ".$id_cliente;

        if ($res_exists = mysqli_query($enlace, $q_exists)) {
          if (mysqli_num_rows($res_exists) > 0) {
            while($row_exists = mysqli_fetch_assoc($res_exists)) {
              if ($row_exists["_EXISTS"] == 0){
                // Obtiene datos de cliente
                  $q_cliente = "SELECT  maestroCliente.cNumeroRuc,
                                        maestroCliente.cRazonSocial
                                   FROM maestroCliente
                                  WHERE iIdCliente = ".$id_cliente;

                  if ($res_cliente = sqlsrv_query($enlacehost, $q_cliente)) {
                    while($row_cliente = sqlsrv_fetch_array($res_cliente)) {
                      $ruc = $row_cliente["cNumeroRuc"];
                      $razon_social = $row_cliente["cRazonSocial"];

                      $q_insert = "INSERT INTO tb_usuario_clientes (iIdCliente, Numero_RUC, Razon_Social, Clave) VALUES (";
                      $q_insert .= $id_cliente.", ";
                      $q_insert .= "'".$ruc."', ";
                      $q_insert .= "'".$razon_social."', ";
                      $q_insert .= "MD5('".$password."'))";

                      if ($res_insert = mysqli_query($enlace, $q_insert)) {
                        $estado = $password;
                      }
                      else{
                        $estado = 0;
                      }
                    }
                  }
              }
              else{
                // Actualizar clave
                  $query = "UPDATE  tb_usuario_clientes SET
                                    Clave = MD5('".$password."')
                             WHERE  iIdCliente = ".$id_cliente;

                  if ($res = mysqli_query($enlace, $query)) {
                    $estado = $password;
                  }
              }
            }
          }
        }

        echo json_encode(array('estado' => $estado));

      break;

    case 'Get_AnalisisResultados_Cliente':
      $r = array();
      $estado = 0;

      $fecha_inicio = $_POST["fecha_inicio"];
      $fecha_fin = $_POST["fecha_fin"];
      $id_rack = $_POST["id_rack"];
      $id_fundidor = $_POST["id_fundidor"];
      $id_cliente = $_POST["cliente"];
      $agrupados = $_POST["agrupados"];
      $inicio = $_POST["inicio"];

      $q_resultados = "SELECT ".(($inicio == 1) ? 'TOP 20' : '')." CP.Id_Pedido,
                              DP.Id AS Id_Detalle,
                              DP.Elemento_Analisis,
                              DP.Nom_Muestra,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 20) AS FechaHora_Recepcion,
                              CONVERT(VARCHAR, CP.FechaHora_Entrega, 20) AS FechaHora_Entrega,
                              DP.Cod_Interno,
                              DP.Observacion,
                              DAR.Ley_Au_gt,
                              DAR.Ley_Au_ot,
                              DAR.Ley_Ag_gt,
                              DAR.Ley_Ag_ot,
                              DAR.Porc_CU,
                              DAR.Porc_PB,
                              DAR.Porc_ZN,
                              DAR.Porc_AS,
                              DAR.Porc_SB,
                              DAR.Porc_S,
                              DAR.Porc_FE,
                              DAR.Porc_H2O,
                              COALESCE(DAR.Cod_EstadoResultadosCliente, 0) AS Cod_EstadoResultadosCliente,
                              DAR.Fecha_PreCierre,
                              DAR.Fecha_CierreFinal,
                              DAR.Fecha_Registro,
                              DAR.Observacion_Reporte,
                              MC.cRazonSocial,
                              TM.Nombre_TipoMuestra,
                              DP.Peso_Muestra,
                              DE.Nombre_DetalleEnvase,
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 103) AS FechaHora_Recepcion2,
                              CONVERT(VARCHAR, DAR.Fecha_Registro, 103) AS FechaHora_Entrega2,
                              CONVERT(VARCHAR, CIE.Fecha_Creacion, 103) AS Fecha_Informe,
                              CP.Sucursal,
                              S.des_sucursal,
                              CP.Documento_Cliente,
                              MC.cNumeroTelefono + CASE WHEN LEN(cSegundoNumeroTelefono) > 0 THEN ' - ' + cSegundoNumeroTelefono ELSE '' END AS TELEFONO_CLIENTE,
                              MC.cEmail,
                              _CP.cNombreCliente AS NOMBRE_EMPRESA,
                              DP.Tipo_Muestra,
                              TA.Des_TipoAnalisis,
                              CONVERT(VARCHAR, DAR.Fecha_PreCierre, 103) AS Fecha_CierreInforme,
                              CP.Observacion AS Referencia_Cliente,
                              CONVERT(VARCHAR, COALESCE(DAR.Fecha_InicioEnsayo, CP.FechaHora_Recepcion), 20) AS Fecha_InicioEnsayo,
                              CONVERT(VARCHAR, COALESCE(DAR.Fecha_InicioEnsayo, CP.FechaHora_Recepcion), 103) AS Fecha_InicioEnsayo2,
                              CP.Mostrar_Contacto
                        FROM  _max_labperu_CabeceraPedido CP
                              LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                              LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
                                AND DP.Id = DAR.Id_Detalle_Pedido
                              INNER JOIN _max_labperu_PagoVenta PV ON CP.Id_Pedido = PV.Id_Pedido
                              INNER JOIN maestroCliente MC ON CP.iIdCliente = MC.iIdCliente
                              INNER JOIN _max_labperu_TiposMuestra TM ON DP.Tipo_Muestra = TM.Id
                              INNER JOIN _max_labperu_DetalleEnvase DE ON DP.Detalle_Envase = DE.Id
                              LEFT JOIN _max_labperu_CorrelativoInformeEnsayos CIE ON DAR.Id_Pedido = CIE.Id_Pedido
                                AND DAR.Id_Detalle_Pedido = CIE.Id_Detalle_Pedido
                              INNER JOIN _max_labperu_Sucursales S ON CP.Sucursal = S.Id
                              INNER JOIN Cabecera_Pedido _CP ON CP.Id_Pedido = _CP.iId_Cabecera_Pedido
                              INNER JOIN _max_labperu_TipoAnalisis TA ON DP.Tipo_Analisis = TA.Id
                       WHERE  CP.es_anulada = 0
                         AND  DP.Elemento_Analisis NOT LIKE '%NEWMONT%'
                         AND  DP.Elemento_Analisis NOT LIKE '%CARBON%'
                         AND  DP.Elemento_Analisis NOT LIKE '%METALURGICA%'";

      if ($inicio == 0){
        $q_resultados .= " AND  CONVERT(VARCHAR, CP.FechaHora_Recepcion, 23) BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."'";
      }
                         

      if (strlen($id_cliente) > 0){
        $q_resultados .= " AND CP.Documento_Cliente = '".$id_cliente."'";
        // $q_resultados .= " AND DAR.Cod_EstadoResultadosCliente != 0";
      }

      if ($agrupados == 1){
        $q_resultados .= " AND DAR.Cod_EstadoResultadosCliente = 2";
      }

      $q_resultados .= " ORDER BY CP.FechaHora_Recepcion DESC, DP.Id DESC ";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
          while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
            $estado = 1;

            // Comprobando si los análisis existen en la tabla de Resultados de Análisis
              $id_pedido = $row_resultados["Id_Pedido"];
              $id_detalle = $row_resultados["Id_Detalle"];

              $q_exists = "SELECT COUNT(Id) AS _EXISTS
                             FROM _max_labperu_DetalleAnalisisResultados
                            WHERE Id_Pedido = ".$id_pedido."
                              AND Id_Detalle_Pedido = ".$id_detalle;

              if ($res_exists = sqlsrv_query($enlacehost, $q_exists)) {
                while($row_exists = sqlsrv_fetch_array($res_exists)) {
                  $q_exists = $row_exists["_EXISTS"];
                }
              }

              // Si no tiene registros se deben insertar
                if ($q_exists == 0){
                  $q_insert = "INSERT INTO _max_labperu_DetalleAnalisisResultados (Id_Pedido, Id_Detalle_Pedido, bPeso_MuestraFundicion,
                                                                                   bPeso_RegulosFundicion, bPeso_DoreMicro, bPeso_OroMicro,
                                                                                   nPeso_MuestraFundicion, nPeso_RegulosFundicion, nPeso_DoreMicro,
                                                                                   nPeso_OroMicro) VALUES(";

                  $q_insert .= $row_resultados["Id_Pedido"].", ".$row_resultados["Id_Detalle"].", 1,
                               1, 1, 1,
                               0.00, 0.00, 0.00,
                               0.00)";

                  if ($res = sqlsrv_query($enlacehost, $q_insert)) {
                  }
                }

            array_push($r, $row_resultados);
          }
          
          echo json_encode(array('estado' => $estado, 'registros' => $r));
      }

      break;

    case 'Get_AnalisisResultados_Cliente_App':
      $r = array();
      $estado = 0;

      $fecha_inicio = $_POST["fecha_inicio"];
      $fecha_fin = $_POST["fecha_fin"];
      $id_cliente = $_POST["cliente"];
      $inicio = $_POST["inicio"];

      $q_resultados = "SELECT ".(($inicio == 1) ? 'TOP 20' : '')." CONVERT(VARCHAR, CP.FechaHora_Recepcion, 103) + ' ' +
                              CONVERT(VARCHAR, CP.FechaHora_Recepcion, 108) AS FechaHora_Recepcion,
                              DP.Nom_Muestra,
                              DP.Elemento_Analisis,
                              DP.Peso_Muestra,
                              (ISNULL(Ley_Au_gt, 0) +
                               ISNULL(Ley_Au_ot, 0) +
                               ISNULL(Ley_Ag_gt, 0) +
                               ISNULL(Ley_Ag_ot, 0) +
                               ISNULL(Porc_CU, 0) +
                               ISNULL(Porc_PB, 0) +
                               ISNULL(Porc_ZN, 0) +
                               ISNULL(Porc_AS, 0) +
                               ISNULL(Porc_SB, 0) +
                               ISNULL(Porc_S, 0) +
                               ISNULL(Porc_FE, 0) +
                               ISNULL(Porc_H2O, 0)) AS TIENE_RESULTADOS,
                               DAR.Ley_Au_gt,
                               DAR.Ley_Au_ot,
                               DAR.Ley_Ag_gt,
                               DAR.Ley_Ag_ot,
                               DAR.Porc_CU,
                               DAR.Porc_PB,
                               DAR.Porc_ZN,
                               DAR.Porc_AS,
                               DAR.Porc_SB,
                               DAR.Porc_S,
                               DAR.Porc_FE,
                               DAR.Porc_H2O,
                               DAR.Observacion_Reporte,
                               COALESCE(DAR.Cod_EstadoResultadosCliente, 0) AS Cod_EstadoResultadosCliente,
                               DAR.Fecha_PreCierre
                        FROM  _max_labperu_CabeceraPedido CP
                              LEFT JOIN _max_labperu_DetallePedido DP ON CP.Id_Pedido = DP.Id_Pedido
                              LEFT JOIN _max_labperu_DetalleAnalisisResultados DAR ON DP.Id_Pedido = DAR.Id_Pedido
                                AND DP.Id = DAR.Id_Detalle_Pedido
                              LEFT JOIN _max_labperu_CorrelativoInformeEnsayos CIE ON DAR.Id_Pedido = CIE.Id_Pedido
                                AND DAR.Id_Detalle_Pedido = CIE.Id_Detalle_Pedido
                              INNER JOIN maestroCliente MC ON CP.iIdCliente = MC.iIdCliente
                       WHERE  CP.es_anulada = 0
                         AND  DP.Elemento_Analisis NOT LIKE '%NEWMONT%'
                         AND  DP.Elemento_Analisis NOT LIKE '%CARBON%'
                         AND  DP.Elemento_Analisis NOT LIKE '%METALURGICA%'
                         AND  CP.Documento_Cliente = '".$id_cliente."'";

      if ($inicio == 0){
        $q_resultados .= " AND  CONVERT(VARCHAR, CP.FechaHora_Recepcion, 23) BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."'";
      }

      $q_resultados .= " ORDER BY CP.FechaHora_Recepcion DESC, DP.Id DESC ";

      if ($res_resultados = sqlsrv_query($enlacehost, $q_resultados)) {
        while($row_resultados = sqlsrv_fetch_array($res_resultados)) {
          $estado = 1;

          array_push($r, $row_resultados);
        }
      }

      echo json_encode(array('estado' => $estado, 'registros' => $r));

      break;

    case 'Get_ClienteSunat':
      $ruc = $_POST["ruc"];
      $url = "http://ventas.mbsoftperu.com/App/api/ConsultaRuc/".trim($ruc);

      $curl = curl_init();

      curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET"
      ));

      $response = curl_exec($curl);

      curl_close($curl);

      echo $response;

      break;

    case 'Anular_Comprobante':
      // Recupera parámetros
        $idCompany = $_POST["idCompany"];
        $idTienda = $_POST["idTienda"];
        $idTerminal = $_POST["idTerminal"];
        $idUsuario = $_POST["idUsuario"];

        $IdPedido = $_POST["IdPedido"];
        $motivo = $_POST["motivo"];
        $usuario = $_POST["usu_usuario"];

      // Obteniendo el Id de la tabla: "Cabecera_Venta"
        $q_IdCabecera = "SELECT  iId_Cabecera_Venta
                           FROM  Cabecera_Venta
                          WHERE  iId_Cabecera_Pedido = ".$IdPedido;

        if ($res_IdCabecera = sqlsrv_query($enlacehost, $q_IdCabecera)) {
          while($row_IdCabecera = sqlsrv_fetch_array($res_IdCabecera)) {
            $Id_dCabecera = $row_IdCabecera["iId_Cabecera_Venta"];
          }
        }

      // Guarda Cabecera
        $query = "EXEC sp_generar_anulacion ";
        $query .= $idCompany.", ";
        $query .= $idTienda.", ";
        $query .= $idTerminal.", ";
        $query .= $idUsuario.", ";
        $query .= $Id_dCabecera.", ";
        $query .= "'".$motivo."', 0, '', 0, '', '', 0, '', '', 0";

        $estado = 0;

        if ($res = sqlsrv_query($enlacehost, $query)) {
        // if (1 == 1) {
          $estado = 1;

          // Obteniendo Fecha y Hora del sistema
            date_default_timezone_set("America/Lima"); 

            $date = date('Y-m-d');
            $time = date('H:i:s');

          // Guardando anulación
            $q_insert = "INSERT INTO _max_labperu_ComprobantesVenta_Anulados(Id_Pedido, Id_Comprobante, Serie_Comprobante, Correlativo_Comprobante,
                                                                             Fecha_Generacion, motivo_anulacion, usuario_anulacion, fecha_anulacion) ";
            $q_insert .= "SELECT  Id_Pedido, Id_Comprobante, Serie_Comprobante, Correlativo_Comprobante, Fecha_Generacion, ";
            $q_insert .= "        '".trim($motivo)."', '".$usuario."', '".($date.' '.$time)."' ";
            $q_insert .= "  FROM  _max_labperu_ComprobantesVenta";
            $q_insert .= " WHERE  Id_Pedido = ".$IdPedido;

            if ($res = sqlsrv_query($enlacehost, $q_insert)) {
              // Eliminando registro de la tabla de Comprobantes
                $q_anular = "DELETE FROM _max_labperu_ComprobantesVenta
                              WHERE Id_Pedido = ".$IdPedido;

                if ($res = sqlsrv_query($enlacehost, $q_anular)) {
                }
            }

          // Revirtiendo registros
            // // 1. Eliminando datos de la tabla de Cabecera de Venta
            //   $q_delete1 = "DELETE FROM Cabecera_Venta
            //                 WHERE iId_Cabecera_Venta = ".$Id_dCabecera;

            //   if ($res_delete1 = sqlsrv_query($enlacehost, $q_delete1)) {
            //   }

            // // 2. Eliminando datos de la tabla de Detalle de Venta
            //   $q_delete2 = "DELETE FROM Detalle_Venta
            //                 WHERE iIdCabecera_Venta = ".$Id_dCabecera;

            //   if ($res_delete2 = sqlsrv_query($enlacehost, $q_delete2)) {
            //   }

            // 3. Eliminando el exceso de la tabla de Detalle Pedido
              $q_delete3 = "DELETE FROM Detalle_Pedido
                            WHERE iId_Cabecera_Pedido = ".$IdPedido."
                              AND iIdProducto = 99999";

              if ($res_delete3 = sqlsrv_query($enlacehost, $q_delete3)) {
              }

            // 4. Si la venta incluye IGV, se deben restaurar los precios en la tabla de Detalle Pedido
              $q_igv = "SELECT  Incluir_IGV
                          FROM  _max_labperu_CabeceraPedido
                         WHERE  Id_Pedido = ".$IdPedido;

              if ($res_igv = sqlsrv_query($enlacehost, $q_igv)) {
                while($row_igv = sqlsrv_fetch_array($res_igv)) {
                  $is_igv = $row_igv["Incluir_IGV"];
                }
              }

              if ($is_igv == 1){
                $q_update = "UPDATE Detalle_Pedido
                                SET dPrecioUnidad = (dPrecioUnidad / 1.18),
                                    dPrecioVentaFinal = (dPrecioVentaFinal / 1.18)
                              WHERE iId_Cabecera_Pedido = ".$IdPedido;

                if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
                }
              }

            // 5. Regresa el nombre de los productos
              $q_update = "UPDATE Detalle_Pedido
                               SET cProductName = (CASE WHEN CHARINDEX(':', cProductName) > 0 THEN SUBSTRING(cProductName, 1, CHARINDEX(':', cProductName) - 1) ELSE cProductName END)
                             WHERE iId_Cabecera_Pedido = ".$IdPedido;

              if ($res_update = sqlsrv_query($enlacehost, $q_update)) {
              }
        }
        else{
          $estado = 0;
        }

      echo json_encode(array('estado' => $estado));

      break;

    default:

      # code...

      break;

  }

?>