<?php
  
  session_start();

  include('../../php/conn.php');

  if(!isset($_SESSION["id"])){
    header('Location: index.php');
  }

  mysqli_query($enlace, "SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
  mysqli_query($enlacehost, "SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");

?>

<!DOCTYPE html>
<html lang="es">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	    <!-- Meta, title, CSS, favicons, etc. -->
	    <meta charset="utf-8">
	    <meta http-equiv="X-UA-Compatible" content="IE=edge">
	    <meta name="viewport" content="width=device-width, initial-scale=1">

	    <title>Atención de Pedidos</title>

	    <!-- Bootstrap -->
	    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
	    <!-- Font Awesome -->
	    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
	    <!-- NProgress -->
	    <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
	    <!-- iCheck -->
	    <link href="../vendors/iCheck/skins/flat/green.css" rel="stylesheet">
	    <!-- bootstrap-progressbar -->
	    <link href="../vendors/bootstrap-progressbar/css/bootstrap-progressbar-3.3.4.min.css" rel="stylesheet">
	    <!-- JQVMap -->
	    <link href="../vendors/jqvmap/dist/jqvmap.min.css" rel="stylesheet"/>
	    <!-- bootstrap-daterangepicker -->
	    <link href="../vendors/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">
	    <!-- Ion.RangeSlider -->
	    <link href="../vendors/normalize-css/normalize.css" rel="stylesheet">
	    <link href="../vendors/ion.rangeSlider/css/ion.rangeSlider.css" rel="stylesheet">
	    <link href="../vendors/ion.rangeSlider/css/ion.rangeSlider.skinFlat.css" rel="stylesheet">
	    <!-- Bootstrap Colorpicker -->
	    <link href="../vendors/mjolnic-bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css" rel="stylesheet">
	    <link href="../vendors/cropper/dist/cropper.min.css" rel="stylesheet">
	    <!-- Datatables -->
	    <link href="../vendors/datatables.net-bs/css/dataTables.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css" rel="stylesheet">

	    <!-- bootstrap-datetimepicker -->
    	<link href="../vendors/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.css" rel="stylesheet">

    	<!-- Switchery -->
    	<link href="../vendors/switchery/dist/switchery.min.css" rel="stylesheet">

        <!-- Toggle Switch -->
        <link rel="stylesheet" type="text/css" href="bootstrap/css/bootstrap4-toggle.min.css">

	    <!-- Custom Theme Style -->
    	<link href="../build/css/custom.min.css" rel="stylesheet">

        <script type="text/javascript">
            var total = 0;
        </script>
	</head>

	<body class="nav-md" onload="f_LoadResultados()" style="zoom: 80%">
		<div class="container body">
      		<div class="main_container">
      			<?php include('partes/sidebar.php'); ?>

      			<!-- page content -->
        		<div class="right_col" role="main">
        			<div class="">
        				<div class="row">
        					<div class="col-md-12 col-sm-12 col-xs-12">
        						<div class="x_panel">
        							<div class="x_title">
        								<h2>
        									Atención de Pedidos
        								</h2>
        								<div class="clearfix">
        								</div>
        							</div>

        							<div class="x_content">
        								<!-- Filtros -->
        								<div class="col-md-4 col-sm-4 col-xs-12">
	        								<div class="x_panel">
												<div class="x_title">
													<h2>
														<font style="font-size: 14px"><b>Búsqueda por rango de fechas</b></font>
													</h2>
													<div class="clearfix">
													</div>
												</div>
												<div class="x_content">
													<div class="form-group col-md-6 col-sm-6 col-xs-12" style="margin-top: 9px;">
                                                        <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-top: 6px; margin-left: -20px">
                                                            Desde
                                                        </label>
                                                        <div class="col-md-10 col-sm-10 col-xs-12" style="margin-left: 20px">
                                                            <?php
	                                                            date_default_timezone_set("America/Lima"); 
	                                            				$time = date('Y-m-d');

                                                                echo '<input type="date" class="form-control col-md-12 col-xs-12" id="fecha_inicio" value="'.$time.'"/>';
                                                            ?>
                                                        </div>
                                                    </div>

                                                    <div class="form-group col-md-6 col-sm-6 col-xs-12" style="margin-top: 9px;">
                                                        <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-top: 6px; margin-left: -20px">
                                                            Hasta
                                                        </label>
                                                        <div class="col-md-10 col-sm-10 col-xs-12" style="margin-left: 20px">
                                                            <?php
                                                                echo '<input type="date" class="form-control col-md-12 col-xs-12" id="fecha_fin" value="'.$time.'"/>';
                                                            ?>
                                                        </div>
                                                    </div>
												</div>
											</div>
										</div>

										<div class="col-md-4 col-sm-4 col-xs-12">
											<div class="x_panel">
												<div class="x_title">
													<h2>
														<font style="font-size: 14px"><b>Búsqueda por Clientes</b></font>
													</h2>
													<div class="clearfix">
													</div>
												</div>
												<div class="x_content">
													<div class="row" style="margin-top: 8px">
														<div class="form-group col-md-5 col-sm-5 col-xs-12" style="text-align: right;">
	                                                        <div class="col-md-12 col-sm-12 col-xs-12">
	                                                            <input type="number" id="dni_cliente" placeholder="DNI / RUC de Cliente" class="form-control col-md-12 col-xs-12" onkeyup="f_BuscarClientes(1)">
	                                                        </div>
	                                                    </div>

	                                                    <div class="form-group col-md-7 col-sm-7 col-xs-12" style="text-align: left;">
	                                                        <div class="col-md-12 col-sm-12 col-xs-12">
	                                                            <input type="text" id="nom_cliente" placeholder="Nombre de Cliente" class="form-control col-md-12 col-xs-12" onkeyup="f_BuscarClientes(2)">
	                                                        </div>
	                                                    </div>
	                                                </div>

                                                    <div class="row" id="div_buscarclientes" style="display: none;">
                                                        <div class="row" style="background-color: #9CB6D9; height: 30px; border: solid; border-width: 1px; border-color: #829BCD; border-radius: 7px; text-align: center;">
                                                            <label style="margin-top: -5px"><h2><b><font color="#ffffff" style="font-size: 15px">
                                                                Búsqueda de Clientes
                                                            </font></b></h2></label>
                                                        </div>

                                                        <div class="row" id="div_sinclientes" style="border: solid; border-width: 1px; border-color: #D9D9D9; background-color: #F22727; color: #ffffff"><center>
                                                            No se encontraron resultados
                                                        </center></div>

                                                        <div class="row" style="overflow: auto; height: 150px">
                                                            <table class="table table-striped jambo_table bulk_action">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="width: 2%"><center>
                                                                            Item
                                                                        </center></th>
                                                                        <th style="width: 18%"><center>
                                                                            DNI / RUC Cliente
                                                                        </center></th>
                                                                        <th style="width: 80%"><center>
                                                                            Nombre Cliente
                                                                        </center></th>
                                                                    </tr>
                                                                </thead>

                                                                <tbody id="tabla_busquedaclientes">
                                                                    
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
												</div>
											</div>
										</div>

                                        <div class="col-md-2 col-sm-2 col-xs-12">
                                            <div class="x_panel">
                                                <div class="x_title">
                                                    <h2>
                                                        <font style="font-size: 14px"><b>Búsqueda por Medio de Pago</b></font>
                                                    </h2>
                                                    <div class="clearfix">
                                                    </div>
                                                </div>

                                                <div class="x_content">
                                                    <div class="row" style="margin-top: 8px">
                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                                <select id="lista_mediopago" class="form-control col-md-12 col-sm-12 col-xs-12" style="margin-top: 2px; text-align: left;" onchange="f_ShowEfectivo()" required>
                                                                    <option selected value="">Elija una opción...</option>

                                                                    <?php
                                                                        $c = 1;

                                                                        $q_mediopago = "SELECT Id,
                                                                                               des_mediopago,
                                                                                               efectivo_mediopago
                                                                                          FROM _max_labperu_MedioPago
                                                                                         WHERE estado_mediopago = 'A'";

                                                                        if ($res_mediopago = sqlsrv_query($enlacehost, $q_mediopago)) {
                                                                            while($row_mediopago = sqlsrv_fetch_array($res_mediopago)) {
                                                                                echo '<option value="'.$row_mediopago["Id"].'">'.$row_mediopago["des_mediopago"].'</option>';

                                                                                 $c += 1;
                                                                            }
                                                                        }
                                                                    ?>

                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-2 col-sm-2 col-xs-12">
                                            <div class="x_panel">
                                                <div class="x_title">
                                                    <h2>
                                                        <font style="font-size: 14px"><b>Búsqueda por N° de Recibo</b></font>
                                                    </h2>

                                                    <div class="clearfix">
                                                    </div>
                                                </div>

                                                <div class="x_content">
                                                    <div class="row" style="margin-top: 8px">
                                                        <div class="col-md-7 col-sm-7 col-xs-7">
                                                            <input id="_Switch" type="checkbox" checked data-toggle="toggle" data-on="Recibo" data-off="Comprobante" data-onstyle="primary" data-offstyle="warning" data-width="110">
                                                        </div>
                                                        <div class="col-md-5 col-sm-5 col-xs-5">
                                                            <input type="text" id="num_recibo" placeholder="Número" class="form-control col-md-12 col-xs-12">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

										<div class="col-md-10 col-sm-10 col-xs-10">
											<button class="btn btn-success" type="button" onclick="f_LoadResultados()" style="width: 100%; background-color: #26B99A">
                                                 <b>Ejecutar Búsqueda</b>
                                            </button>
										</div>

                                        <div class="col-md-2 col-sm-2 col-xs-2">
                                            <button class="btn btn-success" type="button" onclick="f_ClearBusqueda()" style="width: 100%; background-color: #3D3D3D">
                                                 <b>Limpiar Búsqueda</b>
                                            </button>
                                        </div>

                                        <div class="col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px">
                                            <div class="x_panel" style="border: solid; border-width: 1px; border-color: #D9D9D9; border-radius: 7px;">
                                                <div class="x_title">
                                                    <div class="col-md-6 col-sm-6 col-xs-6">
                                                        <h2>
                                                            Lista de Resultados
                                                        </h2>
                                                    </div>

                                                    <div class="col-md-6 col-sm-6 col-xs-6" style="text-align: right;">
                                                        <button class="btn btn-success" type="button" onclick="f_ExportToExcel()" style="background-color: #26B99A">
                                                             <b>Descargar a Excel</b>
                                                        </button>
                                                    </div>

                                                    <div class="clearfix">
                                                    </div>
                                                </div>

                                                <div class="x_content">
                                                    <table class="table table-striped jambo_table bulk_action">
                                                        <thead>
                                                            <tr>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Item
                                                                </center></th>
                                                                <th rowspan="2" style="width: 12%; border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #A63D33"><center>
                                                                    Acción
                                                                </center></th>
                                                                <th rowspan="2" style=" border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Oficina
                                                                </center></th>
                                                                <th colspan="2" style=" border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Comprobantes
                                                                </center></th>
                                                                <!-- <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    N° Comprobante
                                                                </center></th> -->
                                                                <th colspan="2" style="border: solid; border-width: 1px; border-color: #ffffff;"><center>
                                                                    Cliente Venta
                                                                </center></th>
                                                                <th colspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; background-color: #6A84A6"><center>
                                                                    Cliente Comprobante
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #F5A300"><center>
                                                                    Medio Pago
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Fecha Recepción
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #167369"><center>
                                                                    Total Venta
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #0577A6"><center>
                                                                    Inc. IGV
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #734432"><center>
                                                                    Estado Pago
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Fecha Pago
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #518C86"><center>
                                                                    Usuario Vendedor
                                                                </center></th>
                                                                <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #F25050"><center>
                                                                    Usuario Anulador (Venta)
                                                                </center></th>
                                                            </tr>

                                                            <tr>
                                                                <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Recibo
                                                                </center></th>
                                                                <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Electrónico
                                                                </center></th>
                                                                <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                    Cliente
                                                                </center></th>
                                                                <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                     DNI / RUC
                                                                </center></th>
                                                                <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #C2E0F2; color: #595959"><center>
                                                                    Cliente
                                                                </center></th>
                                                                <th style="border: solid; border-width: 1px; border-color: #ffffff; background-color: #C2E0F2; vertical-align: middle; color: #595959"><center>
                                                                     DNI / RUC
                                                                </center></th>
                                                            </tr>
                                                        </thead>

                                                        <tbody id="tabla_ventasresultados">
                                                            
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
        							</div>
        						</div>
        					</div>
        				</div>
        			</div>
        		</div>
      		</div>
      	</div>

        <!-- Ventanas modal -->
        <!-- Generar Comprobante -->
        <div id="divmodal_GenerarComprobante" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width: 40%; margin-top: 3%; margin-left: 30%">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">
                            &times;
                        </button>

                        <h4 class="modal-title" id="titulo_AddProducto"><b>
                            Generar Comprobante
                        </b></h4>
                    </div>

                    <div class="modal-body">
                        <form class="form-horizontal form-label-left">
                            <div class="row">
                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                        Tipo Comprobante
                                    </label>
                                    <div class="col-md-7 col-sm-7 col-xs-12">
                                        <select id="lista_comprobante" class="form-control" onchange="f_GetCorrelativoComprobante(); f_CalcularTotales()" required>
                                            <option selected = "true" value="">Elija una opción...</option>

                                            <?php
                                                $c = 1;

                                                $q_Documento = "SELECT  iIdTipoDocumento,
                                                                        cDescripcion
                                                                  FROM  Tipo_Documento_Pago
                                                                 WHERE  bGeneraDocumento = 1";

                                                if ($res_Documento = sqlsrv_query($enlacehost, $q_Documento)) {
                                                    while($row_Documento = sqlsrv_fetch_array($res_Documento)) {
                                                         echo '<option value="'.$row_Documento["iIdTipoDocumento"].'">'.$row_Documento["cDescripcion"].'</option>';

                                                         $c += 1;
                                                    }
                                                }
                                            ?>

                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                        N° Serie
                                    </label>
                                    <div class="col-md-7 col-sm-7 col-xs-12"><b>
                                        <input type="number" class="form-control col-md-12 col-xs-12" id="serie_comprobante" style="text-align: center; color: #A63D33" disabled/>
                                    </b></div>
                                </div>

                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                        N° Comprobante
                                    </label>
                                    <div class="col-md-7 col-sm-7 col-xs-12"><b>
                                        <input type="number" class="form-control col-md-12 col-xs-12" id="num_comprobante" style="text-align: right; color: #A63D33"/>
                                    </b></div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                    <div class="x_panel" style="border: solid; border-width: 1px; border-color: #829BCD; border-radius: 7px; background-color: #F2E6C2">
                                        <div class="x_title">
                                            <h2 style="font-size: 14px; color: #048ABF"><b>
                                                Datos del Cliente
                                            </b></h2>
                                            <div class="clearfix">
                                            </div>
                                        </div>

                                        <div class="x_content">
                                            <!-- <input id="iIdCliente" type="hidden">
                                            <input id="IdDocCliente" type="hidden">
                                            <input id="IdTipoDocSunat" type="hidden"> -->
                                            <input id="id_pedido" type="hidden">
                                            <input id="iIdCliente" type="hidden">
                                            <input id="IdDocCliente" type="hidden">
                                            <input id="IdTipoDocSunat" type="hidden">
                                            <input id="Inc_igv" type="hidden">
                                            <input id="idCompany" type="hidden">
                                            <input id="idTerminal" type="hidden">
                                            <input id="idTienda" type="hidden">
                                            <input id="iIdUser" type="hidden">
                                            <input id="dateKey" type="hidden">

                                            <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                <label class="control-label col-md-4 col-sm-4 col-xs-12" style="text-align: right;">
                                                    DNI / RUC
                                                </label>
                                                <div class="col-md-7 col-sm-7 col-xs-11">
                                                    <input type="number" id="cliente_dni" placeholder="DNI / RUC de Cliente" class="form-control col-md-7 col-xs-12" onkeyup="f_BuscarClientes(3)">
                                                </div>
                                                <!-- <div class="col-md-1 col-sm-1 col-xs-1">
                                                    <img src="images/add_users.png" width="35px" style="cursor: pointer;" title="Nuevo Cliente" onclick="f_AddNewCliente()">
                                                </div> -->
                                            </div>

                                            <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                                <label class="control-label col-md-3 col-sm-3 col-xs-12" style="text-align: right;">
                                                    Nombres
                                                </label>
                                                <div class="col-md-9 col-sm-9 col-xs-12">
                                                    <input type="text" id="cliente_nombre" placeholder="Nombre de Cliente" class="form-control col-md-9 col-xs-12" onkeyup="f_BuscarClientes(4)">
                                                </div>
                                            </div>

                                            <div class="row col-md-12 col-sm-12 col-xs-12" id="div_buscarclientes2" style="display: none;">
                                                <div class="row" style="background-color: #9CB6D9; height: 30px; border: solid; border-width: 1px; border-color: #829BCD; border-radius: 7px; text-align: center;">
                                                    <label style="margin-top: -5px"><h2><b><font color="#ffffff" style="font-size: 15px">
                                                        Búsqueda de Clientes
                                                    </font></b></h2></label>
                                                </div>

                                                <div class="row" id="div_sinclientes2" style="border: solid; border-width: 1px; border-color: #D9D9D9; background-color: #F22727; color: #ffffff"><center>
                                                    No se encontraron resultados
                                                </center></div>

                                                <div class="row" style="overflow: auto; height: 150px">
                                                    <table class="table table-striped jambo_table bulk_action">
                                                        <thead>
                                                            <tr>
                                                                <th style="width: 2%"><center>
                                                                    Item
                                                                </center></th>
                                                                <th style="width: 18%"><center>
                                                                    DNI / RUC Cliente
                                                                </center></th>
                                                                <th style="width: 80%"><center>
                                                                    Nombre Cliente
                                                                </center></th>
                                                            </tr>
                                                        </thead>

                                                        <tbody id="tabla_busquedaclientes2">
                                                            
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div class="row col-md-12 col-sm-12 col-xs-12">
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-12 col-sm-12 col-xs-12" style="margin-top: -18px">
                                    <div class="x_panel" style="border: solid; border-width: 1px; border-color: #829BCD; border-radius: 7px; background-color: #B8D9D5">
                                        <div class="x_title">
                                            <h2 style="font-size: 14px; color: #048ABF"><b>
                                                Datos de la Venta
                                            </b></h2>
                                            <div class="clearfix">
                                            </div>
                                        </div>

                                        <div class="x_content">
                                            <table class="table table-striped jambo_table bulk_action">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 1%; border: solid; border-width: 1px; border-color: #E7E3E1;"><center>
                                                            Item
                                                        </center></th>
                                                        <th style="width: 10%; border: solid; border-width: 1px; border-color: #E7E3E1;"><center>
                                                            Muestra
                                                        </center></th>
                                                        <th style="width: 15%; border: solid; border-width: 1px; border-color: #E7E3E1;"><center>
                                                            Descripción
                                                        </center></th>
                                                        <th style="width: 5%; border: solid; border-width: 1px; border-color: #E7E3E1;"><center>
                                                            Total (S/)
                                                        </center></th>
                                                    </tr>
                                                </thead>

                                                <tbody id="table_detalleventa" style="background-color: #ffffff">
                                                    
                                                </tbody>
                                            </table>

                                            <div class="row">
                                                <center>
                                                    <div class="col-md-4 col-sm-4 col-xs-12">
                                                        <div class="x_panel" style="margin-top: 5px; border: solid; border-width: 1px; border-radius: 7px; border-color: #D9D9D9;">
                                                            <div class="x_title">
                                                                <h2><b>
                                                                    Sub Total (S/)
                                                                </b></h2>
                                                                <div class="clearfix">
                                                                </div>
                                                            </div>

                                                            <div class="x_content" style="background-color: #A63D33; border: solid; border-width: 1px; border-radius: 7px; border-color: #D9D9D9;">
                                                                <label id="sub_total" style="font-size: 24px; margin-top: 10px;"><font color="#ffffff">
                                                                    0.00
                                                                </font></label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-4 col-sm-4 col-xs-12">
                                                        <div class="x_panel" style="margin-top: 5px; border: solid; border-width: 1px; border-radius: 7px; border-color: #D9D9D9;">
                                                            <div class="x_title">
                                                                <h2><b>
                                                                    IGV (S/)
                                                                </b></h2>
                                                                <div class="clearfix">
                                                                </div>
                                                            </div>

                                                            <div class="x_content" style="background-color: #F2DEA2; border: solid; border-width: 1px; border-radius: 7px; border-color: #D9D9D9; color: #595959">
                                                                <label id="igv" style="font-size: 24px; margin-top: 10px;">
                                                                    0.00
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-4 col-sm-4 col-xs-12">
                                                        <div class="x_panel" style="margin-top: 5px; border: solid; border-width: 1px; border-radius: 7px; border-color: #D9D9D9;">
                                                            <div class="x_title">
                                                                <h2><b>
                                                                    Total (S/)
                                                                </b></h2>
                                                                <div class="clearfix">
                                                                </div>
                                                            </div>

                                                            <div class="x_content" style="background-color: #A457BF; border: solid; border-width: 1px; border-radius: 7px; border-color: #D9D9D9;">
                                                                <label id="total" style="font-size: 24px; margin-top: 10px;"><font color="#ffffff">
                                                                    0.00
                                                                </font></label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </center>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <br/>

                            <div class="ln_solid"></div>

                            <!-- Campos usados al momento de grabar los datos -->
                            <input id="id_producto" type="hidden">
                            <input id="modo_grabar" type="hidden">
                            <input id="correlatvo_CI" type="hidden">

                            <div class="form-group"><center>
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <button class="btn btn-dark" type="button" onclick="f_cerrarModal(1)">
                                        Cancelar
                                    </button>
                                    <button class="btn btn-success" type="button" onclick="f_ProcesarComprobante()">
                                        Generar Comprobante
                                    </button>
                                </div>
                            </center></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Agregar Nuevos Clientes -->
        <div id="divmodal_AddNewCliente" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width: 40%; margin-top: 12%; margin-left: 30%">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">
                            &times;
                        </button>

                        <h4 class="modal-title" id="titulo_AddProducto"><b>
                            Registro de nuevo Cliente
                        </b></h4>
                    </div>

                    <div class="modal-body">
                        <form class="form-horizontal form-label-left">
                            <div class="row">
                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                        Tipo Cliente
                                    </label>
                                    <div class="col-md-7 col-sm-7 col-xs-12">
                                        <select id="lista_tipocliente" class="form-control" required>
                                            <option selected = "true" value="">Elija una opción...</option>

                                            <?php
                                                $c = 1;

                                                $q_TipoCliente = "SELECT idTipoCliente,
                                                                         cDescripcionTipoCliente
                                                                    FROM TipoCliente
                                                                   WHERE idTipoCliente IN (3, 4)";

                                                if ($res_TipoCliente = sqlsrv_query($enlacehost, $q_TipoCliente)) {
                                                    while($row_TipoCliente = sqlsrv_fetch_array($res_TipoCliente)) {
                                                         echo '<option value="'.$row_TipoCliente["idTipoCliente"].'">'.$row_TipoCliente["cDescripcionTipoCliente"].'</option>';

                                                         $c += 1;
                                                    }
                                                }
                                            ?>

                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                        Tipo Documento
                                    </label>
                                    <div class="col-md-7 col-sm-7 col-xs-12">
                                        <select id="lista_tipodocumento" class="form-control" required>
                                            <option selected = "true" value="">Elija una opción...</option>

                                            <?php
                                                $c = 1;

                                                $q_TipoDocumento = "SELECT  iIdTipoDocumento,
                                                                            cDescripcionCorta
                                                                      FROM  TipodeDocumento
                                                                     WHERE  iIdTipoDocumento IN (100, 102)";

                                                if ($res_TipoDocumento = sqlsrv_query($enlacehost, $q_TipoDocumento)) {
                                                    while($row_TipoDocumento = sqlsrv_fetch_array($res_TipoDocumento)) {
                                                         echo '<option value="'.$row_TipoDocumento["iIdTipoDocumento"].'">'.$row_TipoDocumento["cDescripcionCorta"].'</option>';

                                                         $c += 1;
                                                    }
                                                }
                                            ?>

                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                        DNI / RUC
                                    </label>
                                    <div class="col-md-7 col-sm-7 col-xs-12">
                                        <input type="number" class="form-control col-md-12 col-xs-12" id="cliente_dni" style="text-align: right;"/>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                    <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-left: 25px">
                                        Nombres
                                    </label>
                                    <div class="col-md-9 col-sm-9 col-xs-12">
                                        <input type="text" class="form-control col-md-12 col-xs-12" id="cliente_nombre"/>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                        Teléfono 1
                                    </label>
                                    <div class="col-md-7 col-sm-7 col-xs-12">
                                        <input type="number" class="form-control col-md-12 col-xs-12" id="cliente_telefono1" style="text-align: right;"/>
                                    </div>
                                </div>

                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <label class="control-label col-md-3 col-sm-3 col-xs-12">
                                        Teléfono 2
                                    </label>
                                    <div class="col-md-9 col-sm-9 col-xs-12">
                                        <input type="text" class="form-control col-md-12 col-xs-12" id="cliente_telefono2" style="text-align: right;"/>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                    <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-left: 25px">
                                        Correo
                                    </label>
                                    <div class="col-md-9 col-sm-9 col-xs-12">
                                        <input type="text" class="form-control col-md-12 col-xs-12" id="cliente_correo" placeholder="Ejemplo: correo1@xxxx.com; correo2@yyyy.com" />
                                    </div>
                                </div>
                            </div>

                            <br/>

                            <div class="ln_solid"></div>

                            <!-- Campos usados al momento de grabar los datos -->
                            <input id="id_producto" type="hidden">
                            <input id="modo_grabar" type="hidden">
                            <input id="correlatvo_CI" type="hidden">

                            <div class="form-group"><center>
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <button class="btn btn-dark" type="button" onclick="f_cerrarModal(2)">
                                        Cancelar
                                    </button>
                                    <button class="btn btn-success" type="button" onclick="f_GrabarNewCliente()">
                                        Grabar
                                    </button>
                                </div>
                            </center></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div id="divmodal_ConfirmarPago" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width: 30%; margin-top: 12%; margin-left: 35%">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">
                            &times;
                        </button>

                        <h4 class="modal-title"><b>
                            Confirmar Pago
                        </b></h4>
                    </div>

                    <div class="modal-body">
                        <form class="form-horizontal form-label-left">
                            <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" style="margin-top: 10px; text-align: right;">
                                        Medio de Pago
                                </label>
                                <div class="form-group col-md-8 col-sm-8 col-xs-12">
                                    <select id="lista_mediopago_pago" class="form-control col-md-8 col-sm-8 col-xs-12" style="margin-top: 9px; text-align: left;" onchange="f_ShowEfectivo()" required>
                                        <option selected value="">Elija una opción...</option>

                                        <?php
                                            $c = 1;

                                            $q_mediopago = "SELECT Id,
                                                                   des_mediopago,
                                                                   efectivo_mediopago
                                                              FROM _max_labperu_MedioPago
                                                             WHERE estado_mediopago = 'A'";

                                            if ($res_mediopago = sqlsrv_query($enlacehost, $q_mediopago)) {
                                                while($row_mediopago = sqlsrv_fetch_array($res_mediopago)) {
                                                    echo '<option value="'.$row_mediopago["Id"].'|'.$row_mediopago["efectivo_mediopago"].'">'.$row_mediopago["des_mediopago"].'</option>';

                                                     $c += 1;
                                                }
                                            }
                                        ?>

                                    </select>
                                </div>
                            </div>

                            <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                <!-- <div class="form-group col-md-12 col-sm-12 col-xs-12" style="background-color: #949494; border: solid; border-width: 1px; border-color: #D9D9D9; border-radius: 7px; margin-left: 10px"> -->
                                    <label class="control-label col-md-3 col-sm-3 col-xs-12" style="text-align: right;">
                                        Observación
                                    </label>
                                    <div class="form-group col-md-8 col-sm-8 col-xs-12">
                                        <textarea id="observacion_pago" class="form-control col-md-8 col-sm-8 col-xs-12"></textarea>
                                    </div><!-- 
                                </div> -->
                            </div>

                            <br/>

                            <div class="ln_solid" style="margin-top: 120px;"></div>

                            <!-- Campos usados al momento de grabar los datos -->
                            <input id="id_pedido_pago" type="hidden">

                            <div class="form-group"><center>
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <button class="btn btn-dark" type="button" onclick="f_cerrarModal(3)">
                                        Cancelar
                                    </button>
                                    <button class="btn btn-success" type="button" onclick="f_ActualizarPago()">
                                        Grabar
                                    </button>
                                </div>
                            </center></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div id="divmodal_Loading" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false" style="margin-top: 300px;">
            <div class="modal-dialog" style="height: 200px; opacity: 0.5;"><center>
                <img src="images/loading.gif" width="200px" style="border: solid; border-width: 1px; border-color: #D9D9D9;  border-radius: 15px;"></img>
            </center></div>
        </div>

      	<!-- jQuery -->
	    <script src="../vendors/jquery/dist/jquery.min.js"></script>
	    <!-- Bootstrap -->
	    <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
	    <!-- FastClick -->
	    <script src="../vendors/fastclick/lib/fastclick.js"></script>
	    <!-- NProgress -->
	    <script src="../vendors/nprogress/nprogress.js"></script>
	    <!-- Ion.RangeSlider -->
    	<script src="../vendors/ion.rangeSlider/js/ion.rangeSlider.min.js"></script>
    	<!-- Bootstrap Colorpicker -->
    	<script src="../vendors/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
	    <!-- Custom Theme Scripts -->
	    <script src="../build/js/custom.min.js"></script>
        <!-- Toggle Switch -->
        <script src="bootstrap/js/bootstrap4-toggle.min.js"></script>

	    <!-- bootstrap-daterangepicker -->
	    <script src="../vendors/moment/min/moment.min.js"></script>
	    <script src="../vendors/bootstrap-daterangepicker/daterangepicker.js"></script><!-- Datatables -->
	    <script src="../vendors/datatables.net/js/jquery.dataTables.min.js"></script>
	    <script src="../vendors/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
	    <script src="../vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/buttons.flash.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/buttons.html5.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/buttons.print.min.js"></script>
	    <script src="../vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js"></script>
	    <script src="../vendors/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
	    <script src="../vendors/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
	    <script src="../vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js"></script>
	    <script src="../vendors/datatables.net-scroller/js/dataTables.scroller.min.js"></script>
	    <script src="../vendors/jszip/dist/jszip.min.js"></script>
	    <script src="../vendors/pdfmake/build/pdfmake.min.js"></script>
	    <script src="../vendors/pdfmake/build/vfs_fonts.js"></script>

        <!-- Ventanas modales -->
        <script type="text/javascript">
            function f_GenerarComprobante(_Id_Pedido, _FechaRecepcion, _NumSerie, _doc_cliente, _nombre_cliente, _inc_igv, _idCompany, _idTerminal, _idTienda, _iIdUser){
                if (_inc_igv == 'NO'){
                    if (!confirm('La Venta seleccionada "No Incluye IGV".' + "\n\n" + '¿Está seguro de continuar?')){
                        return;
                    }
                }

                var modal = $("#divmodal_GenerarComprobante");

                $("#serie_comprobante").val(_NumSerie);
                $("#cliente_dni").val(_doc_cliente);
                $("#cliente_nombre").val(_nombre_cliente);

                $("#id_pedido").val(_Id_Pedido);
                $("#iIdCliente").val('');
                $("#IdDocCliente").val('');
                $("#IdTipoDocSunat").val('');
                $("#Inc_igv").val(_inc_igv);
                $("#idCompany").val(_idCompany);
                $("#idTerminal").val(_idTerminal);
                $("#idTienda").val(_idTienda);
                $("#iIdUser").val(_iIdUser);
                $("#dateKey").val(_FechaRecepcion);

                $("#lista_comprobante").val('');
                $("#serie_comprobante").val('001');
                $("#num_comprobante").val('');

                var exceso = 0;
                // var total = 0;

                // Generando el Resumen de la Venta y detalle de la venta
                    var htmlContenido = '';

                    $("#table_detalleventa").html(htmlContenido);

                    $("#total").html('<font color="#ffffff">0.00</font>');
                    $("#igv").html('0.00');
                    $("#sub_total").html('<font color="#ffffff">0.00</font>');

                    // Loading Modal
                        var modal_loading = $("#divmodal_Loading");
                        modal_loading.modal({backdrop: 'static', keyboard: false});

                    $.post( "ajax/encuesta.php", { accion: "Get_ResumenVenta", Id_Pedido: _Id_Pedido }, 
                        function( data_r ) {
                            if(data_r.estado == 1){
                                $.each( data_r.registros, function( key, val_r ) {
                                    exceso = val_r.EXCESO;
                                    // sub_total = val_r.SUB_TOTAL;
                                    total = val_r.TOTAL;

                                    // Generando el Detalle de la Venta                                       
                                        var d = 1;

                                        $.post( "ajax/encuesta.php", { accion: "Get_DetalleVenta", Id_Pedido: _Id_Pedido }, 
                                            function( data ) {
                                                if(data.estado == 1){
                                                    $.each( data.registros, function( key, val ) {
                                                        htmlContenido += '<tr>';

                                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1; text-align: right">' + d + "</td>";
                                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1;">' + val.Nom_Muestra + "</td>";
                                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1; text-align: center">' + val.Elemento_Analisis + "</td>";
                                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1; text-align: right">' + parseFloat(val.Precio_Final).toFixed(2) + "</td>";

                                                        htmlContenido += "</tr>";

                                                        d += 1;
                                                    });
    
                                                    // Agregando el Exceo como detalles adicional
                                                        if (exceso > 0){
                                                            htmlContenido += '<tr>';

                                                            htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1; text-align: right">' + d + "</td>";
                                                            htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1;">Exceso</td>';
                                                            htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1; text-align: center">Total acumulado</td>';
                                                            htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #E7E3E1; text-align: right">' + parseFloat(exceso).toFixed(2) + "</td>";

                                                            htmlContenido += "</tr>";
                                                        }
    
                                                    $("#table_detalleventa").html(htmlContenido);

                                                    // Cerrando Modal
                                                        $('#divmodal_Loading').modal('hide');

                                                    f_CalcularTotales();
                                                }
                                            }, "json");
                                });
                            }
                        }, "json");

                modal.modal({backdrop: 'static', keyboard: false});
            };
        </script>

	    <!-- Funciones de Búsqueda -->
	    <script type="text/javascript">
	    	// Buscando Clientes
                function f_BuscarClientes(tipo_busqueda){
                    var compania = <?php echo $_SESSION["bdOmar_Compania"]; ?>;
                    var htmlContenido = '';

                    if (tipo_busqueda == 1 || tipo_busqueda == 2){
                        var str_busqueda = ((tipo_busqueda == 1) ? $("#dni_cliente").val() : $("#nom_cliente").val());

                        $("#tabla_busquedaclientes").html(htmlContenido);
                    }
                    else{
                        var str_busqueda = ((tipo_busqueda == 3) ? $("#cliente_dni").val() : $("#cliente_nombre").val());

                        $("#tabla_busquedaclientes2").html(htmlContenido);
                    }

                    var c = 1;

                    $.post( "ajax/encuesta.php", { accion: "Get_Clientes", idCompany: compania, tipo_filtro: tipo_busqueda, filtro: str_busqueda }, 
                        function( data ) {
                            if(data.estado == 1){
                                $.each( data.registros, function( key, val ) {
                                    htmlContenido += '<tr style="cursor: pointer" onclick="f_AddCliente(' + tipo_busqueda + ', ' + val.iIdCliente + ', ' + val.cNumeroRuc + ", '" + val.cRazonSocial + "', " + val.id_Tipo_Documento + ", " + val.id_doc_sunat + ')">';

                                    htmlContenido += "  <td>" + c + "</td>";
                                    htmlContenido += "  <td><center>" + val.cNumeroRuc + "</center></td>";
                                    htmlContenido += "  <td>" + val.cRazonSocial + "</td>";

                                    htmlContenido += "</tr>";

                                    c += 1;
                                });
                            }

                            if (tipo_busqueda == 1 || tipo_busqueda == 2){
                                $("#tabla_busquedaclientes").html(htmlContenido);

                                 if (c == 1){
                                    f_CerrarDiv('A', 'div_sinclientes');
                                }
                                else{
                                    f_CerrarDiv('C', 'div_sinclientes');
                                }
                            }
                            else{
                                $("#tabla_busquedaclientes2").html(htmlContenido);

                                 if (c == 1){
                                    f_CerrarDiv('A', 'div_sinclientes2');
                                }
                                else{
                                    f_CerrarDiv('C', 'div_sinclientes2');
                                }
                            }

                        }, "json");

                    if (tipo_busqueda == 1 || tipo_busqueda == 2){
                        f_CerrarDiv('A', 'div_buscarclientes');
                    }
                    else{
                        f_CerrarDiv('A', 'div_buscarclientes2');
                    }
                };

            // Cargando Resultados
                function f_LoadResultados(){
                    var htmlContenido = '';

                    // Obteniendo filtros
                        var fecha_inicio = $("#fecha_inicio").val();
                        var fecha_fin = $("#fecha_fin").val();
                        var dni_cliente = $("#dni_cliente").val();
                        var nom_cliente = $("#nom_cliente").val();
                        var medio_pago = $("#lista_mediopago").val();
                        var num_recibo = $("#num_recibo").val();

                    // Validando ingreso de filtros
                        if (fecha_inicio == null){
                            alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }
                        if (fecha_inicio.length == 0){
                            alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }

                        if (fecha_fin == null){
                            alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }
                        if (fecha_fin.length == 0){
                            alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }

                        if (fecha_fin < fecha_inicio){
                            alert('La fecha "Desde" no puede ser mayor a la fecha "Hasta".\nPor favor, verificar.');

                            return;
                        }

                    // Loading Modal
                        var modal_loading = $("#divmodal_Loading");
                        modal_loading.modal({backdrop: 'static', keyboard: false});

                    // Carga resultados
                        var c = 1;
                        var _visible = 0;

                        $("#tabla_ventasresultados").html(htmlContenido);

                        $.post( "ajax/encuesta.php", { accion: "Get_AtencionPedidos", fecha_inicio: fecha_inicio, fecha_fin: fecha_fin, dni_cliente: dni_cliente, nom_cliente: nom_cliente, medio_pago: medio_pago, num_recibo: num_recibo }, 
                            function( data ) {
                                if(data.estado == 1){
                                    $.each( data.registros, function( key, val ) {
                                        htmlContenido += '<tr>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; text-align: right">' + c + '</td>';
                                        
                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';

                                        if (val.es_anulada == 0){
                                            // if (val.Id_Comprobante == null){
                                                htmlContenido += '      <a class="success" href="javascript: f_EditarVenta(' + val.Id_Pedido + ", '" + val.Cod_Interno + "'" + ')"><font color="#4B94F2"><i class="fa fa-edit"></i> Editar Venta </font></a><br>';
                                            // }

                                            htmlContenido += '      <a class="success" href="javascript: f_ConfirmarPago(' + val.Id_Pedido + ')"><font color="#32B86C"><i class="fa fa-credit-card"></i> Confirmar Pago </font></a><br>';

                                            if (val.Id_Comprobante == null){
                                                htmlContenido += '      <a class="success" href="javascript: f_AnularVenta(' + val.Id_Pedido + ", '" + val.COMPROBANTE_1 + "'" + ')"><font color="#BF344D"><i class="fa fa-edit"></i> Anular Venta </font></a><br>';
                                            }

                                            if (val.Id_Comprobante == null){
                                                htmlContenido += '      <a class="success" href="javascript: f_GenerarComprobante(' + val.Id_Pedido + ", '" + val.FECHA_RECEPCION + "', '" + val.cod_sucursal + "', '" + val.Documento_Cliente + "', '" + val.Nombre_Cliente + "', '" + val.INC_IGV + "', " + val.iIdCompany + ", " + val.iId_Terminal + ", " + val.iIdTienda + ", " + val.iIdUser + ')"><font color="#F28B0C"><i class="fa fa-edit"></i> Generar Comprobante </font></a><br>';
                                            }
                                        }

                                        if (val.Id_Comprobante != null){
                                            htmlContenido += '      <a class="success" href="javascript: f_AnularComprobante(' + val.Id_Pedido + ", '" + val.COMPROBANTE_2 + "'" + ')"><font color="#757777"><i class="fa fa-edit"></i> Anular Comprobante </font></a><br>';
                                        }

                                        htmlContenido += '  </td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242; background-color: ' + ((val.Sucursal == 1) ? '#D1DBBD' : '#D89196') + '"><center><b>' + val.des_sucursal + '</b></center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>';

                                            htmlContenido += '      <a class="success" href="javascript: f_ImprimirRecibo(' + val.Id_Pedido + ')"><font color="#4B94F2"><u> ' + val.COMPROBANTE_1 + '</u></font></a>';

                                        htmlContenido += ' </b></center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #F25050;"><center><b>';

                                            htmlContenido += '      <a class="success" href="javascript: f_ImprimirComprobante(' + val.Id_Pedido + ')"><font color="#4B94F2"><u> ' + val.COMPROBANTE_2 + '</u></font></a>';

                                        htmlContenido += ' </b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + val.Nombre_Cliente + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + val.Documento_Cliente + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + val.CLIENTE_COMPROBANTE + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + val.CLIENTE_DOCUMENTO + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242; ' + ((val.con_color == 1) ? 'background-color: #F2D479' : '') + '"><center><b>' + val.des_mediopago + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + val.FechaHora_Recepcion + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + parseFloat(val.Total_Venta).toFixed(2) + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;' + ((val.INC_IGV == 'SI') ? 'background-color: #70ABFF' : '') + '"><center><b>' + val.INC_IGV + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;' + ((val.es_pagado != 1) ? 'background-color: #D9BBA9' : '') + '"><center><b>' + val.ESTADO_PAGADO + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + val.Fecha_Pagado + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center><b>' + val.usu_usuario + '</b></center></td>';

                                        htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: ' + ((val.es_anulada == 0) ? '#3F4242' : '#ffffff') + ';' + ((val.es_anulada == 0) ? '' : 'background-color: #F25050;') + '"><center><b>' + val.USUARIO_ANULACION + '</b></center></td>';

                                        htmlContenido += "</tr>";

                                        c += 1;
                                    });
                                }
                                else{
                                    alert("No se encontraron resultados para la búsqueda solicitada");
                                }

                                // Cerrando Modal
                                    $('#divmodal_Loading').modal('hide');

                                $("#tabla_ventasresultados").html(htmlContenido);
                            }, "json");
                };
	    </script>

	    <!-- Funciones Principales -->
	    <script type="text/javascript">
	    	function f_AddCliente(_tipo_busqueda, _id_cliente, _dni_cliente, _nombre_cliente, _IdDocCliente, _IdTipoDocSunat){
                if (_tipo_busqueda == 1 || _tipo_busqueda == 2){
                    $("#dni_cliente").val(_dni_cliente);
                    $("#nom_cliente").val(_nombre_cliente);

                    f_CerrarDiv('C', 'div_buscarclientes');
                }
                else{
                    $("#iIdCliente").val(_id_cliente);
                    $("#cliente_dni").val(_dni_cliente);
                    $("#cliente_nombre").val(_nombre_cliente);
                    $("#IdDocCliente").val(_IdDocCliente);
                    $("#IdTipoDocSunat").val(_IdTipoDocSunat);

                    f_CerrarDiv('C', 'div_buscarclientes2');
                }
            };

            function f_GetCorrelativoComprobante(){
                var tipo_comprobante = $("#lista_comprobante").val();
                var serie = $("#serie_comprobante").val();

                // Obtiene el Correlativo según el Tipo de Comprobante y la Serie
                    $.post( "ajax/encuesta.php", { accion: "Get_CorrelativoComprobante", Tipo_Comprobante: tipo_comprobante, NumSerie: serie }, 
                        function( data ) {
                            if(data.estado == 1){
                                $.each( data.registros, function( key, val ) {
                                    $("#num_comprobante").val((val.NUM_COMPROBANTE == null) ? '00000000' : val.NUM_COMPROBANTE);
                                });
                            }
                        }, "json");
            };

            function f_AddNewCliente(){
                var modal = $("#divmodal_AddNewCliente");

                $("#lista_tipocliente").val('');
                $("#lista_tipodocumento").val('');
                $("#cliente_dni").val($("#dni_cliente").val());
                $("#cliente_nombre").val($("#nom_cliente").val());
                $("#cliente_telefono1").val('');
                $("#cliente_telefono2").val('');
                $("#cliente_correo").val('');

                modal.modal({backdrop: 'static', keyboard: false});
            };

            function f_CalcularTotales(){
                var tipo_comprobante = $("#lista_comprobante").val();
                var inc_igv = $("#Inc_igv").val();

                // if (tipo_comprobante == 1001 || tipo_comprobante == 1003){
                    if (inc_igv == 'SI'){
                        $("#sub_total").html('<font color="#ffffff">' + parseFloat(total).toFixed(2) + '</font>');
                        $("#igv").html('<font color="#595959">' + parseFloat(total * 0.18).toFixed(2) + '</font>');
                        $("#total").html('<font color="#ffffff">' + parseFloat(total * 1.18).toFixed(2) + '</font>');
                    }
                    else{
                        $("#sub_total").html('<font color="#ffffff">' + parseFloat(total / 1.18).toFixed(2) + '</font>');
                        $("#igv").html('<font color="#595959">' + parseFloat(total - (total / 1.18)).toFixed(2) + '</font>');
                        $("#total").html('<font color="#ffffff">' + parseFloat(total).toFixed(2) + '</font>');
                    }
                // }
                // else{
                //     $("#total").html('<font color="#ffffff">0.00</font>');
                //     $("#igv").html('0.00');
                //     $("#sub_total").html('<font color="#ffffff">0.00</font>');
                // }
            };

            function f_ProcesarComprobante(){
                // Obteniendo valores globales
                    var id_pedido = $("#id_pedido").val();
                    var idCompany =  $("#idCompany").val();
                    var idTerminal =  $("#idTerminal").val();
                    var idTienda =  $("#idTienda").val();
                    var iIdUser =  $("#iIdUser").val();
                    var dateKey = $("#dateKey").val();
                    var inc_igv = $("#Inc_igv").val();

                // Validando datos
                    var lista_comprobante = $("#lista_comprobante").val();
                    var serie_comprobante = $("#serie_comprobante").val();
                    var num_comprobante = $("#num_comprobante").val();
                    var cliente_dni = $("#cliente_dni").val();
                    var cliente_nombre = $("#cliente_nombre").val();

                    if (lista_comprobante == null){
                        alert("Debe seleccionar el Tipo de Comprobante que desea generar");

                        return;
                    }
                    if (lista_comprobante.length == 0){
                        alert("Debe seleccionar el Tipo de Comprobante que desea generar");

                        return;
                    }

                    if (num_comprobante == null){
                        alert("Debe seleccionar el Número de Comprobante");

                        return;
                    }
                    if (num_comprobante.length == 0){
                        alert("Debe seleccionar el Número de Comprobante");

                        return;
                    }
                    if (num_comprobante <= 0){
                        alert("El número de Comprobante es incorrecto.\nPor favor, verificar");

                        return;
                    }

                    if (lista_comprobante == 1001 && $("#cliente_dni").val().trim().length < 11){
                        alert("La longitud del RUC ingresado no es correcto. Por favor, verificar.");

                        return;
                    }

                // Por si cambia el cliente obtiene sus nuevos datos
                    var iIdCliente = $("#iIdCliente").val();
                    var IdDocCliente = $("#IdDocCliente").val();
                    var IdTipoDocSunat = $("#IdTipoDocSunat").val();

                // Loading Modal
                        var modal_loading = $("#divmodal_Loading");
                        modal_loading.modal({backdrop: 'static', keyboard: false});

                // Procesando el Comprobante
                    $.post( "ajax/encuesta.php", { accion: "Procesar_Comprobante", id_pedido: id_pedido, idCompany: idCompany, idTerminal: idTerminal, idTienda: idTienda, iIdUser: iIdUser, dateKey: dateKey, iIdCliente: iIdCliente, cNombreCliente: cliente_nombre, IdDocCliente: IdDocCliente, IdTipoDocSunat: IdTipoDocSunat, cNumDocCliente: cliente_dni, idTipoDocPago: lista_comprobante, serie_comprobante: serie_comprobante, num_comprobante: num_comprobante, inc_igv: inc_igv },
                        function( data ) {

                            if(data.estado == 0){
                                alert("El Comprobante fue generado satisfactoriamente");

                                f_cerrarModal(1);
                                f_LoadResultados();

                                // Cerrando Modal
                                    $('#divmodal_Loading').modal('hide');
                            }
                            else{
                                // Cerrando Modal
                                    $('#divmodal_Loading').modal('hide');

                                if (data.estado == 99){
                                    alert("El número de factura ingresado ya fue emitido anteriormente.\nPor fvor, verificar.");

                                    return;
                                }

                                alert("Error en el proceso N° " + data.estado + ". Haga lo siguiente: \n    - Genere nuevamente el comprobante.\n    - Si este error (N° " + data.estado + ") se vuelve a mostrar comuníquese con el adminsitrador del sistema y reporte el número del mensaje.");
                            }
                        }, "json");
            };

            function f_ConfirmarPago(_Id_Pedido){
                var modal = $("#divmodal_ConfirmarPago");

                $("#id_pedido_pago").val(_Id_Pedido);

                modal.modal({backdrop: 'static', keyboard: false});
            };

            function f_ActualizarPago(){
                var id_pedido = $("#id_pedido_pago").val();
                var medio_pago = $("#lista_mediopago_pago").val().substring(0, $("#lista_mediopago_pago").val().indexOf('|'));
                var observacion_pago = $("#observacion_pago").val().trim();

                if (medio_pago == null){
                    alert("Debe seleccionar el Medio de Pago");

                    return;
                }
                if (medio_pago.length == 0){
                    alert("Debe seleccionar el Medio de Pago");

                    return;
                }

                $.post( "ajax/encuesta.php", { accion: "Confirmar_Pago", id_pedido: id_pedido, medio_pago: medio_pago, observacion_pago: observacion_pago },
                    function( data ) {
                        if(data.estado == 1){
                            alert("El Pago de la venta seleccionada fue actualizado satisfactoriamente");

                            f_LoadResultados();
                        }
                        else{
                            alert("Ocurrió un error al momento de actualizar el pago");
                        }

                    }, "json");
            };

            function f_EditarVenta(_Id_Pedido, _Codigo_Interno){
                var url = "editar_venta.php?Id=" + _Id_Pedido + "&CI=" + _Codigo_Interno;

                window.open(url, '_blank');
            };

            function f_AnularVenta(_Id_Pedido, _Num_Comprobante){
                if (confirm('¿Está seguro de Anular la venta con N° de Comprobante:\n"' + _Num_Comprobante + '"?')){
                    var compania = <?php echo $_SESSION["bdOmar_Compania"]; ?>;
                    var tienda = <?php echo $_SESSION["bdOmar_Tienda"]; ?>;
                    var user = <?php echo $_SESSION["bdOmar_User"]; ?>;
                    var terminal = <?php echo $_SESSION["bdOmar_Terminal"]; ?>;

                    var usu_usuario = '<?php echo $_SESSION["usu_usuario"]; ?>';

                    $.post( "ajax/encuesta.php", { accion: "Anular_Venta",
                                                   idCompany: compania,
                                                   idTienda: tienda,
                                                   idUsuario: user,
                                                   idTerminal: terminal,
                                                   IdPedido: _Id_Pedido,
                                                   codeRespuesta : 0,
                                                   mensajeRespuesta: '',
                                                   usu_usuario: usu_usuario },
                        function( data ) {
                            if(data.estado == 1){
                                f_LoadResultados();
                            }
                            else{
                                alert("Ocurrió un error al momento de grabar los datos");
                            }
                        }, "json");
                }
            };

            function f_ImprimirRecibo(_Id_Pedido){
                var url = 'print_recibo.php?Id=' + _Id_Pedido + '&suc=' + '<?php echo $_SESSION["bdOmar_CodSucursal"]; ?>';
                window.open(url,'Imprimiendo Cargos',"");
            };

            function f_ImprimirComprobante(_Id_Pedido){
                var url = 'print_comprobante.php?Id=' + _Id_Pedido;
                window.open(url,'Imprimiendo Cargos',"");
            };

            function f_ExportToExcel(){
                // Obteniendo filtros
                    var fecha_inicio = $("#fecha_inicio").val();
                    var fecha_fin = $("#fecha_fin").val();
                    var dni_cliente = $("#dni_cliente").val();
                    var nom_cliente = $("#nom_cliente").val();
                    var medio_pago = $("#lista_mediopago").val();
                    var num_recibo = $("#num_recibo").val();

                // Validando ingreso de filtros
                    if (fecha_inicio == null){
                        alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }
                    if (fecha_inicio.length == 0){
                        alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }

                    if (fecha_fin == null){
                        alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }
                    if (fecha_fin.length == 0){
                        alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }

                    if (fecha_fin < fecha_inicio){
                        alert('La fecha "Desde" no puede ser mayor a la fecha "Hasta".\nPor favor, verificar.');

                        return;
                    }

                window.location.href = "send_to_excel/export_to_excel_atencionpedido.php?FI="+fecha_inicio+"&FF="+fecha_fin+"&DC="+dni_cliente+"&NC="+nom_cliente+"&MP="+medio_pago+"&NR="+num_recibo;
            };

            function f_AnularComprobante(_Id_Pedido, _Num_Comprobante){
                if (confirm('¿Está seguro de Anular el Comprobante Electrónico N°:\n"' + _Num_Comprobante + '"?')){
                    var motivo = prompt("Ingrese el motivo de la anulación");

                    if (motivo.trim().length == 0){
                        alert("Debe ingresar el motivo de la anulación");

                        return;
                    }

                    var compania = <?php echo $_SESSION["bdOmar_Compania"]; ?>;
                    var tienda = <?php echo $_SESSION["bdOmar_Tienda"]; ?>;
                    var user = <?php echo $_SESSION["bdOmar_User"]; ?>;
                    var terminal = <?php echo $_SESSION["bdOmar_Terminal"]; ?>;

                    var usu_usuario = '<?php echo $_SESSION["usu_usuario"]; ?>';

                    $.post( "ajax/encuesta.php", { accion: "Anular_Comprobante",
                                                   idCompany: compania,
                                                   idTienda: tienda,
                                                   idUsuario: user,
                                                   idTerminal: terminal,
                                                   IdPedido: _Id_Pedido,
                                                   motivo: motivo,
                                                   usu_usuario: usu_usuario },
                        function( data ) {
                            if(data.estado == 1){
                                f_LoadResultados();
                            }
                            else{
                                alert("Ocurrió un error al momento de grabar los datos");
                            }
                        }, "json");
                }
            };
	    </script>

	    <!-- Cerrar DIV's -->
        <script type="text/javascript">
            function f_CerrarDiv(accion, nom_div){
                var _div = document.getElementById(nom_div);

                if (accion == 'A'){
                    _div.style.display = 'block'
                }
                else{
                     _div.style.display = 'none';
                }
            };
        </script>

	    <!-- Otras Funciones -->
	    <script type="text/javascript">
            // Limpiar controles de búsqueda
                function f_ClearBusqueda(){
                    var fecha = new Date();

                    fecha = fecha.getFullYear() + '-' + (((fecha.getMonth() + 1).toString().length == 1) ? '0' + (fecha.getMonth() + 1) : (fecha.getMonth() + 1)) + '-' + fecha.getDate();

                    $("#fecha_inicio").val(fecha);
                    $("#fecha_fin").val(fecha);
                    $("#dni_cliente").val('');
                    $("#nom_cliente").val('');
                    $("#lista_mediopago").val('');
                    $("#num_recibo").val('');
                }

            // Cerrar ventanas modales
                function f_cerrarModal(pantalla_modal){
                    if (pantalla_modal == 1){
                        $('#divmodal_GenerarComprobante').modal('hide');
                    }

                    if (pantalla_modal == 2){
                        $('#divmodal_AddNewCliente').modal('hide');
                    }

                    if (pantalla_modal == 3){
                        $('#divmodal_ConfirmarPago').modal('hide');
                    }
                };

	    	window.addEventListener("keyup",function(e){
                if(e.keyCode==27) {
                    f_CerrarDiv('C', 'div_buscarclientes');
                    f_CerrarDiv('C', 'div_buscarclientes2');
                    f_CerrarDiv('C', 'div_RowAddElementos');
                }
            });
	    </script>
	</body>
</html>

<?php
	cerrarSesion($enlace);
?>