<?php

    session_start();

    include('../../php/conn.php');

    if(!isset($_SESSION["id"])){
        header('Location: index.php');
    }

?>

<!DOCTYPE html>
<html lang="es">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="icon" href="images/favicon.ico" type="image/ico" />

    <title>Administración de Clientes</title>

    <!-- Bootstrap -->
    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <!-- bootstrap-daterangepicker -->
    <link href="../vendors/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">
    <!-- Datatables -->
    <link href="../vendors/datatables.net-bs/css/dataTables.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css" rel="stylesheet">
    <link href="../vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css" rel="stylesheet">

    <!-- Toggle Switch -->
    <link rel="stylesheet" type="text/css" href="bootstrap/css/bootstrap4-toggle.min.css">

    <!-- Custom Theme Style -->
    <link href="../build/css/custom.min.css" rel="stylesheet">
	</head>

	<body class="nav-md"  onload="f_LoadResultados()" style="zoom: 80%">
        <div class="container body">
            <div class="main_container">
                <?php include('partes/sidebar.php'); ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <!-- <div class=""> -->
                    <!-- <form action="uploadimage.php" method="post" enctype="multipart/form-data"> -->
                    <div class="row">
                        <div class="col-md-12 col-sm-12 col-xs-12">
                            <div class="x_panel">
                                <div class="x_title">
                                    <h2>
                                        <b>Administración de Clientes</b>
                                    </h2>

                                    <div class="clearfix">
                                    </div>
                                </div>

                                <div class="x_content">
                                    <p>
                                        En esta opción usted podrá: <b>Crear, Editar y Eliminar </b>toda la información de sus clientes.
                                    </p>

                                    <br/>

                                    <!-- Tabla de Estructura de Presentación -->
                                    <div class="x_panel" style="border: solid; border-width: 1px; border-color: #E6E9ED; border-radius: 7px;">
                                        <div class="x_title">
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <h2>
                                                    Lista de Clientes
                                                </h2>
                                            </div>

                                            <div class="col-md-6 col-sm-6 col-xs-12" style="text-align: right;">
                                                <button class="btn btn-primary" type="button" onclick="f_AdminClientes('x')">
                                                    Agregar Cliente
                                                </button>
                                            </div>

                                            <div class="clearfix">
                                            </div>
                                        </div>

                                        <div class="x_content">
                                            <div class="col-md-4 col-sm-4 col-xs-12">
                                                
                                            </div>
                                            <div class="col-md-4 col-sm-4 col-xs-12">
                                                
                                            </div>
                                            <div class="col-md-4 col-sm-4 col-xs-12" style="margin-top: -10px; margin-bottom: 5px; border: solid; border-width: 1px; border-color: #E6E9ED; border-radius: 7px; background-color: #D4DBF5; height: 45px; padding-top: 4px;">
                                                <!-- <label class="control-label col-md-3 col-sm-3 col-xs-3" style="margin-top: 7px; text-align: right; color: #ffffff">
                                                    Buscar:
                                                </label> -->
                                                <input id="_SwitchBuscar" type="checkbox" checked data-toggle="toggle" data-on="Nombres" data-off="RUC" data-onstyle="primary" data-offstyle="warning" data-width="110">
                                                <div class="col-md-8 col-sm-8 col-xs-8">
                                                    <input type="text" id="txt_buscar" placeholder="Ingrese una búsqueda" class="form-control col-md-5 col-xs-12" onkeyup="f_FindUsuarios()">
                                                </div>
                                            </div>

                                            <table class="table table-striped jambo_table bulk_action">
                                                <thead>
                                                    <tr Style="font-size: 12px">
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Item</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Tipo Cliente</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Tipo Documento</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>DNI / RUC</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Nombres</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Teléfono 1</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Teléfono 2</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Correo</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Estado</center></th>
                                                        <th style="border: solid; border-width: 1px; border-color: #E6E9ED; vertical-align: middle;"><center>Dirección</center></th>
                                                        <th style="background-color: #B58260; width: 8%; vertical-align: middle;"><center>Acciones</center></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="tbl_Clientes">

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- ************************************** Ventanas modal ************************************** -->
            <!-- Waiting Loading -->
            <div id="divmodal_Loading" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false" style="margin-top: 300px;">
                <div class="modal-dialog" style="height: 200px; opacity: 0.5;"><center>
                    <img src="images/loading.gif" width="200px" style="border: solid; border-width: 1px; border-color: #D9D9D9;  border-radius: 15px;"></img>
                </center></div>
            </div>

            <!-- Administrar Clientes (Nuevo y Editar) -->
            <div id="divmodal_AddNewCliente" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false">
                <div class="modal-dialog" style="width: 40%; margin-top: 12%; margin-left: 30%">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">
                                &times;
                            </button>

                            <h4 class="modal-title" id="titulomodal_Clientes"><b>
                                Registro de nuevo Cliente
                            </b></h4>
                        </div>

                        <div class="modal-body">
                            <form class="form-horizontal form-label-left">
                                <div class="row">
                                    <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                        <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                            Tipo Cliente
                                        </label>
                                        <div class="col-md-7 col-sm-7 col-xs-12">
                                            <select id="lista_tipocliente" class="form-control" required>
                                                <option selected = "true" value="">Elija una opción...</option>

                                                <?php
                                                    $c = 1;

                                                    $q_TipoCliente = "SELECT idTipoCliente,
                                                                             cDescripcionTipoCliente
                                                                        FROM TipoCliente
                                                                       WHERE idTipoCliente IN (3, 4)";

                                                    if ($res_TipoCliente = sqlsrv_query($enlacehost, $q_TipoCliente)) {
                                                        while($row_TipoCliente = sqlsrv_fetch_array($res_TipoCliente)) {
                                                             echo '<option value="'.$row_TipoCliente["idTipoCliente"].'">'.$row_TipoCliente["cDescripcionTipoCliente"].'</option>';

                                                             $c += 1;
                                                        }
                                                    }
                                                ?>

                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                        <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                            Tipo Documento
                                        </label>
                                        <div class="col-md-7 col-sm-7 col-xs-12">
                                            <select id="lista_tipodocumento" class="form-control" required>
                                                <option selected = "true" value="">Elija una opción...</option>

                                                <?php
                                                    $c = 1;

                                                    $q_TipoDocumento = "SELECT  iIdTipoDocumento,
                                                                                cDescripcionCorta
                                                                          FROM  TipodeDocumento
                                                                         WHERE  iIdTipoDocumento IN (100, 102)";

                                                    if ($res_TipoDocumento = sqlsrv_query($enlacehost, $q_TipoDocumento)) {
                                                        while($row_TipoDocumento = sqlsrv_fetch_array($res_TipoDocumento)) {
                                                             echo '<option value="'.$row_TipoDocumento["iIdTipoDocumento"].'">'.$row_TipoDocumento["cDescripcionCorta"].'</option>';

                                                             $c += 1;
                                                        }
                                                    }
                                                ?>

                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                        <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                            DNI / RUC
                                        </label>
                                        <div class="col-md-7 col-sm-7 col-xs-12">
                                            <input type="number" class="form-control col-md-12 col-xs-12" id="cliente_dni" style="text-align: right;"/>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                        <label style="cursor: pointer; margin-top: 7px; margin-left: -10px; color: #337ab7;" onclick="f_GetSunat()"><u>
                                            Importar desde SUNAT
                                        </u></label>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                        <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-left: 25px">
                                            Nombres
                                        </label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                            <input type="text" class="form-control col-md-12 col-xs-12" id="cliente_nombre"/>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                        <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                            Teléfono 1
                                        </label>
                                        <div class="col-md-7 col-sm-7 col-xs-12">
                                            <input type="number" class="form-control col-md-12 col-xs-12" id="cliente_telefono1" style="text-align: right;"/>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">
                                            Teléfono 2
                                        </label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                            <input type="text" class="form-control col-md-12 col-xs-12" id="cliente_telefono2" style="text-align: right;"/>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                        <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-left: 25px">
                                            Correo
                                        </label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                            <input type="text" class="form-control col-md-12 col-xs-12" id="cliente_correo" placeholder="Ejemplo: correo1@xxxx.com; correo2@yyyy.com" />
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                        <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-left: 25px">
                                            Dirección
                                        </label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                            <input type="text" class="form-control col-md-12 col-xs-12" id="cliente_direccion" />
                                        </div>
                                    </div>
                                </div>

                                <br/>

                                <div class="ln_solid"></div>

                                <!-- Campos usados al momento de grabar los datos -->
                                <input id="id_cliente" type="hidden">
                                <input id="modo_grabar" type="hidden">

                                <div class="form-group"><center>
                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                        <button class="btn btn-dark" type="button" onclick="f_cerrarModal(1)">
                                            Cancelar
                                        </button>
                                        <button class="btn btn-success" type="button" onclick="f_GrabarNewCliente()">
                                            Grabar
                                        </button>
                                    </div>
                                </center></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Show clave generada -->
            <div id="divmodal_ClaveCliente" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false">
                <div class="modal-dialog" style="width: 35%; margin-top: 12%; margin-left: 30%">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">
                                &times;
                            </button>

                            <h4 class="modal-title" id="titulomodal_ClaveClientes"><b>
                                Clave generada para
                            </b></h4>
                        </div>

                        <div class="modal-body">
                            <form class="form-horizontal form-label-left">
                                <div class="row" style="margin-top: 10px;">
                                    <div class="form-group col-md-12 col-sm-6 col-xs-12">
                                        <label class="control-label col-md-5 col-sm-5 col-xs-12">
                                            La nueva clave generada es:
                                        </label>
                                        <div class="col-md-6 col-sm-6 col-xs-12">
                                            <input type="text" id="txt_clave" class="form-control col-md-5 col-xs-12" style="text-align: center; font-size: 24px; color: #02732A" readonly>
                                            <label style="color: red">* Comparta esta clave con el cliente</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="ln_solid"></div>

                                <div class="form-group"><center>
                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                        <button class="btn btn-dark" type="button" onclick="f_cerrarModal(2)" style="background-color: #337ab7">
                                            Aceptar
                                        </button>
                                    </div>
                                </center></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <!-- ******************************************************************************************** -->

        <!-- jQuery -->
        <script src="../vendors/jquery/dist/jquery.min.js"></script>
        <!-- Bootstrap -->
        <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- FastClick -->
        <script src="../vendors/fastclick/lib/fastclick.js"></script>
        <!-- NProgress -->
        <script src="../vendors/nprogress/nprogress.js"></script>
        <!-- Chart.js -->
        <script src="../vendors/Chart.js/dist/Chart.min.js"></script>
        <!-- gauge.js -->
        <script src="../vendors/gauge.js/dist/gauge.min.js"></script>
        <!-- bootstrap-progressbar -->
        <script src="../vendors/bootstrap-progressbar/bootstrap-progressbar.min.js"></script>
        <!-- iCheck -->
        <script src="../vendors/iCheck/icheck.min.js"></script>
        <!-- Skycons -->
        <script src="../vendors/skycons/skycons.js"></script>
        <!-- Flot -->
        <script src="../vendors/Flot/jquery.flot.js"></script>
        <script src="../vendors/Flot/jquery.flot.pie.js"></script>
        <script src="../vendors/Flot/jquery.flot.time.js"></script>
        <script src="../vendors/Flot/jquery.flot.stack.js"></script>
        <script src="../vendors/Flot/jquery.flot.resize.js"></script>
        <!-- Flot plugins -->
        <script src="../vendors/flot.orderbars/js/jquery.flot.orderBars.js"></script>
        <script src="../vendors/flot-spline/js/jquery.flot.spline.min.js"></script>
        <script src="../vendors/flot.curvedlines/curvedLines.js"></script>
        <!-- DateJS -->
        <script src="../vendors/DateJS/build/date.js"></script>
        <!-- JQVMap -->
        <script src="../vendors/jqvmap/dist/jquery.vmap.js"></script>
        <script src="../vendors/jqvmap/dist/maps/jquery.vmap.world.js"></script>
        <script src="../vendors/jqvmap/examples/js/jquery.vmap.sampledata.js"></script>
        <!-- bootstrap-daterangepicker -->
        <script src="../vendors/moment/min/moment.min.js"></script>
        <script src="../vendors/bootstrap-daterangepicker/daterangepicker.js"></script><!-- Datatables -->
        <script src="../vendors/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="../vendors/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
        <script src="../vendors/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
        <script src="../vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js"></script>
        <script src="../vendors/datatables.net-buttons/js/buttons.flash.min.js"></script>
        <script src="../vendors/datatables.net-buttons/js/buttons.html5.min.js"></script>
        <script src="../vendors/datatables.net-buttons/js/buttons.print.min.js"></script>
        <script src="../vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js"></script>
        <script src="../vendors/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
        <script src="../vendors/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
        <script src="../vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js"></script>
        <script src="../vendors/datatables.net-scroller/js/dataTables.scroller.min.js"></script>
        <script src="../vendors/jszip/dist/jszip.min.js"></script>
        <script src="../vendors/pdfmake/build/pdfmake.min.js"></script>
        <script src="../vendors/pdfmake/build/vfs_fonts.js"></script>

        <!-- Toggle Switch -->
        <script src="bootstrap/js/bootstrap4-toggle.min.js"></script>

        <!-- Custom Theme Scripts -->
        <script src="../build/js/custom.min.js"></script>

        <!-- Funciones Principales -->
        <script type="text/javascript">
            // Cargando Resultados
            function f_LoadResultados(){
                var htmlContenido = '';
                var compania = <?php echo $_SESSION["bdOmar_Compania"]; ?>;

                var bk_color = '';
                var estado = '';
                var href_estado = '';
                var href_color = '';
                var href_icon = '';

                // Loading Modal
                    var modal_loading = $("#divmodal_Loading");
                    modal_loading.modal({backdrop: 'static', keyboard: false});

                // Carga resultados
                    var c = 1;
                    var _visible = 0;

                    $("#tbl_Clientes").html(htmlContenido);

                    $.post( "ajax/encuesta.php", { accion: "Get_Clientes", idCompany: compania, tipo_filtro: 0, filtro: '', admin_clientes: 1 },
                        function( data ) {
                            if(data.estado == 1){
                                $.each( data.registros, function( key, val ) {
                                    htmlContenido += '<tr>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; text-align: right">' + c + '</td>';
                                    
                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.TIPO_CLIENTE;
                                    htmlContenido += '  </td>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.TIPO_DOCUMENTO;
                                    htmlContenido += '  </td>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.cNumeroRuc;
                                    htmlContenido += '  </td>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.cRazonSocial;
                                    htmlContenido += '  </td>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.cNumeroTelefono;
                                    htmlContenido += '  </td>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.cSegundoNumeroTelefono;
                                    htmlContenido += '  </td>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.cEmail;
                                    htmlContenido += '  </td>';

                                    if (val.cEstado_Eliminado == 'I'){
                                        bk_color = '#E6A50D';
                                        estado = 'Inactivo';
                                        href_estado = 'Activar';
                                        href_color = '#038C8C';
                                        href_icon = 'fa fa-plus-circle';
                                    }
                                    else{
                                        bk_color = '#038C8C';
                                        estado = 'Activo';
                                        href_estado = 'Inactivar';
                                        href_color = '#E6A50D';
                                        href_icon = 'fa fa-minus-circle';
                                    }

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; background-color: ' + bk_color + '; color: #ffffff; text-align: center;">';
                                    htmlContenido += '      ' + estado;
                                    htmlContenido += '  </td>';

                                    htmlContenido += '  <td style="border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;">';
                                    htmlContenido += '      ' + val.cDireccion;
                                    htmlContenido += '  </td>';

                                    // Agregando acciones
                                        htmlContenido += '  <td>';

                                        htmlContenido += '      <a class="success" href="javascript: f_AdminClientes(' + c + ', ' + val.iIdCliente + ', ' + val.iTipoCliente + ', ' + val.Id_Tipo_Documento + ", '" + val.cNumeroRuc.trim() + "', '" + val.cRazonSocial.trim() + "', '" + val.cNumeroTelefono.trim() + "', '" + val.cSegundoNumeroTelefono.trim() + "', '" + val.cEmail.trim() + "', '" + val.cDireccion.trim() + "'" + ')"><i class="fa fa-edit"></i><font color=#337ab7>';
                                        htmlContenido += '          Editar';
                                        htmlContenido += '      </a>';

                                        htmlContenido += '<br>';

                                        htmlContenido += '      <a class="success" href="javascript: f_CambiarEstado(' + "'" + href_estado.substring(0, 1) + "', " + val.iIdCliente + ')"><i class="' + href_icon + '"></i><font color=' + href_color + '>';
                                        htmlContenido += '          ' + href_estado;
                                        htmlContenido += '      </a>';

                                        htmlContenido += '<br>';

                                        htmlContenido += '      <a class="success" href="javascript: f_EliminarCliente(' + val.iIdCliente + ')"><i class="fa fa-times-circle"></i><font color=#F20505>';
                                        htmlContenido += '          Eliminar';
                                        htmlContenido += '      </a>';

                                        htmlContenido += '<br>';

                                        htmlContenido += '      <a class="success" href="javascript: f_GenerarClaveCliente(' + val.iIdCliente + ", '" + val.cRazonSocial.trim() + "'" + ')"><i class="fa fa-magic"></i><font color=#038C8C>';
                                        htmlContenido += '          Generar Clave';
                                        htmlContenido += '      </a>';

                                        htmlContenido += '  </td>';

                                    htmlContenido += "</tr>";

                                    c += 1;
                                });
                            }
                            else{
                                alert("No se encontraron resultados para la búsqueda solicitada");
                            }

                            // Cerrando Modal
                                $('#divmodal_Loading').modal('hide');

                            $("#tbl_Clientes").html(htmlContenido);
                        }, "json");
            };

            function f_GrabarNewCliente(){
                var compania = <?php echo $_SESSION["bdOmar_Compania"]; ?>;
 
                var modo_grabar = $("#modo_grabar").val();
                var id_cliente = $("#id_cliente").val();

                var lista_tipocliente = $("#lista_tipocliente").val();
                var lista_tipodocumento = $("#lista_tipodocumento").val();
                var cliente_dni = $("#cliente_dni").val();
                var cliente_nombre = $("#cliente_nombre").val().trim();
                var cliente_telefono1 = $("#cliente_telefono1").val();
                var cliente_telefono2 = $("#cliente_telefono2").val().trim();
                var cliente_correo = $("#cliente_correo").val().trim();
                var cliente_direccion = $("#cliente_direccion").val().trim();

                // Validando ingreso de datos
                    if (lista_tipocliente == null){
                        alert("Debe seleccionar el Tipo de Cliente");

                        return;
                    }
                    if (lista_tipocliente.length == 0){
                        alert("Debe seleccionar el Tipo de Cliente");

                        return;
                    }

                    if (lista_tipodocumento == null){
                        alert("Debe seleccionar el Tipo de Documento");

                        return;
                    }
                    if (lista_tipodocumento.length == 0){
                        alert("Debe seleccionar el Tipo de Documento");

                        return;
                    }

                    if (cliente_dni == null){
                        alert("Debe ingresar el DNI / RUC del Cliente");

                        return;
                    }
                    if (cliente_dni.length == 0){
                        alert("Debe ingresar el DNI / RUC del Cliente");

                        return;
                    }
                    if (cliente_dni == 0){
                        alert("Debe ingresar un DNI / RUC del válido");

                        return;
                    }

                    if (cliente_nombre == null){
                        alert("Debe ingresar el Nombre del Cliente");

                        return;
                    }
                    if (cliente_nombre.length == 0){
                        alert("Debe ingresar el Nombre del Cliente");

                        return;
                    }
                    if (cliente_nombre.indexOf('"') >= 0){
                        alert("No se puede utilizar COMILLAS en el Nombre del Cliente." + "\r\n" + "Por favor, corregir.");

                        return;
                    }
                    if (cliente_nombre.indexOf("'") >= 0){
                        alert("No se puede utilizar COMILLAS SIMPLES en el Nombre del Cliente." + "\r\n" + "Por favor, corregir.");

                        return;
                    }

                    if (cliente_telefono1 == null){
                        alert("Debe ingresar por lo menos el primer número de Teléfono");

                        return;
                    }
                    if (cliente_telefono1.length == 0){
                        alert("Debe ingresar por lo menos el primer número de Teléfono");

                        return;
                    }
                    if (cliente_telefono1 == 0){
                        alert("Debe ingresar un número de Teléfono correcto");

                        return;
                    }

                    if (cliente_correo == null){
                        alert("Debe ingresar por lo menos un correo electrónico");

                        return;
                    }
                    if (cliente_correo.length == 0){
                        alert("Debe ingresar por lo menos un correo electrónico");

                        return;
                    }

                    if (cliente_direccion == null){
                        alert("Debe ingresar la dirección del Cliente");

                        return;
                    }
                    if (cliente_direccion.length == 0){
                        alert("Debe ingresar la dirección del Cliente");

                        return;
                    }

                // Loading Modal
                    var modal_loading = $("#divmodal_Loading");
                    modal_loading.modal({backdrop: 'static', keyboard: false});

                // Grabando Cliente
                    $.post( "ajax/encuesta.php", { accion: "Grabar_Cliente", modo_grabar: modo_grabar, id_cliente: id_cliente, tipo_cliente: lista_tipocliente, tipo_documento: lista_tipodocumento, razon_social: cliente_nombre, dni_ruc: cliente_dni, eMail: cliente_correo, num_telefono1: cliente_telefono1, num_telefono2: cliente_telefono2, idCompany: compania, direccion: cliente_direccion },
                        function( data ) {
                            if (data.estado == 2){
                                alert("El DNI / RUC ingresado ya fue registrado anteriormente, por favor verificar");

                                // Cerrando Modal
                                    $('#divmodal_Loading').modal('hide');

                                return;
                            }
                            else{
                                if(data.estado == 1){
                                    f_LoadResultados();

                                    f_cerrarModal(1);
                                }
                                else{
                                    alert("Ocurrió un error al momento de grabar el nuevo Cliente");
                                }
                            }

                            // Cerrando Modal
                                $('#divmodal_Loading').modal('hide');

                        }, "json");
            };

            function f_CambiarEstado(_Estado, _id_cliente){
                var estado = ((_Estado == 'I') ? 'inactivar' : 'activar');

                if(confirm("¿Está seguro de " + estado + " el cliente seleccionado?")){
                    $.post( "ajax/encuesta.php", { accion: "CambiarEstado_Cliente", id_cliente: _id_cliente, estado: _Estado }, 
                        function( data ) {
                            if(data.estado == 1){
                                f_LoadResultados();

                                alert("El estado del cliente fue cambiado satisfactoriamente");
                            }
                            else{
                                alert("Ocurrió un error al momento de cambiar el estado");
                            }
                        }, "json");
                }
            };

            function f_EliminarCliente(_id_cliente){
                if(confirm("¿Está seguro de eliminar el cliente seleccionado?\n\nSi continua perderá la información permanentemente. ¿Desea continuar?")){
                    $.post( "ajax/encuesta.php", { accion: "Eliminar_Cliente", id_cliente: _id_cliente },
                        function( data ) {
                            if(data.estado == 1){
                                f_LoadResultados();

                                alert("El cliente fue eliminado satisfactoriamente");
                            }
                            else{
                                alert("Ocurrió un error al momento de eliminar el cliente");
                            }
                        }, "json");
                }
            };

            function f_GetSunat(){
                var ruc = $("#cliente_dni").val();
                var url = "http://ventas.mbsoftperu.com/App/api/ConsultaRuc/";

                // Validando datos
                    if (ruc == null){
                        alert("Debe ingresar el DNI/RUC del cliente");

                        return;
                    }
                    if (ruc.length == 0){
                        alert("Debe ingresar el DNI/RUC del cliente");

                        return;
                    }

                // Loading Modal
                    var modal_loading = $("#divmodal_Loading");
                    modal_loading.modal({backdrop: 'static', keyboard: false});

                // Obteniendo datos
                    $.post( "ajax/encuesta.php", { accion: "Get_ClienteSunat", ruc: ruc },
                        function( data ) {
                            $("#cliente_nombre").val(data.denominacion.trim());
                            $("#cliente_direccion").val(data.direccion.trim());

                            // Cerrando Modal
                                $('#divmodal_Loading').modal('hide');
                        }, "json");

            }

            // Seteando ventanas modales =================================================================================
            // ===========================================================================================================
                function f_AdminClientes(_item, _id_cliente, _cod_tipoclliente, _cod_tipodocumento, _dniruc, _nombres, _tel1, _tel2, _correo, _direccion){
                    var modal = $("#divmodal_AddNewCliente");

                    // Definiendo título de ventana e Inicilizando controles de tipo texto
                        if (_item != 'x'){
                            tipo = "E";
                            titulo = 'Editar Cliente: "<b>'+_nombres+'</b>"';
                        }
                        else{
                            tipo = "N";
                            titulo = "Nuevo Cliente";
                        }

                    // Colocando el título a la pantalla
                        $("#titulomodal_Clientes").html(titulo);

                    // Identificando el tipo de grabación
                        $("#modo_grabar").val(tipo);

                    // Cargando datos
                        if (_item != 'x'){
                            $("#id_cliente").val(_id_cliente);
                            $("#lista_tipocliente").val(_cod_tipoclliente);
                            $("#lista_tipodocumento").val(_cod_tipodocumento);
                            $("#cliente_dni").val(_dniruc);
                            $("#cliente_nombre").val(_nombres);
                            $("#cliente_telefono1").val(_tel1);
                            $("#cliente_telefono2").val(_tel2);
                            $("#cliente_correo").val(_correo);
                            $("#cliente_direccion").val(_direccion);
                        }
                        else{
                            $("#id_cliente").val('');
                            $("#lista_tipocliente").val('');
                            $("#lista_tipodocumento").val('');
                            $("#cliente_dni").val('');
                            $("#cliente_nombre").val('');
                            $("#cliente_telefono1").val('');
                            $("#cliente_telefono2").val('');
                            $("#cliente_correo").val('');
                            $("#cliente_direccion").val('');
                        }

                    modal.modal({backdrop: 'static', keyboard: false});
                }

                function f_AsignartipoCheckList(_cod_proyecto, _des_proyecto){
                    var modal = $("#divmodal_AsignarTipoCheckList");
                    var titulo = '';

                    $("#titulomodal").val(_des_proyecto);
                    $("#cod_proyectox").val(_cod_proyecto);

                    // Colocando el título a la pantalla
                        $("#titulomodal_AsignarTipoCheckList").html('Asignar encuestas para el proyecto: "<b>'+_des_proyecto+'</b>"');

                    //Cargando la tabla de resultados
                        var htmlContenido = "<thead>";
                        htmlContenido += '  <tr Style="font-size: 12px">';
                        htmlContenido += "      <th><center>Item</center></th>";
                        htmlContenido += "      <th><center>Tipo CheckList</center></th>";
                        htmlContenido += '      <th><center>Acciones</center></th>';
                        htmlContenido += "  </tr>";
                        htmlContenido += "</thead>";
                        htmlContenido += "<tbody>";

                        var i = 1;

                        $("#tabla_TipoCheckList").html(htmlContenido);

                        $.post( "ajax/encuesta.php", { accion: "cargaListaTiposCheckListAsignados", cod_proyecto: _cod_proyecto }, 
                            function( data ) {
                                if(data.estado == 1){
                                    $.each( data.registros, function( key, val ) {
                                        htmlContenido += '<tr Style="font-size: 12px">';
                                        htmlContenido += "  <td><center>"+i+"</center></td>";
                                        htmlContenido += "  <td>"+val.nom_tipochecklist+"</td>";

                                        // Asignando Acciones
                                        htmlContenido += "  <td><center>";
                                        htmlContenido += '      <a class="success" href="javascript: f_DeleteAsignarTipoCheckList('+val.Id+', '+val.tipo_checklist+')"><i class="fa fa-minus-circle"></i><font color=#d9534f> Eliminar</a>';

                                        htmlContenido += "  </center></td>";

                                        htmlContenido += "</tr>";

                                        i += 1;
                                    });
                                }

                                $("#tabla_TipoCheckList").html(htmlContenido);
                            }, "json");

                    // Carga lista de Tipo de CheckList
                        var htmlContenido2 = "";

                        $("#lista_TiposCheckList").html(htmlContenido2);

                        $.post( "ajax/encuesta.php", { accion: "cargaListaTiposCheckListPorProyectosNotIn", cod_proyecto: _cod_proyecto }, 
                            function( data ) {
                                if(data.estado == 1){
                                  var htmlContenido2 = '<option selected = "true" value="">Elija una opción...</option>';

                                  $.each( data.registros, function( key, val ) {
                                    htmlContenido2 += '<option value="'+val.Id+'">'+val.nom_tipochecklist+'</option>';
                                  });
                                }

                                $("#lista_TiposCheckList").html(htmlContenido2);
                            }, "json");

                    modal.modal({backdrop: 'static', keyboard: false});

                    // Cerrando contenedor de Asignación
                        var _div = document.getElementById('mostrar_AsignarTipoCheckList');
                        _div.style.display = 'none';
                }

                function f_GenerarClaveCliente(_id_cliente, _nom_cliente){
                    if(confirm("¿Está seguro de crear una nueva clave para el cliente seleccionado?")){
                        var modal = $("#divmodal_ClaveCliente");

                        // Loading Modal
                            var modal_loading = $("#divmodal_Loading");
                            modal_loading.modal({backdrop: 'static', keyboard: false});

                        $.post( "ajax/encuesta.php", { accion: "UpdateClave_Cliente", id_cliente: _id_cliente },
                            function( data ) {
                                if(data.estado != 0){
                                    $("#titulomodal_ClaveClientes").html("Clave generada para: <b>" + _nom_cliente + "</b>");
                                    $("#txt_clave").val(data.estado);

                                    modal.modal({backdrop: 'static', keyboard: false});
                                }
                                else{
                                    alert("Ocurrió un error al momento de generar la clave");
                                }

                                // Cerrando Modal
                                    $('#divmodal_Loading').modal('hide');
                            }, "json");

                    }
                }
            // ===========================================================================================================

            // Cerrar ventanas modales
            function f_cerrarModal(pantalla_modal){
                if (pantalla_modal == 1){
                    $('#divmodal_AddNewCliente').modal('hide');
                }

                if (pantalla_modal == 2){
                    $('#divmodal_ClaveCliente').modal('hide');
                }
            };
        </script>

        <!-- Funciones Secundarias -->
        <script type="text/javascript">
            function f_FindUsuarios(){
                // Declare variables
                var input, filter, table, tr, td, i, txtValue;

                input = document.getElementById("txt_buscar");
                table = document.getElementById("tbl_Clientes");

                filter = input.value.toUpperCase();

                tr = table.getElementsByTagName("tr");

                // Loop through all table rows, and hide those who don't match the search query
                    for (i = 0; i < tr.length; i++) {
                        // Determina la búsqueda
                            if (document.getElementById('_SwitchBuscar').checked){
                                td = tr[i].getElementsByTagName("td")[4];
                            }
                            else{
                                td = tr[i].getElementsByTagName("td")[3];
                            }

                        if (td) {
                            txtValue = td.textContent || td.innerText;

                            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                            } else {
                                tr[i].style.display = "none";
                            }
                        }
                    }
            }
        </script>
    </body>
</html>

<?php
cerrarSesion($enlace);
?>