<?php
    session_start();
    include('../../php/conn.php');

    if(!isset($_SESSION["id"])){
      header('Location: index.php');
    }

    // Obtiene los datos para exportar a Excel
    if(isset($_GET["export_data"])){
        $cod_cliente = $_GET["v_filter_cliente"];
        $cod_encuesta = $_GET["v_filter_encuesta"];

        // $query = "SELECT E.nom_encuesta, U.date_ubicacion, U.token, U.lat_ubicacion, U.lon_ubicacion, US.usu_usuario AS cod_usuario, CONCAT_WS(  ' ', US.nom_persona, ape_persona ) AS nom_usuario, cor_persona AS correo_usuario FROM tb_ubicacion U LEFT JOIN tb_encuesta E ON U.cod_encuesta = E.cod_encuesta LEFT JOIN tb_usuario US ON U.usu_ubicacion = US.cod_usuario WHERE token <> '' AND lat_ubicacion <> 0 AND U.cod_encuesta = '".$cod_encuesta."' ORDER BY U.date_ubicacion DESC";

        $query = "SELECT E.nom_encuesta, U.date_ubicacion, U.token, U.lat_ubicacion, U.lon_ubicacion, US.usu_usuario AS cod_usuario, CONCAT_WS( ' ', US.nom_persona, ape_persona ) AS nom_usuario, cor_persona AS correo_usuario FROM tb_ubicacion U LEFT JOIN tb_encuesta E ON U.cod_encuesta = E.cod_encuesta LEFT JOIN tb_usuario US ON U.usu_ubicacion = US.cod_usuario WHERE token <> '' AND U.cod_encuesta = '".$cod_encuesta."' GROUP BY E.nom_encuesta, U.date_ubicacion, U.token, U.lat_ubicacion, U.lon_ubicacion, US.usu_usuario, CONCAT_WS(  ' ', US.nom_persona, ape_persona ), cor_persona ORDER BY U.date_ubicacion DESC";

        $resultado = mysqli_query($enlace, $query);

        $libros = array();
        while($rows = mysqli_fetch_assoc($resultado)) {
            $libros[] = $rows;
        }

        // Exportando a Excel
            if(!empty($libros)) {
                $filename = "resultados_encuestasgps.xls";
                header("Content-Type: application/vnd.ms-excel");
                header("Content-Disposition: attachment; filename=".$filename);

                $mostrar_columnas = false;

                foreach($libros as $libro) {
                if(!$mostrar_columnas) {
                echo implode("\t", array_keys($libro)) . "\n";
                $mostrar_columnas = true;
                }
                echo implode("\t", array_values($libro)) . "\n";
                }

            }
            else{
            echo 'No hay datos a exportar';
            }
            exit;
    }
?>
<!DOCTYPE html>
<html lang="es">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="icon" href="images/favicon.ico" type="image/ico" />

    <title>Sistema Encuestas | </title>

    <!-- Bootstrap -->
    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <!-- NProgress -->
    <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
    <!-- iCheck -->
    <link href="../vendors/iCheck/skins/flat/green.css" rel="stylesheet">
	
    <!-- bootstrap-progressbar -->
    <link href="../vendors/bootstrap-progressbar/css/bootstrap-progressbar-3.3.4.min.css" rel="stylesheet">
    <!-- JQVMap -->
    <link href="../vendors/jqvmap/dist/jqvmap.min.css" rel="stylesheet"/>
    <!-- bootstrap-daterangepicker -->
    <link href="../vendors/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">

    <!-- Custom Theme Style -->
    <link href="../build/css/custom.min.css" rel="stylesheet">

    <style>
      /* Always set the map height explicitly to define the size of the div
       * element that contains the map. */
      #map {
        height: 100%;
        width: 100%;
      }
      /* Optional: Makes the sample page fill the window. */
      .map {
        height: 500px;
        margin: 0;
        padding: 0;
      }
    </style>
  </head>

  <body class="nav-md" onload="f_cargacliente()">
    <div class="container body">
      <div class="main_container">
        <?php include('partes/sidebar.php'); ?>  
        <!-- page content -->
        <div class="right_col" role="main">
          <!-- top tiles -->
          <div class="row map">

            <!-- Filtros -->
                <div class="x_panel">
                    <div class="x_title">
                        <h2>
                            Filtros
                        </h2>
                        <div class="clearfix">
                        </div>
                    </div>
                    <div class="x_content">
                        <form class="form-horizontal form-label-left input_mask">
                            <div class="col-md-1 col-sm-1 col-xs-12 form-group">
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12 form-group">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12">
                                    Cliente
                                </label>
                                <div class="col-md-9 col-sm-9 col-xs-12">
                                    <select class="form-control" id="filter_cliente" name='v_filter_cliente' onchange="f_cargaencuestas();" style="font-size: 12px; padding: 2px">
                                        
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12 form-group">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12">
                                    Encuesta
                                </label>
                                <div class="col-md-9 col-sm-9 col-xs-12">
                                    <select class="form-control" id="filter_encuesta" name='v_filter_encuesta' style="font-size: 12px; padding: 2px">

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-3 col-xs-12 form-group">
                                <button type="submit" class="btn btn-primary">
                                    Filtrar
                                </button>
                                <button type="submit" class="btn btn-success" name="export_data">
                                    Exportar a Excel
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

            <div id="map" style="height: 95%">
                
            </div>
          
          </div>
          <!-- /top tiles -->
        </div>
        <!-- /page content -->
      </div>
    </div>

    <!-- jQuery -->
    <script src="../vendors/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap -->
    <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- FastClick -->
    <script src="../vendors/fastclick/lib/fastclick.js"></script>
    <!-- NProgress -->
    <script src="../vendors/nprogress/nprogress.js"></script>
    <!-- Chart.js -->
    <script src="../vendors/Chart.js/dist/Chart.min.js"></script>
    <!-- gauge.js -->
    <script src="../vendors/gauge.js/dist/gauge.min.js"></script>
    <!-- bootstrap-progressbar -->
    <script src="../vendors/bootstrap-progressbar/bootstrap-progressbar.min.js"></script>
    <!-- iCheck -->
    <script src="../vendors/iCheck/icheck.min.js"></script>
    <!-- Skycons -->
    <script src="../vendors/skycons/skycons.js"></script>
    <!-- Flot -->
    <script src="../vendors/Flot/jquery.flot.js"></script>
    <script src="../vendors/Flot/jquery.flot.pie.js"></script>
    <script src="../vendors/Flot/jquery.flot.time.js"></script>
    <script src="../vendors/Flot/jquery.flot.stack.js"></script>
    <script src="../vendors/Flot/jquery.flot.resize.js"></script>
    <!-- Flot plugins -->
    <script src="../vendors/flot.orderbars/js/jquery.flot.orderBars.js"></script>
    <script src="../vendors/flot-spline/js/jquery.flot.spline.min.js"></script>
    <script src="../vendors/flot.curvedlines/curvedLines.js"></script>
    <!-- DateJS -->
    <script src="../vendors/DateJS/build/date.js"></script>
    <!-- JQVMap -->
    <script src="../vendors/jqvmap/dist/jquery.vmap.js"></script>
    <script src="../vendors/jqvmap/dist/maps/jquery.vmap.world.js"></script>
    <script src="../vendors/jqvmap/examples/js/jquery.vmap.sampledata.js"></script>
    <!-- bootstrap-daterangepicker -->
    <script src="../vendors/moment/min/moment.min.js"></script>
    <script src="../vendors/bootstrap-daterangepicker/daterangepicker.js"></script>

    <!-- Custom Theme Scripts -->
    <script src="../build/js/custom.min.js"></script>
    <script>
      function initMap() {

        var map = new google.maps.Map(document.getElementById('map'), {
          zoom: 5
          // center: {lat: -12.137224, lng: -77.020073}
          //center: {lat: -12.1213714, lng: -77.0231447}
        });

        var current_center;

<?php
    $cod_cliente = '0';
    $cod_encuesta = '0';

    header('Location: show-map.php');

    // Recupera el código de Encuesta
        if(isset($_GET["v_filter_encuesta"])){
            $cod_cliente = $_GET["v_filter_cliente"];
            $cod_encuesta = $_GET["v_filter_encuesta"];

            header('Location: show-map.php');
        }

if ($resultado = mysqli_query($enlace, "SELECT U.cod_ubicacion, U.cod_encuesta, U.usu_ubicacion, U.lat_ubicacion, U.lon_ubicacion, U.date_ubicacion, E.nom_encuesta AS surveyls_title, us.cod_usuario, us.usu_usuario, us.nom_persona, us.ape_persona, us.cor_persona, us.tel_persona, U.token FROM tb_ubicacion U INNER JOIN tb_usuario AS us ON U.usu_ubicacion=us.cod_usuario INNER JOIN tb_encuesta E ON U.cod_encuesta = E.cod_encuesta WHERE U.cod_encuesta='".$cod_encuesta."' AND U.token <> '' AND U.lat_ubicacion <> 0")) {
  if (mysqli_num_rows($resultado) > 0) {
    while($row = mysqli_fetch_assoc($resultado)) {
?>
        /**/
        var infowindow<?php echo $row["cod_ubicacion"]; ?> = new google.maps.InfoWindow({
            content: '<div id="content" style="width: 300px;">'+
            '<div id="siteNotice"></div>'+
            '<h2 id="firstHeading" class="firstHeading">INFORMACIÓN ADICIONAL</h2>'+
            '<div id="bodyContent">'+
            '<p><b>Encuesta: </b><?php echo str_replace("_", " ", $row["surveyls_title"]); ?>' +
            '<p><b>Usuario: </b><?php echo $row["usu_usuario"]; ?>' +
            '<p><b>Nombres: </b><?php echo $row["nom_persona"]; ?>' +
            '<p><b>Apellidos: </b><?php echo $row["ape_persona"]; ?>' +
            '<p><b>Correo: </b><?php echo $row["cor_persona"]; ?>' +
            '<p><b>Token: </b><?php echo $row["token"]; ?>' +
            //'<p>Enlace <a href="https://en.wikipedia.org/w/index.php?title=Uluru&oldid=297882194">'+
            //'https://en.wikipedia.org/w/index.php?title=Uluru</a></p>'+
            '</div>'+
            '</div>'
        });

        var marker<?php echo $row["cod_ubicacion"]; ?> = new google.maps.Marker({
            position: {lat: <?php echo $row["lat_ubicacion"]; ?>, lng: <?php echo $row["lon_ubicacion"]; ?>},
            map: map,
            title: '<?php echo str_replace("_", " ", $row["surveyls_title"]); ?> <?php echo $row["date_ubicacion"]; ?>'
        });
        marker<?php echo $row["cod_ubicacion"]; ?>.addListener('click', function() {
            infowindow<?php echo $row["cod_ubicacion"]; ?>.open(map, marker<?php echo $row["cod_ubicacion"]; ?>);
        });
        /**/
        current_center = {lat: <?php echo $row["lat_ubicacion"]; ?>, lng: <?php echo $row["lon_ubicacion"]; ?>};
<?php
    }
  }
  mysqli_free_result($resultado);
}
?>
        map.setCenter(current_center);
      }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCPsGu61TWDZKpuiuCI-_DNCMzsbHeG8Pg&callback=initMap"
    async defer></script>

    <!-- Funciones adicionales  -->
    <script type="text/javascript">
        // Carga lista de Clientes
        function f_cargacliente(){
            var htmlContenido = "";
            var i = 1;

            $.post( "ajax/encuesta.php", { accion: "cargaClientes"}, 
                function( data ) {
                if(data.estado == 1){
                  var htmlContenido = '<option value="">Elija una opción...</option>';

                  $.each( data.registros, function( key, val ) {
                    // Selecciona el item por defecto según el año en curso -------------
                    // ------------------------------------------------------------------
                    var selected = '';

                    var cod_cliente = <?php echo $cod_cliente; ?>;

                    if (cod_cliente == 0 && i == 1){
                        selected = 'selected = "true"';
                    }

                    if(val.cod_cliente == cod_cliente){
                      selected = 'selected = "true"';
                    }
                    // ------------------------------------------------------------------

                    htmlContenido += '<option '+selected+' value="'+val.cod_cliente+'">'+val.nom_cliente+'</option>';

                    i += 1;
                  });
                }

                $("#filter_cliente").html(htmlContenido);

                f_cargaencuestas();
            }, "json");
        };

        // Carga lista de Encuestas
        function f_cargaencuestas(){
            var htmlContenido = "";
            var i = 1;

            // Si es la primera vez que carga la página le asignará: "xxx"
            var _cod_cliente = $("#filter_cliente").val();

            if (_cod_cliente == null){
              _cod_cliente = 'xxx';
            }

            $("#filter_encuesta").html(htmlContenido);

            $.post( "ajax/encuesta.php", { accion: "cargaEncuestasxCliente", cliente: _cod_cliente}, 
                function( data ) {
                    if(data.estado==1){
                      var htmlContenido = '<option value="">Elija una opción...</option>';

                      $.each( data.registros, function( key, val ) {
                        // Selecciona el item por defecto según el año en curso -------------
                        // ------------------------------------------------------------------
                        var selected = '';

                        var cod_cliente = <?php echo $cod_cliente; ?>;
                        var cod_encuesta = <?php echo $cod_encuesta; ?>;

                        if (cod_cliente == 0 && i == 1){
                            selected = 'selected = "true"';
                        }

                        if(val.cod_encuesta == cod_encuesta){
                          selected = 'selected = "true"';
                        }
                        // ------------------------------------------------------------------

                        htmlContenido += '<option '+selected+' value="'+val.cod_encuesta+'">'+val.nom_encuesta+'</option>';

                        i += 1;
                      });
                    }

                    $("#filter_encuesta").html(htmlContenido);
                }, "json");
        };
    </script>
	
  </body>
</html>
<?php
cerrarSesion($enlace);
?>