<?php
  
  session_start();

  include('../../php/conn.php');

  if(!isset($_SESSION["id"])){
    header('Location: index.php');
  }

  mysqli_query($enlace, "SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
  mysqli_query($enlacehost, "SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");

?>

<!DOCTYPE html>
<html lang="es">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	    <!-- Meta, title, CSS, favicons, etc. -->
	    <meta charset="utf-8">
	    <meta http-equiv="X-UA-Compatible" content="IE=edge">
	    <meta name="viewport" content="width=device-width, initial-scale=1">

	    <title>Resumen de Ventas</title>

	    <!-- Bootstrap -->
	    <link href="../vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
	    <!-- Font Awesome -->
	    <link href="../vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
	    <!-- NProgress -->
	    <link href="../vendors/nprogress/nprogress.css" rel="stylesheet">
	    <!-- iCheck -->
	    <link href="../vendors/iCheck/skins/flat/green.css" rel="stylesheet">
	    <!-- bootstrap-progressbar -->
	    <link href="../vendors/bootstrap-progressbar/css/bootstrap-progressbar-3.3.4.min.css" rel="stylesheet">
	    <!-- JQVMap -->
	    <link href="../vendors/jqvmap/dist/jqvmap.min.css" rel="stylesheet"/>
	    <!-- bootstrap-daterangepicker -->
	    <link href="../vendors/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">
	    <!-- Ion.RangeSlider -->
	    <link href="../vendors/normalize-css/normalize.css" rel="stylesheet">
	    <link href="../vendors/ion.rangeSlider/css/ion.rangeSlider.css" rel="stylesheet">
	    <link href="../vendors/ion.rangeSlider/css/ion.rangeSlider.skinFlat.css" rel="stylesheet">
	    <!-- Bootstrap Colorpicker -->
	    <link href="../vendors/mjolnic-bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css" rel="stylesheet">
	    <link href="../vendors/cropper/dist/cropper.min.css" rel="stylesheet">
	    <!-- Datatables -->
	    <link href="../vendors/datatables.net-bs/css/dataTables.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css" rel="stylesheet">
	    <link href="../vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css" rel="stylesheet">

	    <!-- bootstrap-datetimepicker -->
    	<link href="../vendors/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.css" rel="stylesheet">

    	<!-- Switchery -->
    	<link href="../vendors/switchery/dist/switchery.min.css" rel="stylesheet">

	    <!-- Custom Theme Style -->
    	<link href="../build/css/custom.min.css" rel="stylesheet">

        <script type="text/javascript">
            var total = 0;
        </script>

        <style type="text/css">
            th {
                position: sticky;
                top: 0px;
                background-color: #12537E;
            }
        </style>
	</head>

	<body class="nav-md" onload="f_LoadResultados()" style="zoom: 80%">
		<div class="container body">
      		<div class="main_container">
      			<?php include('partes/sidebar.php'); ?>

      			<!-- page content -->
        		<div class="right_col" role="main" style="width: 90%">
        			<div class="">
        				<div class="row">
        					<div class="col-md-12 col-sm-12 col-xs-12">
        						<div class="x_panel">
        							<div class="x_title">
        								<h2>
        									Resumen de Ventas
        								</h2>
        								<div class="clearfix">
        								</div>
        							</div>

        							<div class="x_content">
        								<!-- Filtros -->
        								<div class="col-md-4 col-sm-4 col-xs-12">
	        								<div class="x_panel">
												<div class="x_title">
													<h2>
														<font style="font-size: 14px"><b>Búsqueda por rango de fechas</b></font>
													</h2>
													<div class="clearfix">
													</div>
												</div>
												<div class="x_content">
													<div class="form-group col-md-6 col-sm-6 col-xs-12" style="margin-top: 9px;">
                                                        <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-top: 6px; margin-left: -20px">
                                                            Desde
                                                        </label>
                                                        <div class="col-md-10 col-sm-10 col-xs-12" style="margin-left: 20px">
                                                            <?php
	                                                            date_default_timezone_set("America/Lima"); 
	                                            				$time = date('Y-m-d');

                                                                echo '<input type="date" class="form-control col-md-12 col-xs-12" id="fecha_inicio" value="'.$time.'"/>';
                                                            ?>
                                                        </div>
                                                    </div>

                                                    <div class="form-group col-md-6 col-sm-6 col-xs-12" style="margin-top: 9px;">
                                                        <label class="control-label col-md-2 col-sm-2 col-xs-12" style="margin-top: 6px; margin-left: -20px">
                                                            Hasta
                                                        </label>
                                                        <div class="col-md-10 col-sm-10 col-xs-12" style="margin-left: 20px">
                                                            <?php
                                                                echo '<input type="date" class="form-control col-md-12 col-xs-12" id="fecha_fin" value="'.$time.'"/>';
                                                            ?>
                                                        </div>
                                                    </div>
												</div>
											</div>
										</div>

										<div class="col-md-4 col-sm-4 col-xs-12">
											<div class="x_panel">
												<div class="x_title">
													<h2>
														<font style="font-size: 14px"><b>Búsqueda por Clientes</b></font>
													</h2>
													<div class="clearfix">
													</div>
												</div>
												<div class="x_content">
													<div class="row" style="margin-top: 8px">
														<div class="form-group col-md-5 col-sm-5 col-xs-12" style="text-align: right;">
	                                                        <div class="col-md-12 col-sm-12 col-xs-12">
	                                                            <input type="number" id="dni_cliente" placeholder="DNI / RUC de Cliente" class="form-control col-md-12 col-xs-12" onkeyup="f_BuscarClientes(1)">
	                                                        </div>
	                                                    </div>

	                                                    <div class="form-group col-md-7 col-sm-7 col-xs-12" style="text-align: left;">
	                                                        <div class="col-md-12 col-sm-12 col-xs-12">
	                                                            <input type="text" id="nom_cliente" placeholder="Nombre de Cliente" class="form-control col-md-12 col-xs-12" onkeyup="f_BuscarClientes(2)">
	                                                        </div>
	                                                    </div>
	                                                </div>

                                                    <div class="row" id="div_buscarclientes" style="display: none;">
                                                        <div class="row" style="background-color: #9CB6D9; height: 30px; border: solid; border-width: 1px; border-color: #829BCD; border-radius: 7px; text-align: center;">
                                                            <label style="margin-top: -5px"><h2><b><font color="#ffffff" style="font-size: 15px">
                                                                Búsqueda de Clientes
                                                            </font></b></h2></label>
                                                        </div>

                                                        <div class="row" id="div_sinclientes" style="border: solid; border-width: 1px; border-color: #D9D9D9; background-color: #F22727; color: #ffffff"><center>
                                                            No se encontraron resultados
                                                        </center></div>

                                                        <div class="row" style="overflow: auto; height: 150px">
                                                            <table class="table table-striped jambo_table bulk_action">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="width: 2%"><center>
                                                                            Item
                                                                        </center></th>
                                                                        <th style="width: 18%"><center>
                                                                            DNI / RUC Cliente
                                                                        </center></th>
                                                                        <th style="width: 80%"><center>
                                                                            Nombre Cliente
                                                                        </center></th>
                                                                    </tr>
                                                                </thead>

                                                                <tbody id="tabla_busquedaclientes">
                                                                    
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
												</div>
											</div>
										</div>

                                        <div class="col-md-2 col-sm-2 col-xs-12">
                                            <div class="x_panel">
                                                <div class="x_title">
                                                    <h2>
                                                        <font style="font-size: 14px"><b>Búsqueda por Sucursal</b></font>
                                                    </h2>
                                                    <div class="clearfix">
                                                    </div>
                                                </div>

                                                <div class="x_content">
                                                    <div class="row" style="margin-top: 8px">
                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                                <select id="lista_sucursal" class="form-control col-md-12 col-sm-12 col-xs-12" style="margin-top: 2px; text-align: left;" required>
                                                                    <option selected value="">Elija una opción...</option>

                                                                    <?php
                                                                        $s = 1;

                                                                        $q_sucursal = "SELECT   Id,
                                                                                                des_sucursal
                                                                                         FROM   _max_labperu_Sucursales
                                                                                        WHERE   estado_sucursal = 'A'";

                                                                        if ($res_sucursal = sqlsrv_query($enlacehost, $q_sucursal)) {
                                                                            while($row_sucursal = sqlsrv_fetch_array($res_sucursal)) {
                                                                                echo '<option value="'.$row_sucursal["Id"].'">'.$row_sucursal["des_sucursal"].'</option>';

                                                                                 $s += 1;
                                                                            }
                                                                        }
                                                                    ?>

                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-2 col-sm-2 col-xs-12">
                                            <div class="x_panel">
                                                <div class="x_title">
                                                    <h2>
                                                        <font style="font-size: 14px"><b>Búsqueda por Nombre Muestra</b></font>
                                                    </h2>
                                                    <div class="clearfix">
                                                    </div>
                                                </div>

                                                <div class="x_content">
                                                    <div class="row" style="margin-top: 8px">
                                                        <div class="form-group col-md-12 col-sm-12 col-xs-12" style="text-align: left;">
                                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                                <input type="text" id="nom_muestra" placeholder="Nombre Muestra" class="form-control col-md-12 col-xs-12">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

										<div class="col-md-10 col-sm-10 col-xs-10">
											<button class="btn btn-success" type="button" onclick="f_LoadResultados()" style="width: 100%; background-color: #26B99A">
                                                 <b>Ejecutar Búsqueda</b>
                                            </button>
										</div>

                                        <div class="col-md-2 col-sm-2 col-xs-2">
                                            <button class="btn btn-success" type="button" onclick="f_ClearBusqueda()" style="width: 100%; background-color: #3D3D3D">
                                                 <b>Limpiar Búsqueda</b>
                                            </button>
                                        </div>

                                        <div class="col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px">
                                            <div class="x_panel" style="border: solid; border-width: 1px; border-color: #D9D9D9; border-radius: 7px;">
                                                <div class="x_title">
                                                    <div class="col-md-6 col-sm-6 col-xs-6">
                                                        <h2>
                                                            Lista de Resultados
                                                        </h2>
                                                    </div>

                                                    <div class="col-md-6 col-sm-6 col-xs-6" style="text-align: right;">
                                                        <button class="btn btn-success" type="button" onclick="f_ExportToExcel()" style="background-color: #26B99A">
                                                             <b>Descargar a Excel</b>
                                                        </button>
                                                    </div>

                                                    <div class="clearfix">
                                                    </div>
                                                </div>

                                                <div class="x_content">
                                                    <div class="table-box" style="height: 1000px; overflow-y: scroll;">
                                                        <table class="table table-striped jambo_table bulk_action">
                                                            <thead>
                                                                <tr>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Item
                                                                    </center></th>
                                                                    <th rowspan="2" style=" border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Oficina
                                                                    </center></th>
                                                                    <th rowspan="2" style=" border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        N° Recibo
                                                                    </center></th>
                                                                    <th colspan="3" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Cliente
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Fecha Recepción
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Fecha Hora Entrega
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Medio Pago
                                                                    </center></th>
                                                                    <th colspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Muestra
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Elementos Análisis
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Peso Muestra (Kg)
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Estado Muestra
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Detalle Envase
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Tipo Muestra
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Tipo Análisis
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Precio Exceso
                                                                    </center></th>
                                                                    <th rowspan="2" style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Total Venta
                                                                    </center></th>
                                                                    <th colspan="2" rowspan="2" style="width: 7%;  border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle;"><center>
                                                                        Informe de Ensayos
                                                                    </center></th>
                                                                </tr>

                                                                <tr>
                                                                    <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #C2E0F2; color: #595959"><center>
                                                                        Nombres
                                                                    </center></th>
                                                                    <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #C2E0F2; color: #595959"><center>
                                                                        DNI / RUC
                                                                    </center></th>
                                                                    <th style="border: solid; border-width: 1px; border-color: #ffffff; vertical-align: middle; background-color: #C2E0F2; color: #595959"><center>
                                                                        Teléfonos
                                                                    </center></th>
                                                                    <th style="border: solid; border-width: 1px; border-color: #ffffff; background-color: #C2E0F2; vertical-align: middle; color: #595959"><center>
                                                                        Cód. Interno
                                                                    </center></th>
                                                                    <th style="border: solid; border-width: 1px; border-color: #ffffff; background-color: #C2E0F2; vertical-align: middle; color: #595959"><center>
                                                                        Nombre
                                                                    </center></th>
                                                                </tr>
                                                            </thead>

                                                            <tbody id="tabla_ventasresultados">
                                                                
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
        							</div>
        						</div>
        					</div>
        				</div>
        			</div>
        		</div>
      		</div>
      	</div>

        <!-- Ventanas modal -->
        <div id="divmodal_qr" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width: 50%; margin-top: 12%; margin-left: 25%">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">
                            &times;
                        </button>

                        <h4 class="modal-title"><b>
                            Código QR - Informe de Ensayos
                        </b></h4>
                    </div>

                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-md-5 col-sm-5 col-xs-12">
                                <label class="control-label col-md-6 col-sm-6 col-xs-12" style="margin-top: 6px">
                                    Nombre de Muestra
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12"><b>
                                    <input type="text" class="form-control col-md-12 col-xs-12" id="qr_muestra" style="text-align: center; background-color: #F2A71B" disabled/>
                                </b></div>
                            </div>

                            <div class="form-group col-md-7 col-sm-7 col-xs-12">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" style="text-align: right; margin-top: 6px">
                                    Análisis
                                </label>
                                <div class="col-md-8 col-sm-8 col-xs-12"><b>
                                    <input type="text" class="form-control col-md-12 col-xs-12" id="qr_analisis" style="text-align: center; background-color: #0455BF; color: #ffffff" disabled/>
                                </b></div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="ln_solid"></div>
                        </div>

                        <input id="qr_id_pedido" type="hidden">
                        <input id="qr_id_detallepedido" type="hidden">

                        <div class="row"><center>
                            <img id="img_qr" width="250px" style="border: solid; border-width: 1px; border-color: #D9D9D9; border-radius: 7px; cursor: pointer;" onclick="f_DownloadImg()"/>
                        </center></div>

                        <div class="row">
                            <div class="form-group col-md-12 col-sm-12 col-xs-12" style="text-align: center;">
                                <label style="cursor: pointer;" onclick="f_DownloadImg()"><u>
                                    Descargar Imagen QR
                                </u></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="divmodal_Loading" class="modal fade" role="dialog" data-backgrop="static" data-keyboard="false" style="margin-top: 300px;">
            <div class="modal-dialog" style="height: 200px; opacity: 0.5;"><center>
                <img src="images/loading.gif" width="200px" style="border: solid; border-width: 1px; border-color: #D9D9D9;  border-radius: 15px;"></img>
            </center></div>
        </div>

      	<!-- jQuery -->
	    <script src="../vendors/jquery/dist/jquery.min.js"></script>
	    <!-- Bootstrap -->
	    <script src="../vendors/bootstrap/dist/js/bootstrap.min.js"></script>
	    <!-- FastClick -->
	    <script src="../vendors/fastclick/lib/fastclick.js"></script>
	    <!-- NProgress -->
	    <script src="../vendors/nprogress/nprogress.js"></script>
	    <!-- Ion.RangeSlider -->
    	<script src="../vendors/ion.rangeSlider/js/ion.rangeSlider.min.js"></script>
    	<!-- Bootstrap Colorpicker -->
    	<script src="../vendors/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
	    <!-- Custom Theme Scripts -->
	    <script src="../build/js/custom.min.js"></script>

	    <!-- bootstrap-daterangepicker -->
	    <script src="../vendors/moment/min/moment.min.js"></script>
	    <script src="../vendors/bootstrap-daterangepicker/daterangepicker.js"></script><!-- Datatables -->
	    <script src="../vendors/datatables.net/js/jquery.dataTables.min.js"></script>
	    <script src="../vendors/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
	    <script src="../vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/buttons.flash.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/buttons.html5.min.js"></script>
	    <script src="../vendors/datatables.net-buttons/js/buttons.print.min.js"></script>
	    <script src="../vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js"></script>
	    <script src="../vendors/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
	    <script src="../vendors/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
	    <script src="../vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js"></script>
	    <script src="../vendors/datatables.net-scroller/js/dataTables.scroller.min.js"></script>
	    <script src="../vendors/jszip/dist/jszip.min.js"></script>
	    <script src="../vendors/pdfmake/build/pdfmake.min.js"></script>
	    <script src="../vendors/pdfmake/build/vfs_fonts.js"></script>

        <!-- Ventanas modales -->

	    <!-- Funciones de Búsqueda -->
	    <script type="text/javascript">
	    	// Buscando Clientes
                function f_BuscarClientes(tipo_busqueda){
                    var compania = <?php echo $_SESSION["bdOmar_Compania"]; ?>;
                    var htmlContenido = '';

                    if (tipo_busqueda == 1 || tipo_busqueda == 2){
                        var str_busqueda = ((tipo_busqueda == 1) ? $("#dni_cliente").val() : $("#nom_cliente").val());

                        $("#tabla_busquedaclientes").html(htmlContenido);
                    }
                    else{
                        var str_busqueda = ((tipo_busqueda == 3) ? $("#cliente_dni").val() : $("#cliente_nombre").val());

                        $("#tabla_busquedaclientes2").html(htmlContenido);
                    }

                    var c = 1;

                    $.post( "ajax/encuesta.php", { accion: "Get_Clientes", idCompany: compania, tipo_filtro: tipo_busqueda, filtro: str_busqueda }, 
                        function( data ) {
                            if(data.estado == 1){
                                $.each( data.registros, function( key, val ) {
                                    htmlContenido += '<tr style="cursor: pointer" onclick="f_AddCliente(' + tipo_busqueda + ', ' + val.iIdCliente + ', ' + val.cNumeroRuc + ", '" + val.cRazonSocial + "', " + val.id_Tipo_Documento + ", " + val.id_doc_sunat + ')">';

                                    htmlContenido += "  <td>" + c + "</td>";
                                    htmlContenido += "  <td><center>" + val.cNumeroRuc + "</center></td>";
                                    htmlContenido += "  <td>" + val.cRazonSocial + "</td>";

                                    htmlContenido += "</tr>";

                                    c += 1;
                                });
                            }

                            if (tipo_busqueda == 1 || tipo_busqueda == 2){
                                $("#tabla_busquedaclientes").html(htmlContenido);

                                 if (c == 1){
                                    f_CerrarDiv('A', 'div_sinclientes');
                                }
                                else{
                                    f_CerrarDiv('C', 'div_sinclientes');
                                }
                            }
                            else{
                                $("#tabla_busquedaclientes2").html(htmlContenido);

                                 if (c == 1){
                                    f_CerrarDiv('A', 'div_sinclientes2');
                                }
                                else{
                                    f_CerrarDiv('C', 'div_sinclientes2');
                                }
                            }

                        }, "json");

                    if (tipo_busqueda == 1 || tipo_busqueda == 2){
                        f_CerrarDiv('A', 'div_buscarclientes');
                    }
                    else{
                        f_CerrarDiv('A', 'div_buscarclientes2');
                    }
                };

            // Cargando Resultados
                function f_LoadResultados(){
                    var htmlContenido = '';

                    // Obteniendo filtros
                        var fecha_inicio = $("#fecha_inicio").val();
                        var fecha_fin = $("#fecha_fin").val();
                        var dni_cliente = $("#dni_cliente").val();
                        var nom_cliente = $("#nom_cliente").val();
                        var sucursal = $("#lista_sucursal").val();
                        var nom_muestra = $("#nom_muestra").val();

                    // Validando ingreso de filtros
                        if (fecha_inicio == null){
                            alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }
                        if (fecha_inicio.length == 0){
                            alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }

                        if (fecha_fin == null){
                            alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }
                        if (fecha_fin.length == 0){
                            alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                            return;
                        }

                        if (fecha_fin < fecha_inicio){
                            alert('La fecha "Desde" no puede ser mayor a la fecha "Hasta".\nPor favor, verificar.');

                            return;
                        }

                    // Loading Modal
                        var modal_loading = $("#divmodal_Loading");
                        modal_loading.modal({backdrop: 'static', keyboard: false});

                    // Carga resultados
                        var c = 1;
                        var _visible = 0;

                        $("#tabla_ventasresultados").html(htmlContenido);

                        $.post( "ajax/encuesta.php", { accion: "Get_ReporteVentas", fecha_inicio: fecha_inicio, fecha_fin: fecha_fin, dni_cliente: dni_cliente, nom_cliente: nom_cliente, Sucursal: sucursal, nom_muestra: nom_muestra }, 
                            function( data ) {
                                if(data.estado == 1){
                                    $.each( data.registros, function( key, val ) {
                                        htmlContenido += '<tr>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; text-align: right">' + c + '</td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242; background-color: ' + ((val.Sucursal == 1) ? '#D1DBBD' : '#D89196') + '"><center><b>' + val.des_sucursal + '</b></center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.NUM_RECIBO + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;">' + val.Nombre_Cliente.replace(/[*]/g, '').replace(/[&]/g, 'y') + '</td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;">' + val.Documento_Cliente + '</td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;">' + val.TELEFONO_CLIENTE + '</td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.FechaHora_Recepcion + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.FechaHora_Entrega + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.des_mediopago + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center>' + val.Cod_Interno + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle; color: #3F4242;"><center>' + val.Nom_Muestra + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.Elemento_Analisis + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.Peso_Muestra + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.Nombre_EstadoMuestra + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.Nombre_DetalleEnvase + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.Nombre_TipoMuestra + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + val.Des_TipoAnalisis + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + parseFloat(val.Precio_Exceso).toFixed(2) + '</center></td>';

                                        htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;"><center>' + parseFloat(val.Total_Venta).toFixed(2) + '</center></td>';

                                        if (val.Cod_EstadoResultadosCliente == 2){
                                            htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;" onclick="f_PrintDocumentosCliente(1, ' + val.Id_Pedido + ', ' + val.Id_Detalle + ", '" + val.Nombre_Cliente + "', '" + val.Nombre_TipoMuestra + "', '" + val.Nom_Muestra + "', " + val.Peso_Muestra + ", '" + val.Nombre_DetalleEnvase + "', '" + val.FechaHora_Recepcion2 + "', '" + val.FechaHora_Entrega2 + "', '" + val.Elemento_Analisis + "', " + val.Ley_Au_gt + ', ' + val.Ley_Au_ot + ', ' + val.Ley_Ag_gt + ', ' + val.Ley_Ag_ot + ', ' + val.Porc_CU + ', ' + val.Porc_PB + ', ' + val.Porc_ZN + ', ' + val.Porc_AS + ', ' + val.Porc_SB + ', ' + val.Porc_S + ', ' + val.Porc_FE + ', ' + val.Porc_H2O + ", '" + val.Fecha_Informe + "', '" + ((val.Observacion_Reporte == null) ? '' : val.Observacion_Reporte) + "', " + val.Documento_Cliente + ", '" + val.TELEFONO_CLIENTE + "', '" + val.cEmail + "', " + val.Sucursal + ", '" + val.NOMBRE_EMPRESA + "', " + val.Tipo_Muestra + ", '" + val.Des_TipoAnalisis + "', '" + val.Fecha_CierreInforme + "', '" + val.Referencia_Cliente + "', '" + val.Fecha_InicioEnsayo.substr(0, 10) + "', '" + val.Cod_Interno + "', " + val.Mostrar_Contacto + ')"><center>';
                                            htmlContenido += '      <img src="images/qr.png" width="30px"></img>';
                                            htmlContenido += '      <label style="cursor: pointer">QR</label>';
                                            htmlContenido += '</center></td>';

                                            htmlContenido += '  <td style="cursor: pointer; border: solid; border-width: 1px; border-color: #D9D9D9; vertical-align: middle;" onclick="f_PrintDocumentosCliente(2, ' + val.Id_Pedido + ', ' + val.Id_Detalle + ", '" + val.Nombre_Cliente + "', '" + val.Nombre_TipoMuestra + "', '" + val.Nom_Muestra + "', " + val.Peso_Muestra + ", '" + val.Nombre_DetalleEnvase + "', '" + val.FechaHora_Recepcion2 + "', '" + val.FechaHora_Entrega2 + "', '" + val.Elemento_Analisis + "', " + val.Ley_Au_gt + ', ' + val.Ley_Au_ot + ', ' + val.Ley_Ag_gt + ', ' + val.Ley_Ag_ot + ', ' + val.Porc_CU + ', ' + val.Porc_PB + ', ' + val.Porc_ZN + ', ' + val.Porc_AS + ', ' + val.Porc_SB + ', ' + val.Porc_S + ', ' + val.Porc_FE + ', ' + val.Porc_H2O + ", '" + val.Fecha_Informe + "', '" + ((val.Observacion_Reporte == null) ? '' : val.Observacion_Reporte) + "', " + val.Documento_Cliente + ", '" + val.TELEFONO_CLIENTE + "', '" + val.cEmail + "', " + val.Sucursal + ", '" + val.NOMBRE_EMPRESA + "', " + val.Tipo_Muestra + ", '" + val.Des_TipoAnalisis + "', '" + val.Fecha_CierreInforme + "', '" + val.Referencia_Cliente + "', '" + val.Fecha_InicioEnsayo.substr(0, 10) + "', '" + val.Cod_Interno + "', " + val.Mostrar_Contacto + ')"><center>';
                                            htmlContenido += '      <img src="images/certificacion.png" width="25px"></img>';
                                            htmlContenido += '      <label style="cursor: pointer">Informe</label>';
                                            htmlContenido += '</center></td>';
                                        }
                                        else{
                                            htmlContenido += '<td></td>';
                                            htmlContenido += '<td></td>';
                                        }

                                        htmlContenido += "</tr>";

                                        c += 1;
                                    });
                                }
                                else{
                                    alert("No se encontraron resultados para la búsqueda solicitada");
                                }

                                // Cerrando Modal
                                    $('#divmodal_Loading').modal('hide');

                                $("#tabla_ventasresultados").html(htmlContenido);
                            }, "json");
                };
	    </script>

	    <!-- Funciones Principales -->
	    <script type="text/javascript">
	    	function f_AddCliente(_tipo_busqueda, _id_cliente, _dni_cliente, _nombre_cliente, _IdDocCliente, _IdTipoDocSunat){
                if (_tipo_busqueda == 1 || _tipo_busqueda == 2){
                    $("#dni_cliente").val(_dni_cliente);
                    $("#nom_cliente").val(_nombre_cliente);

                    f_CerrarDiv('C', 'div_buscarclientes');
                }
                else{
                    $("#iIdCliente").val(_id_cliente);
                    $("#cliente_dni").val(_dni_cliente);
                    $("#cliente_nombre").val(_nombre_cliente);
                    $("#IdDocCliente").val(_IdDocCliente);
                    $("#IdTipoDocSunat").val(_IdTipoDocSunat);

                    f_CerrarDiv('C', 'div_buscarclientes2');
                }
            };

            function f_GetCorrelativoComprobante(){
                var tipo_comprobante = $("#lista_comprobante").val();
                var serie = $("#serie_comprobante").val();

                // Obtiene el Correlativo según el Tipo de Comprobante y la Serie
                    $.post( "ajax/encuesta.php", { accion: "Get_CorrelativoComprobante", Tipo_Comprobante: tipo_comprobante, NumSerie: serie }, 
                        function( data ) {
                            if(data.estado == 1){
                                $.each( data.registros, function( key, val ) {
                                    $("#num_comprobante").val((val.NUM_COMPROBANTE == null) ? '00000000' : val.NUM_COMPROBANTE);
                                });
                            }
                        }, "json");
            };

            function f_AddNewCliente(){
                var modal = $("#divmodal_AddNewCliente");

                $("#lista_tipocliente").val('');
                $("#lista_tipodocumento").val('');
                $("#cliente_dni").val($("#dni_cliente").val());
                $("#cliente_nombre").val($("#nom_cliente").val());
                $("#cliente_telefono1").val('');
                $("#cliente_telefono2").val('');
                $("#cliente_correo").val('');

                modal.modal({backdrop: 'static', keyboard: false});
            };

            function f_CalcularTotales(){
                var tipo_comprobante = $("#lista_comprobante").val();
                var inc_igv = $("#Inc_igv").val();

                // if (tipo_comprobante == 1001 || tipo_comprobante == 1003){
                    if (inc_igv == 'SI'){
                        $("#sub_total").html('<font color="#ffffff">' + parseFloat(total).toFixed(2) + '</font>');
                        $("#igv").html('<font color="#595959">' + parseFloat(total * 0.18).toFixed(2) + '</font>');
                        $("#total").html('<font color="#ffffff">' + parseFloat(total * 1.18).toFixed(2) + '</font>');
                    }
                    else{
                        $("#sub_total").html('<font color="#ffffff">' + parseFloat(total / 1.18).toFixed(2) + '</font>');
                        $("#igv").html('<font color="#595959">' + parseFloat(total - (total / 1.18)).toFixed(2) + '</font>');
                        $("#total").html('<font color="#ffffff">' + parseFloat(total).toFixed(2) + '</font>');
                    }
                // }
                // else{
                //     $("#total").html('<font color="#ffffff">0.00</font>');
                //     $("#igv").html('0.00');
                //     $("#sub_total").html('<font color="#ffffff">0.00</font>');
                // }
            };

            function f_ProcesarComprobante(){
                // Obteniendo valores globales
                    var id_pedido = $("#id_pedido").val();
                    var idCompany =  $("#idCompany").val();
                    var idTerminal =  $("#idTerminal").val();
                    var idTienda =  $("#idTienda").val();
                    var iIdUser =  $("#iIdUser").val();
                    var dateKey = $("#dateKey").val();
                    var inc_igv = $("#Inc_igv").val();

                // Validando datos
                    var lista_comprobante = $("#lista_comprobante").val();
                    var serie_comprobante = $("#serie_comprobante").val();
                    var num_comprobante = $("#num_comprobante").val();
                    var cliente_dni = $("#cliente_dni").val();
                    var cliente_nombre = $("#cliente_nombre").val();

                    if (lista_comprobante == null){
                        alert("Debe seleccionar el Tipo de Comprobante que desea generar");

                        return;
                    }
                    if (lista_comprobante.length == 0){
                        alert("Debe seleccionar el Tipo de Comprobante que desea generar");

                        return;
                    }

                    if (num_comprobante == null){
                        alert("Debe seleccionar el Número de Comprobante");

                        return;
                    }
                    if (num_comprobante.length == 0){
                        alert("Debe seleccionar el Número de Comprobante");

                        return;
                    }
                    if (num_comprobante <= 0){
                        alert("El número de Comprobante es incorrecto.\nPor favor, verificar");

                        return;
                    }

                // Por si cambia el cliente obtiene sus nuevos datos
                    var iIdCliente = $("#iIdCliente").val();
                    var IdDocCliente = $("#IdDocCliente").val();
                    var IdTipoDocSunat = $("#IdTipoDocSunat").val();

                // Procesando el Comprobante
                    $.post( "ajax/encuesta.php", { accion: "Procesar_Comprobante", id_pedido: id_pedido, idCompany: idCompany, idTerminal: idTerminal, idTienda: idTienda, iIdUser: iIdUser, dateKey: dateKey, iIdCliente: iIdCliente, cNombreCliente: cliente_nombre, IdDocCliente: IdDocCliente, IdTipoDocSunat: IdTipoDocSunat, cNumDocCliente: cliente_dni, idTipoDocPago: lista_comprobante, serie_comprobante: serie_comprobante, num_comprobante: num_comprobante, inc_igv: inc_igv },
                        function( data ) {
                            if(data.estado == 1){
                                alert("El Comprobante fue generado satisfactoriamente");

                                f_cerrarModal(1);
                                f_LoadResultados();
                            }
                            else{
                                alert("Ocurrió un error al momento de grabar el nuevo Cliente");
                            }

                        }, "json");

            };

            function f_PrintDocumentosCliente(_TipoDocumento, _Id_Pedido, _Id_DetallePedido, _Cliente, _TipoMuestra, _NomMuestra, _PesoMuestra, _Detalle_Envase, _Fecha_Recepcion, _Fecha_Entrega, _Elemento_Analisis, _Ley_Au_gt, _Ley_Au_ot, _Ley_Ag_gt, _Ley_Ag_ot, _Porc_CU, _Porc_PB, _Porc_ZN, _Porc_AS, _Porc_SB, _Porc_S, _Porc_FE, _Porc_H2O, _Fecha_Informe, _Obs_Reporte, _Documento_Cliente, _Telefono_Cliente, _Cliente_Email, _Sucursal, _Nombre_Empresa, _Cod_TipoMuestra, _Tipo_Ensayo, _Fecha_CierreInforme, _Referencia_Cliente, _Fecha_InicioEnsayo, _Codigo_Interno, _Mostrar_Contacto){

                var url = 'print_informeensayos_new.php?Id=' + _Id_Pedido + '&Id_Detalle=' + _Id_DetallePedido + '&Cli=' + _Cliente.replace(/[*]/g, '').replace(/[&]/g, 'y') + '&TM=' + _TipoMuestra + '&M=' + _NomMuestra + '&PM=' + _PesoMuestra + '&DE=' + _Detalle_Envase + '&FR=' + _Fecha_Recepcion + '&FE=' + _Fecha_Entrega + '&EA=' + _Elemento_Analisis + "&augt=" + _Ley_Au_gt + "&auot=" + _Ley_Au_ot + "&aggt=" + _Ley_Ag_gt + "&agot=" + _Ley_Ag_ot + "&cu=" + _Porc_CU + "&pb=" + _Porc_PB + "&zn=" + _Porc_ZN + "&as=" + _Porc_AS + "&sb=" + _Porc_SB + "&s=" + _Porc_S + "&fe=" + _Porc_FE + "&ho=" + _Porc_H2O + "&FI=" + _Fecha_Informe + "&Obs=" + _Obs_Reporte + "&DC=" + _Documento_Cliente + "&TC=" + _Telefono_Cliente + "&CEM=" + _Cliente_Email + "&S=" + _Sucursal + "&NE=" + _Nombre_Empresa.replace(/[*]/g, '').replace(/[&]/g, 'y') + "&CTM=" + _Cod_TipoMuestra + "&TE=" + _Tipo_Ensayo + "&FCI=" + _Fecha_CierreInforme + "&RC=" + _Referencia_Cliente + "&FIE=" + _Fecha_InicioEnsayo + "&CI=" + _Codigo_Interno + "&MC=" + _Mostrar_Contacto;

                if (_TipoDocumento == 2){
                    window.open(url, '_blank');
                }
                else{
                    $("#qr_id_pedido").val(_Id_Pedido);
                    $("#qr_id_detallepedido").val(_Id_DetallePedido);

                    // Generando la ruta de la imagen QR
                        var ruta = String(window.location);
                        ruta = ruta.substr(0, ruta.indexOf('usuario/'));
                        ruta = ruta + 'usuario/' + url.replace(/[ ]/g, '*');

                    var modal = $("#divmodal_qr");

                    $("#qr_muestra").val(_NomMuestra.trim());
                    $("#qr_analisis").val(_Elemento_Analisis.trim());

                    // Generando Código QR
                        $.post( "ajax/encuesta.php", { accion: "Generate_QR", url: ruta, Id_Pedido: _Id_Pedido, Id_DetallePedido: _Id_DetallePedido },
                            function( data ) {
                                if(data.estado == 1){
                                    var qr_name = 'tmp_qr_' + _Id_Pedido + _Id_DetallePedido + '.png';

                                    document.getElementById('img_qr').src='tmp_files/' + qr_name;
                                }
                            }, "json");

                    modal.modal({backdrop: 'static', keyboard: false});
                }
            };

            function f_DownloadImg(){
                var QR_Id_Pedido = $("#qr_id_pedido").val();
                var QR_Id_DetallePedido = $("#qr_id_detallepedido").val();
                var ruta = 'http://185.144.156.181/labperuminerals/panel/usuario/tmp_files/tmp_qr_' + QR_Id_Pedido + QR_Id_DetallePedido + '.png';

                var a = document.createElement('a');

                a.download = 'QR - ' + $("#qr_muestra").val();
                a.target = '_blank';
                a.href= ruta;

                a.click();              
            };

            function f_ExportToExcel(){
                // Obteniendo filtros
                    var fecha_inicio = $("#fecha_inicio").val();
                    var fecha_fin = $("#fecha_fin").val();
                    var dni_cliente = $("#dni_cliente").val();
                    var nom_cliente = $("#nom_cliente").val();
                    var sucursal = $("#lista_sucursal").val();
                    var nom_muestra = $("#nom_muestra").val();

                // Validando ingreso de filtros
                    if (fecha_inicio == null){
                        alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }
                    if (fecha_inicio.length == 0){
                        alert('La fecha "Desde" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }

                    if (fecha_fin == null){
                        alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }
                    if (fecha_fin.length == 0){
                        alert('La fecha "Hasta" ingresada no es correcta.\nPor favor, verificar.');

                        return;
                    }

                    if (fecha_fin < fecha_inicio){
                        alert('La fecha "Desde" no puede ser mayor a la fecha "Hasta".\nPor favor, verificar.');

                        return;
                    }

                window.location.href = "send_to_excel/export_to_excel_resumenventa.php?FI="+fecha_inicio+"&FF="+fecha_fin+"&DC="+dni_cliente+"&NC="+nom_cliente+"&S="+sucursal+"&NM="+nom_muestra;
            };
	    </script>

	    <!-- Cerrar DIV's -->
        <script type="text/javascript">
            function f_CerrarDiv(accion, nom_div){
                var _div = document.getElementById(nom_div);

                if (accion == 'A'){
                    _div.style.display = 'block'
                }
                else{
                     _div.style.display = 'none';
                }
            };
        </script>

	    <!-- Otras Funciones -->
	    <script type="text/javascript">
            // Cerrar ventanas modales
                function f_cerrarModal(pantalla_modal){
                    if (pantalla_modal == 1){
                        $('#divmodal_GenerarComprobante').modal('hide');
                    }

                    if (pantalla_modal == 2){
                        $('#divmodal_AddNewCliente').modal('hide');
                    }
                };

            // Limpiar controles de búsqueda
                function f_ClearBusqueda(){
                    var fecha = new Date();

                    fecha = fecha.getFullYear() + '-' + (((fecha.getMonth() + 1).toString().length == 1) ? '0' + (fecha.getMonth() + 1) : (fecha.getMonth() + 1)) + '-' + fecha.getDate();

                    $("#fecha_inicio").val(fecha);
                    $("#fecha_fin").val(fecha);
                    $("#dni_cliente").val('');
                    $("#nom_cliente").val('');
                    $("#lista_sucursal").val('');
                    $("#nom_muestra").val('');
                }

	    	window.addEventListener("keyup",function(e){
                if(e.keyCode==27) {
                    f_CerrarDiv('C', 'div_buscarclientes');
                    f_CerrarDiv('C', 'div_buscarclientes2');
                    f_CerrarDiv('C', 'div_RowAddElementos');
                }
            });
	    </script>
	</body>
</html>

<?php
	cerrarSesion($enlace);
?>